/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.reorg;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.refactoring.descriptors.DeleteDescriptor;
import org.eclipse.jdt.internal.core.manipulation.JavaElementLabelsCore;
import org.eclipse.jdt.internal.core.manipulation.JavaManipulationPlugin;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.core.refactoring.descriptors.RefactoringSignatureDescriptorFactory;
import org.eclipse.jdt.internal.corext.codemanipulation.GetterSetterUtil;
import org.eclipse.jdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringDescriptorUtil;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringAvailabilityTesterCore;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.changes.DynamicValidationRefactoringChange;
import org.eclipse.jdt.internal.corext.refactoring.participants.JavaProcessors;
import org.eclipse.jdt.internal.corext.refactoring.participants.ResourceProcessors;
import org.eclipse.jdt.internal.corext.refactoring.reorg.DeleteChangeCreator;
import org.eclipse.jdt.internal.corext.refactoring.reorg.DeleteModifications;
import org.eclipse.jdt.internal.corext.refactoring.reorg.IConfirmQuery;
import org.eclipse.jdt.internal.corext.refactoring.reorg.IReorgQueries;
import org.eclipse.jdt.internal.corext.refactoring.reorg.IsCompletelySelected;
import org.eclipse.jdt.internal.corext.refactoring.reorg.NullReorgQueries;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ParentChecker;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReadOnlyResourceFinder;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReorgUtilsCore;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.corext.util.Resources;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.DeleteProcessor;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.ResourceChangeChecker;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;

public final class JavaDeleteProcessor
extends DeleteProcessor {
    private static final String ATTRIBUTE_RESOURCES = "resources";
    private static final String ATTRIBUTE_ELEMENTS = "elements";
    private static final String ATTRIBUTE_SUGGEST_ACCESSORS = "accessors";
    private static final String ATTRIBUTE_DELETE_SUBPACKAGES = "subPackages";
    private boolean fAccessorsDeleted;
    private boolean fWasCanceled;
    private boolean fSuggestGetterSetterDeletion;
    private Object[] fElements;
    private IResource[] fResources;
    private IJavaElement[] fJavaElements;
    private IReorgQueries fDeleteQueries;
    private DeleteModifications fDeleteModifications;
    private Change fDeleteChange;
    private boolean fDeleteSubPackages;

    public JavaDeleteProcessor(Object[] elements) {
        this.fElements = elements;
        if (this.fElements != null) {
            this.fResources = RefactoringAvailabilityTesterCore.getResources(elements);
            this.fJavaElements = RefactoringAvailabilityTesterCore.getJavaElements(elements);
        }
        this.fSuggestGetterSetterDeletion = true;
        this.fDeleteSubPackages = false;
        this.fWasCanceled = false;
    }

    public JavaDeleteProcessor(JavaRefactoringArguments arguments, RefactoringStatus status) {
        this(null);
        RefactoringStatus initStatus = this.initialize(arguments);
        status.merge(initStatus);
    }

    public String getIdentifier() {
        return "org.eclipse.jdt.ui.DeleteProcessor";
    }

    public boolean isApplicable() throws CoreException {
        if (this.fElements.length == 0) {
            return false;
        }
        if (this.fElements.length != this.fResources.length + this.fJavaElements.length) {
            return false;
        }
        IResource[] iResourceArray = this.fResources;
        int n = this.fResources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (!RefactoringAvailabilityTesterCore.isDeleteAvailable(resource)) {
                return false;
            }
            ++n2;
        }
        iResourceArray = this.fJavaElements;
        n = this.fJavaElements.length;
        n2 = 0;
        while (n2 < n) {
            IResource javaElement = iResourceArray[n2];
            if (!RefactoringAvailabilityTesterCore.isDeleteAvailable((IJavaElement)javaElement)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public boolean needsProgressMonitor() {
        if (this.fResources != null && this.fResources.length > 0) {
            return true;
        }
        if (this.fJavaElements != null) {
            IJavaElement[] iJavaElementArray = this.fJavaElements;
            int n = this.fJavaElements.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaElement javaElement = iJavaElementArray[n2];
                int type = javaElement.getElementType();
                if (type <= 6) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public String getProcessorName() {
        return RefactoringCoreMessages.DeleteRefactoring_7;
    }

    public Object[] getElements() {
        return this.fElements;
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants shared) throws CoreException {
        return this.fDeleteModifications.loadParticipants(status, (RefactoringProcessor)this, this.getAffectedProjectNatures(), shared);
    }

    private String[] getAffectedProjectNatures() throws CoreException {
        String[] jNatures = JavaProcessors.computeAffectedNaturs(this.fJavaElements);
        String[] rNatures = ResourceProcessors.computeAffectedNatures(this.fResources);
        HashSet<String> result = new HashSet<String>(Arrays.asList(jNatures));
        result.addAll(Arrays.asList(rNatures));
        return result.toArray(new String[result.size()]);
    }

    public void setSuggestGetterSetterDeletion(boolean suggest) {
        this.fSuggestGetterSetterDeletion = suggest;
    }

    public void setDeleteSubPackages(boolean selection) {
        this.fDeleteSubPackages = selection;
    }

    public boolean getDeleteSubPackages() {
        return this.fDeleteSubPackages;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasSubPackagesToDelete() {
        try {
            IJavaElement[] iJavaElementArray = this.fJavaElements;
            int n = this.fJavaElements.length;
            int n2 = 0;
            while (true) {
                IPackageFragment packageFragment;
                if (n2 >= n) {
                    return false;
                }
                IJavaElement javaElement = iJavaElementArray[n2];
                if (javaElement instanceof IPackageFragment && !(packageFragment = (IPackageFragment)javaElement).isDefaultPackage() && packageFragment.hasSubpackages()) {
                    return true;
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            JavaManipulationPlugin.log(e);
        }
        return false;
    }

    public void setQueries(IReorgQueries queries) {
        Assert.isNotNull((Object)queries);
        this.fDeleteQueries = queries;
    }

    public IJavaElement[] getJavaElementsToDelete() {
        return this.fJavaElements;
    }

    public boolean wasCanceled() {
        return this.fWasCanceled;
    }

    public IResource[] getResourcesToDelete() {
        return this.fResources;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        boolean autoRefresh;
        int n;
        int n2;
        IResource[] iResourceArray;
        boolean autoRefresh2;
        Assert.isNotNull((Object)this.fDeleteQueries);
        RefactoringStatus result = new RefactoringStatus();
        IResource[] resources = ReorgUtilsCore.getNotLinked(this.fResources);
        IStatus status = Resources.checkInSync(resources);
        if (!status.isOK() && (autoRefresh2 = Platform.getPreferencesService().getBoolean("org.eclipse.core.resources", "refresh.lightweight.enabled", false, null))) {
            iResourceArray = resources;
            n2 = resources.length;
            n = 0;
            while (n < n2) {
                IResource resource = iResourceArray[n];
                try {
                    resource.refreshLocal(2, pm);
                }
                catch (CoreException e) {
                    break;
                }
                status = Resources.checkInSync(resources);
                ++n;
            }
        }
        result.merge(RefactoringStatus.create((IStatus)status));
        IResource[] javaResources = ReorgUtilsCore.getResources(this.fJavaElements);
        resources = ReorgUtilsCore.getNotNulls(javaResources);
        status = Resources.checkInSync(resources);
        if (!status.isOK() && (autoRefresh = Platform.getPreferencesService().getBoolean("org.eclipse.core.resources", "refresh.lightweight.enabled", false, null))) {
            IResource[] iResourceArray2 = resources;
            int n3 = resources.length;
            n2 = 0;
            while (n2 < n3) {
                IResource resource = iResourceArray2[n2];
                try {
                    resource.refreshLocal(2, pm);
                }
                catch (CoreException e) {
                    break;
                }
                status = Resources.checkInSync(resources);
                ++n2;
            }
        }
        result.merge(RefactoringStatus.create((IStatus)status));
        iResourceArray = this.fJavaElements;
        n2 = this.fJavaElements.length;
        n = 0;
        while (n < n2) {
            IResource element = iResourceArray[n];
            if (element instanceof IType) {
                ((IType)element).isAnonymous();
            }
            ++n;
        }
        return result;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException {
        pm.beginTask(RefactoringCoreMessages.DeleteRefactoring_1, 1);
        try {
            this.fWasCanceled = false;
            RefactoringStatus result = new RefactoringStatus();
            this.recalculateElementsToDelete();
            this.checkDirtyCompilationUnits(result);
            this.checkDirtyResources(result);
            this.fDeleteModifications = new DeleteModifications();
            this.fDeleteModifications.delete(this.fResources);
            this.fDeleteModifications.delete(this.fJavaElements);
            List<IResource> packageDeletes = this.fDeleteModifications.postProcess(pm);
            TextChangeManager manager = new TextChangeManager();
            this.fDeleteChange = DeleteChangeCreator.createDeleteChange(manager, this.fResources, this.fJavaElements, this.getProcessorName(), packageDeletes);
            ResourceChangeChecker checker = (ResourceChangeChecker)context.getChecker(ResourceChangeChecker.class);
            IResourceChangeDescriptionFactory deltaFactory = checker.getDeltaFactory();
            this.fDeleteModifications.buildDelta(deltaFactory);
            IFile[] iFileArray = ResourceUtil.getFiles(manager.getAllCompilationUnits());
            int n = iFileArray.length;
            int n2 = 0;
            while (n2 < n) {
                IFile file = iFileArray[n2];
                deltaFactory.change(file);
                ++n2;
            }
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        catch (OperationCanceledException e) {
            this.fWasCanceled = true;
            throw e;
        }
        finally {
            pm.done();
        }
    }

    private void checkDirtyCompilationUnits(RefactoringStatus result) throws CoreException {
        if (this.fJavaElements == null || this.fJavaElements.length == 0) {
            return;
        }
        IJavaElement[] iJavaElementArray = this.fJavaElements;
        int n = this.fJavaElements.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElement element = iJavaElementArray[n2];
            if (element instanceof ICompilationUnit) {
                this.checkDirtyCompilationUnit(result, (ICompilationUnit)element);
            } else if (element instanceof IPackageFragment) {
                ICompilationUnit[] iCompilationUnitArray = ((IPackageFragment)element).getCompilationUnits();
                int n3 = iCompilationUnitArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    ICompilationUnit unit = iCompilationUnitArray[n4];
                    this.checkDirtyCompilationUnit(result, unit);
                    ++n4;
                }
            }
            ++n2;
        }
    }

    private void checkDirtyCompilationUnit(RefactoringStatus result, ICompilationUnit cunit) {
        IResource resource = cunit.getResource();
        if (resource == null || resource.getType() != 1) {
            return;
        }
        this.checkDirtyFile(result, (IFile)resource);
    }

    private void checkDirtyResources(RefactoringStatus result) throws CoreException {
        IResource[] iResourceArray = this.fResources;
        int n = this.fResources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            resource.accept(visitedResource -> {
                if (visitedResource instanceof IFile) {
                    this.checkDirtyFile(result, (IFile)visitedResource);
                }
                return true;
            }, 2, false);
            ++n2;
        }
    }

    private void checkDirtyFile(RefactoringStatus result, IFile file) {
        if (file == null || !file.exists()) {
            return;
        }
        ITextFileBuffer buffer = FileBuffers.getTextFileBufferManager().getTextFileBuffer(file.getFullPath(), LocationKind.IFILE);
        if (buffer != null && buffer.isDirty()) {
            if (buffer.isStateValidated() && buffer.isSynchronized()) {
                result.addWarning(Messages.format(RefactoringCoreMessages.JavaDeleteProcessor_unsaved_changes, BasicElementLabels.getPathLabel(file.getFullPath(), false)));
            } else {
                result.addFatalError(Messages.format(RefactoringCoreMessages.JavaDeleteProcessor_unsaved_changes, BasicElementLabels.getPathLabel(file.getFullPath(), false)));
            }
        }
    }

    private void recalculateElementsToDelete() throws CoreException {
        this.fAccessorsDeleted = false;
        if (this.fDeleteSubPackages) {
            this.addSubPackages();
        }
        this.removeElementsWithParentsInSelection();
        this.removeUnconfirmedFoldersThatContainSourceFolders();
        this.removeUnconfirmedReferencedArchives();
        this.addEmptyCusToDelete();
        this.removeJavaElementsChildrenOfJavaElements();
        this.confirmDeletingReadOnly();
        if (this.fSuggestGetterSetterDeletion) {
            this.addGettersSetters();
        }
        this.addDeletableParentPackagesOnPackageDeletion();
    }

    private void addSubPackages() throws JavaModelException {
        HashSet<Object> javaElements = new HashSet<Object>();
        IJavaElement[] iJavaElementArray = this.fJavaElements;
        int n = this.fJavaElements.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElement javaElement = iJavaElementArray[n2];
            if (javaElement instanceof IPackageFragment) {
                javaElements.addAll(Arrays.asList(JavaElementUtil.getPackageAndSubpackages((IPackageFragment)javaElement)));
            } else {
                javaElements.add(javaElement);
            }
            ++n2;
        }
        this.fJavaElements = javaElements.toArray(new IJavaElement[javaElements.size()]);
    }

    private void addDeletableParentPackagesOnPackageDeletion() throws CoreException {
        List<IPackageFragment> initialPackagesToDelete = ReorgUtilsCore.getElementsOfType(this.fJavaElements, 4);
        if (initialPackagesToDelete.isEmpty()) {
            return;
        }
        Collections.sort(initialPackagesToDelete, Comparator.comparing(IPackageFragment::getElementName).reversed());
        HashSet<IResource> deletedChildren = new HashSet<IResource>(Arrays.asList(this.fResources));
        IJavaElement[] iJavaElementArray = this.fJavaElements;
        int n = this.fJavaElements.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElement javaElement = iJavaElementArray[n2];
            if (!ReorgUtilsCore.isInsideCompilationUnit(javaElement)) {
                deletedChildren.add(javaElement.getResource());
            }
            ++n2;
        }
        LinkedHashSet<IPackageFragment> allFragmentsToDelete = new LinkedHashSet<IPackageFragment>();
        IsCompletelySelected isCompletelySelected = new IsCompletelySelected(initialPackagesToDelete);
        HashSet<IPackageFragment> packagesToDelete = new HashSet<IPackageFragment>(initialPackagesToDelete);
        for (IPackageFragment currentPackageFragment : initialPackagesToDelete) {
            IPackageFragment parent;
            allFragmentsToDelete.add(currentPackageFragment);
            if (!isCompletelySelected.test(currentPackageFragment) || (parent = JavaElementUtil.getParentSubpackage(currentPackageFragment)) == null || packagesToDelete.contains(parent)) continue;
            ArrayList<IPackageFragment> emptyParents = new ArrayList<IPackageFragment>();
            this.addDeletableParentPackages(parent, packagesToDelete, deletedChildren, emptyParents);
            allFragmentsToDelete.addAll(emptyParents);
        }
        ArrayList<Object> javaElements = new ArrayList<Object>();
        IJavaElement[] iJavaElementArray2 = this.fJavaElements;
        int n3 = this.fJavaElements.length;
        int parent = 0;
        while (parent < n3) {
            IPackageFragment frag;
            IJavaElement javaElement = iJavaElementArray2[parent];
            if (!(javaElement instanceof IPackageFragment) && !allFragmentsToDelete.contains(frag = (IPackageFragment)javaElement.getAncestor(4))) {
                javaElements.add(javaElement);
            }
            ++parent;
        }
        javaElements.addAll(allFragmentsToDelete);
        ArrayList<IResource> resources = new ArrayList<IResource>();
        IResource[] iResourceArray = this.fResources;
        int n4 = this.fResources.length;
        n3 = 0;
        while (n3 < n4) {
            IResource resource = iResourceArray[n3];
            IContainer parent2 = resource.getParent();
            if (!deletedChildren.contains(parent2)) {
                resources.add(resource);
            }
            ++n3;
        }
        this.fJavaElements = javaElements.toArray(new IJavaElement[javaElements.size()]);
        this.fResources = resources.toArray(new IResource[resources.size()]);
    }

    private void addDeletableParentPackages(IPackageFragment frag, Collection<IPackageFragment> initialPackagesToDelete, Set<IResource> resourcesToDelete, List<IPackageFragment> deletableParentPackages) throws CoreException {
        IConfirmQuery query;
        if (frag.getResource().isLinked() && !(query = this.fDeleteQueries.createYesNoQuery(RefactoringCoreMessages.JavaDeleteProcessor_confirm_linked_folder_delete, false, 8)).confirm(Messages.format(RefactoringCoreMessages.JavaDeleteProcessor_delete_linked_folder_question, BasicElementLabels.getResourceName(frag.getResource())))) {
            return;
        }
        IResource[] iResourceArray = ((IContainer)frag.getResource()).members();
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource child = iResourceArray[n2];
            if (!resourcesToDelete.contains(child)) {
                return;
            }
            ++n2;
        }
        resourcesToDelete.add(frag.getResource());
        deletableParentPackages.add(frag);
        IPackageFragment parent = JavaElementUtil.getParentSubpackage(frag);
        if (parent != null && !initialPackagesToDelete.contains(parent)) {
            this.addDeletableParentPackages(parent, initialPackagesToDelete, resourcesToDelete, deletableParentPackages);
        }
    }

    private void removeUnconfirmedReferencedArchives() throws JavaModelException {
        String queryTitle = RefactoringCoreMessages.DeleteRefactoring_2;
        IConfirmQuery query = this.fDeleteQueries.createYesYesToAllNoNoToAllQuery(queryTitle, true, 3);
        this.removeUnconfirmedReferencedPackageFragmentRoots(query);
        this.removeUnconfirmedReferencedArchiveFiles(query);
    }

    private void removeUnconfirmedReferencedArchiveFiles(IConfirmQuery query) throws JavaModelException, OperationCanceledException {
        ArrayList<IResource> filesToSkip = new ArrayList<IResource>(0);
        IResource[] iResourceArray = this.fResources;
        int n = this.fResources.length;
        int n2 = 0;
        while (n2 < n) {
            List<IJavaProject> referencingProjects;
            IPackageFragmentRoot root;
            IJavaProject project;
            IResource resource = iResourceArray[n2];
            if (resource instanceof IFile && (project = JavaCore.create((IProject)resource.getProject())) != null && project.exists() && (root = project.findPackageFragmentRoot(resource.getFullPath())) != null && JavaDeleteProcessor.skipDeletingReferencedRoot(query, root, referencingProjects = Arrays.asList(JavaElementUtil.getReferencingProjects(root)))) {
                filesToSkip.add(resource);
            }
            ++n2;
        }
        this.removeFromSetToDelete((IResource[])filesToSkip.toArray(new IFile[filesToSkip.size()]));
    }

    private void removeUnconfirmedReferencedPackageFragmentRoots(IConfirmQuery query) throws JavaModelException, OperationCanceledException {
        ArrayList<IPackageFragmentRoot> rootsToSkip = new ArrayList<IPackageFragmentRoot>(0);
        IJavaElement[] iJavaElementArray = this.fJavaElements;
        int n = this.fJavaElements.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElement element = iJavaElementArray[n2];
            if (element instanceof IPackageFragmentRoot) {
                IPackageFragmentRoot root = (IPackageFragmentRoot)element;
                ArrayList<IJavaProject> referencingProjects = new ArrayList<IJavaProject>(Arrays.asList(JavaElementUtil.getReferencingProjects(root)));
                referencingProjects.remove(root.getJavaProject());
                if (JavaDeleteProcessor.skipDeletingReferencedRoot(query, root, referencingProjects)) {
                    rootsToSkip.add(root);
                }
            }
            ++n2;
        }
        this.removeFromSetToDelete(rootsToSkip.toArray(new IJavaElement[rootsToSkip.size()]));
    }

    private static boolean skipDeletingReferencedRoot(IConfirmQuery query, IPackageFragmentRoot root, List<IJavaProject> referencingProjects) throws OperationCanceledException {
        if (referencingProjects.isEmpty() || root == null || !root.exists() || !root.isArchive()) {
            return false;
        }
        String label = JavaElementLabelsCore.getElementLabel((IJavaElement)root, 0x200009L);
        String question = referencingProjects.size() == 1 ? Messages.format(RefactoringCoreMessages.DeleteRefactoring_3_singular, label) : Messages.format(RefactoringCoreMessages.DeleteRefactoring_3_plural, label);
        return !query.confirm(question, referencingProjects.toArray());
    }

    private void removeUnconfirmedFoldersThatContainSourceFolders() throws CoreException {
        String queryTitle = RefactoringCoreMessages.DeleteRefactoring_4;
        IConfirmQuery query = this.fDeleteQueries.createYesYesToAllNoNoToAllQuery(queryTitle, true, 4);
        ArrayList<IFolder> foldersToSkip = new ArrayList<IFolder>(0);
        IResource[] iResourceArray = this.fResources;
        int n = this.fResources.length;
        int n2 = 0;
        while (n2 < n) {
            String question;
            IFolder folder;
            IResource resource = iResourceArray[n2];
            if (resource instanceof IFolder && JavaDeleteProcessor.containsSourceFolder(folder = (IFolder)resource) && !query.confirm(question = Messages.format(RefactoringCoreMessages.DeleteRefactoring_5, BasicElementLabels.getResourceName((IResource)folder)))) {
                foldersToSkip.add(folder);
            }
            ++n2;
        }
        this.removeFromSetToDelete(foldersToSkip.toArray(new IResource[foldersToSkip.size()]));
    }

    private static boolean containsSourceFolder(IFolder folder) throws CoreException {
        IResource[] iResourceArray = folder.members();
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource subFolder = iResourceArray[n2];
            if (subFolder instanceof IFolder) {
                IJavaElement element = JavaCore.create((IFolder)folder);
                if (element instanceof IPackageFragmentRoot) {
                    return true;
                }
                if (!(element instanceof IPackageFragment) && JavaDeleteProcessor.containsSourceFolder((IFolder)subFolder)) {
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }

    private void removeElementsWithParentsInSelection() {
        ParentChecker parentUtil = new ParentChecker(this.fResources, this.fJavaElements);
        parentUtil.removeElementsWithAncestorsOnList(false);
        this.fJavaElements = parentUtil.getJavaElements();
        this.fResources = parentUtil.getResources();
    }

    private void removeJavaElementsChildrenOfJavaElements() {
        ParentChecker parentUtil = new ParentChecker(this.fResources, this.fJavaElements);
        parentUtil.removeElementsWithAncestorsOnList(true);
        this.fJavaElements = parentUtil.getJavaElements();
    }

    public Change createChange(IProgressMonitor monitor) throws CoreException {
        try {
            monitor.beginTask(RefactoringCoreMessages.JavaDeleteProcessor_creating_change, 1);
            HashMap<String, String> arguments = new HashMap<String, String>();
            String description = this.fElements.length == 1 ? RefactoringCoreMessages.JavaDeleteProcessor_description_singular : RefactoringCoreMessages.JavaDeleteProcessor_description_plural;
            IProject resource = this.getSingleProject();
            String project = resource != null ? resource.getName() : null;
            String source = project != null ? Messages.format(RefactoringCoreMessages.JavaDeleteProcessor_project_pattern, BasicElementLabels.getJavaElementName(project)) : RefactoringCoreMessages.JavaDeleteProcessor_workspace;
            String header = this.fElements.length == 1 ? Messages.format(RefactoringCoreMessages.JavaDeleteProcessor_header_singular, source) : Messages.format(RefactoringCoreMessages.JavaDeleteProcessor_header_plural, new String[]{String.valueOf(this.fElements.length), source});
            int flags = 589830;
            JDTRefactoringDescriptorComment comment = new JDTRefactoringDescriptorComment(project, (Object)this, header);
            if (this.fDeleteSubPackages) {
                comment.addSetting(RefactoringCoreMessages.JavaDeleteProcessor_delete_subpackages);
            }
            if (this.fAccessorsDeleted) {
                comment.addSetting(RefactoringCoreMessages.JavaDeleteProcessor_delete_accessors);
            }
            DeleteDescriptor descriptor = RefactoringSignatureDescriptorFactory.createDeleteDescriptor(project, description, comment.asString(), arguments, flags);
            arguments.put(ATTRIBUTE_DELETE_SUBPACKAGES, Boolean.toString(this.fDeleteSubPackages));
            arguments.put(ATTRIBUTE_SUGGEST_ACCESSORS, Boolean.toString(this.fSuggestGetterSetterDeletion));
            arguments.put(ATTRIBUTE_RESOURCES, Integer.toString(this.fResources.length));
            int offset = 0;
            while (offset < this.fResources.length) {
                arguments.put("element" + (offset + 1), JavaRefactoringDescriptorUtil.resourceToHandle(project, this.fResources[offset]));
                ++offset;
            }
            arguments.put(ATTRIBUTE_ELEMENTS, Integer.toString(this.fJavaElements.length));
            offset = 0;
            while (offset < this.fJavaElements.length) {
                arguments.put("element" + (offset + this.fResources.length + 1), JavaRefactoringDescriptorUtil.elementToHandle(project, this.fJavaElements[offset]));
                ++offset;
            }
            DynamicValidationRefactoringChange dynamicValidationRefactoringChange = new DynamicValidationRefactoringChange(descriptor, RefactoringCoreMessages.DeleteRefactoring_7, new Change[]{this.fDeleteChange});
            return dynamicValidationRefactoringChange;
        }
        finally {
            monitor.done();
        }
    }

    private IProject getSingleProject() {
        IProject first = null;
        Object[] objectArray = this.fElements;
        int n = this.fElements.length;
        int n2 = 0;
        while (n2 < n) {
            Object javaElement = objectArray[n2];
            IProject project = null;
            if (javaElement instanceof IJavaElement) {
                project = ((IJavaElement)javaElement).getJavaProject().getProject();
            } else if (javaElement instanceof IResource) {
                project = ((IResource)javaElement).getProject();
            }
            if (project != null) {
                if (first == null) {
                    first = project;
                } else if (!project.equals((Object)first)) {
                    return null;
                }
            }
            ++n2;
        }
        return first;
    }

    private void addToSetToDelete(IJavaElement[] newElements) {
        this.fJavaElements = ReorgUtilsCore.union(this.fJavaElements, newElements);
    }

    private void removeFromSetToDelete(IResource[] resourcesToNotDelete) {
        this.fResources = ReorgUtilsCore.setMinus(this.fResources, resourcesToNotDelete);
    }

    private void removeFromSetToDelete(IJavaElement[] elementsToNotDelete) {
        this.fJavaElements = ReorgUtilsCore.setMinus(this.fJavaElements, elementsToNotDelete);
    }

    private void addGettersSetters() throws JavaModelException {
        IField[] fields = JavaDeleteProcessor.getFields(this.fJavaElements);
        if (fields.length == 0) {
            return;
        }
        Map<IField, IMethod[]> getterSetterMapping = JavaDeleteProcessor.createGetterSetterMapping(fields);
        if (getterSetterMapping.isEmpty()) {
            return;
        }
        this.removeAlreadySelectedMethods(getterSetterMapping);
        if (getterSetterMapping.isEmpty()) {
            return;
        }
        this.fAccessorsDeleted = true;
        List<IMethod> gettersSettersToAdd = this.getGettersSettersToDelete(getterSetterMapping);
        this.addToSetToDelete((IJavaElement[])gettersSettersToAdd.toArray(new IMethod[gettersSettersToAdd.size()]));
    }

    private List<IMethod> getGettersSettersToDelete(Map<IField, IMethod[]> getterSetterMapping) {
        ArrayList<IMethod> gettersSettersToAdd = new ArrayList<IMethod>(getterSetterMapping.size());
        String queryTitle = RefactoringCoreMessages.DeleteRefactoring_8;
        IConfirmQuery getterSetterQuery = this.fDeleteQueries.createYesYesToAllNoNoToAllQuery(queryTitle, true, 1);
        for (IField field : getterSetterMapping.keySet()) {
            Assert.isTrue((JavaDeleteProcessor.hasGetter(getterSetterMapping, field) || JavaDeleteProcessor.hasSetter(getterSetterMapping, field) ? 1 : 0) != 0);
            String deleteGetterSetter = Messages.format(RefactoringCoreMessages.DeleteRefactoring_9, JavaElementUtil.createFieldSignature(field));
            if (!getterSetterQuery.confirm(deleteGetterSetter)) continue;
            if (JavaDeleteProcessor.hasGetter(getterSetterMapping, field)) {
                gettersSettersToAdd.add(JavaDeleteProcessor.getGetter(getterSetterMapping, field));
            }
            if (!JavaDeleteProcessor.hasSetter(getterSetterMapping, field)) continue;
            gettersSettersToAdd.add(JavaDeleteProcessor.getSetter(getterSetterMapping, field));
        }
        return gettersSettersToAdd;
    }

    private void removeAlreadySelectedMethods(Map<IField, IMethod[]> getterSetterMapping) {
        List<IJavaElement> elementsToDelete = Arrays.asList(this.fJavaElements);
        Iterator<IField> iter = getterSetterMapping.keySet().iterator();
        while (iter.hasNext()) {
            IMethod setter;
            IField field = iter.next();
            IMethod getter = JavaDeleteProcessor.getGetter(getterSetterMapping, field);
            if (getter != null && elementsToDelete.contains(getter)) {
                JavaDeleteProcessor.removeGetterFromMapping(getterSetterMapping, field);
            }
            if ((setter = JavaDeleteProcessor.getSetter(getterSetterMapping, field)) != null && elementsToDelete.contains(setter)) {
                JavaDeleteProcessor.removeSetterFromMapping(getterSetterMapping, field);
            }
            if (JavaDeleteProcessor.hasGetter(getterSetterMapping, field) || JavaDeleteProcessor.hasSetter(getterSetterMapping, field)) continue;
            iter.remove();
        }
    }

    private static Map<IField, IMethod[]> createGetterSetterMapping(IField[] fields) throws JavaModelException {
        HashMap<IField, IMethod[]> result = new HashMap<IField, IMethod[]>();
        IField[] iFieldArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            IField field = iFieldArray[n2];
            IMethod[] getterSetter = JavaDeleteProcessor.getGetterSetter(field);
            if (getterSetter != null) {
                result.put(field, getterSetter);
            }
            ++n2;
        }
        return result;
    }

    private static boolean hasSetter(Map<IField, IMethod[]> getterSetterMapping, IField field) {
        return getterSetterMapping.containsKey(field) && JavaDeleteProcessor.getSetter(getterSetterMapping, field) != null;
    }

    private static boolean hasGetter(Map<IField, IMethod[]> getterSetterMapping, IField field) {
        return getterSetterMapping.containsKey(field) && JavaDeleteProcessor.getGetter(getterSetterMapping, field) != null;
    }

    private static void removeGetterFromMapping(Map<IField, IMethod[]> getterSetterMapping, IField field) {
        getterSetterMapping.get((Object)field)[0] = null;
    }

    private static void removeSetterFromMapping(Map<IField, IMethod[]> getterSetterMapping, IField field) {
        getterSetterMapping.get((Object)field)[1] = null;
    }

    private static IMethod getGetter(Map<IField, IMethod[]> getterSetterMapping, IField field) {
        return getterSetterMapping.get(field)[0];
    }

    private static IMethod getSetter(Map<IField, IMethod[]> getterSetterMapping, IField field) {
        return getterSetterMapping.get(field)[1];
    }

    private static IField[] getFields(IJavaElement[] elements) {
        ArrayList<IJavaElement> fields = new ArrayList<IJavaElement>(3);
        IJavaElement[] iJavaElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElement element = iJavaElementArray[n2];
            if (element instanceof IField) {
                fields.add(element);
            }
            ++n2;
        }
        return fields.toArray(new IField[fields.size()]);
    }

    private static IMethod[] getGetterSetter(IField field) throws JavaModelException {
        IMethod getter = GetterSetterUtil.getGetter(field);
        IMethod setter = GetterSetterUtil.getSetter(field);
        if (getter != null && getter.exists() || setter != null && setter.exists()) {
            return new IMethod[]{getter, setter};
        }
        return null;
    }

    private void confirmDeletingReadOnly() throws CoreException {
        if (!ReadOnlyResourceFinder.confirmDeleteOfReadOnlyElements(this.fJavaElements, this.fResources, this.fDeleteQueries)) {
            throw new OperationCanceledException();
        }
    }

    private void addEmptyCusToDelete() throws JavaModelException {
        Set<ICompilationUnit> cusToEmpty = this.getCusToEmpty();
        this.addToSetToDelete((IJavaElement[])cusToEmpty.toArray(new ICompilationUnit[cusToEmpty.size()]));
    }

    private Set<ICompilationUnit> getCusToEmpty() throws JavaModelException {
        HashSet<IJavaElement> deletedElements = new HashSet<IJavaElement>(Arrays.asList(this.fJavaElements));
        HashSet<ICompilationUnit> result = new HashSet<ICompilationUnit>();
        IJavaElement[] iJavaElementArray = this.fJavaElements;
        int n = this.fJavaElements.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElement element = iJavaElementArray[n2];
            ICompilationUnit cu = ReorgUtilsCore.getCompilationUnit(element);
            if (cu != null && !result.contains(cu) && deletedElements.containsAll(JavaDeleteProcessor.topLevelTypes(cu))) {
                result.add(cu);
            }
            ++n2;
        }
        return result;
    }

    private static List<IType> topLevelTypes(ICompilationUnit cu) throws JavaModelException {
        return Arrays.asList(cu.getTypes());
    }

    private RefactoringStatus initialize(JavaRefactoringArguments extended) {
        String attribute;
        this.setQueries(new NullReorgQueries());
        RefactoringStatus status = new RefactoringStatus();
        String subPackages = extended.getAttribute(ATTRIBUTE_DELETE_SUBPACKAGES);
        if (subPackages == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_DELETE_SUBPACKAGES));
        }
        this.fDeleteSubPackages = Boolean.parseBoolean(subPackages);
        String suggest = extended.getAttribute(ATTRIBUTE_SUGGEST_ACCESSORS);
        if (suggest == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_SUGGEST_ACCESSORS));
        }
        this.fSuggestGetterSetterDeletion = Boolean.parseBoolean(suggest);
        int resourceCount = 0;
        int elementCount = 0;
        String value = extended.getAttribute(ATTRIBUTE_RESOURCES);
        if (value != null && !"".equals(value)) {
            try {
                resourceCount = Integer.parseInt(value);
            }
            catch (NumberFormatException exception) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_RESOURCES));
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_RESOURCES));
        }
        value = extended.getAttribute(ATTRIBUTE_ELEMENTS);
        if (value != null && !"".equals(value)) {
            try {
                elementCount = Integer.parseInt(value);
            }
            catch (NumberFormatException exception) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_ELEMENTS));
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_ELEMENTS));
        }
        String handle = null;
        ArrayList<Object> elements = new ArrayList<Object>();
        int index = 0;
        while (index < resourceCount) {
            attribute = "element" + (index + 1);
            handle = extended.getAttribute(attribute);
            if (handle != null && !"".equals(handle)) {
                IResource resource = JavaRefactoringDescriptorUtil.handleToResource(extended.getProject(), handle);
                if (resource == null || !resource.exists()) {
                    status.merge(JavaRefactoringDescriptorUtil.createInputWarningStatus(resource, this.getProcessorName(), "org.eclipse.jdt.ui.delete"));
                } else {
                    elements.add(resource);
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, attribute));
            }
            ++index;
        }
        this.fResources = elements.toArray(new IResource[elements.size()]);
        elements = new ArrayList();
        index = 0;
        while (index < elementCount) {
            attribute = "element" + (resourceCount + index + 1);
            handle = extended.getAttribute(attribute);
            if (handle != null && !"".equals(handle)) {
                IJavaElement element = JavaRefactoringDescriptorUtil.handleToElement(extended.getProject(), handle, false);
                if (element == null || !element.exists()) {
                    status.merge(JavaRefactoringDescriptorUtil.createInputWarningStatus(element, this.getProcessorName(), "org.eclipse.jdt.ui.delete"));
                } else {
                    elements.add(element);
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, attribute));
            }
            ++index;
        }
        this.fJavaElements = elements.toArray(new IJavaElement[elements.size()]);
        this.fElements = new Object[this.fResources.length + this.fJavaElements.length];
        System.arraycopy(this.fResources, 0, this.fElements, 0, this.fResources.length);
        System.arraycopy(this.fJavaElements, 0, this.fElements, this.fResources.length, this.fJavaElements.length);
        return status;
    }
}

