/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.cadence.core.internal;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;

public final class CadenceExtensions {
    public static final String ATT_IDENTIFIER = "Identifier";
    public static final String ATT_NAME = "Name";
    public static final String ATT_DESCRIPTION = "Description";
    public static final String ATT_PARAMETER_DEFINITION = "ParameterDefinition";
    public static final String ATT_TYPE = "Type";
    public static final String ATT_ACTIVITY_CLASS = "ActivityClass";
    public static final String ATT_WORKFLOW_ELEMENT = "WorkflowElement";
    public static final String ATT_ACTIVITY__WORKFLOW = "WorkflowIdentifier";
    public static final String ATT_ACTIVITY__WORKFLOW_ELEMENT = "WorkflowElementIdentifier";
    public static final String PARAMETER_DEFINITION = "ParameterDefinition";
    public static final String ATT_ORDER_NUMBER = "orderNumber";
    public static final String ATT_MULTIPLE_CONTRIBUTIONS = "AllowMultipleContributions";
    public static final String ATT_MULTIPLE_ACTIVTY = "Multiple";
    private static final String ACTIVITY_ID = "org.polarsys.kitalpha.cadence.core.activity.declaration";
    private static final String WORKFLOW_ID = "org.polarsys.kitalpha.cadence.core.workflow.declaration";

    public static IConfigurationElement[] getAllWorkflowsExtensions() {
        return CadenceExtensions.getExtensionElt(WORKFLOW_ID);
    }

    public static IConfigurationElement[] getActivitiesForWorkflowElement(String workflow_id, String workflowElt_id) {
        IConfigurationElement[] configElements = CadenceExtensions.getAllActivityDeclaration();
        ArrayList<IConfigurationElement> activities = new ArrayList<IConfigurationElement>();
        IConfigurationElement[] iConfigurationElementArray = configElements;
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement elt = iConfigurationElementArray[n2];
            if (elt.getAttribute(ATT_ACTIVITY__WORKFLOW).equals(workflow_id) && elt.getAttribute(ATT_ACTIVITY__WORKFLOW_ELEMENT).equals(workflowElt_id)) {
                activities.add(elt);
            }
            ++n2;
        }
        return activities.toArray(new IConfigurationElement[0]);
    }

    public static IConfigurationElement getActivityConfigElement(String identifier) {
        IConfigurationElement configuration = null;
        IConfigurationElement[] configElements = CadenceExtensions.getAllActivityDeclaration();
        if (configElements != null) {
            IConfigurationElement[] iConfigurationElementArray = configElements;
            int n = configElements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement elt = iConfigurationElementArray[n2];
                if (elt.getAttribute(ATT_IDENTIFIER).equals(identifier)) {
                    configuration = elt;
                }
                ++n2;
            }
        }
        return configuration;
    }

    private static IConfigurationElement[] getExtensionElt(String id) {
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(id);
        IExtension[] extensions = point.getExtensions();
        ArrayList<IConfigurationElement> configElements = new ArrayList<IConfigurationElement>();
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            configElements.addAll(Arrays.asList(extension.getConfigurationElements()));
            ++n2;
        }
        return configElements.toArray(new IConfigurationElement[0]);
    }

    public static IConfigurationElement getWorkflow(String identifier) {
        IConfigurationElement configuration = null;
        IConfigurationElement[] configElements = CadenceExtensions.getAllWorkflowsExtensions();
        if (configElements != null) {
            IConfigurationElement[] iConfigurationElementArray = configElements;
            int n = configElements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement elt = iConfigurationElementArray[n2];
                if (elt.getAttribute(ATT_IDENTIFIER).equals(identifier)) {
                    configuration = elt;
                }
                ++n2;
            }
        }
        return configuration;
    }

    public static IConfigurationElement getWorkflowElement(String workflow_id, String identifier) {
        IConfigurationElement[] configElements = CadenceExtensions.getWorkflowElementConfigElement(workflow_id, ATT_WORKFLOW_ELEMENT);
        IConfigurationElement configuration = null;
        if (configElements != null) {
            IConfigurationElement[] iConfigurationElementArray = configElements;
            int n = configElements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement elt = iConfigurationElementArray[n2];
                if (elt.getAttribute(ATT_IDENTIFIER).equals(identifier)) {
                    configuration = elt;
                }
                ++n2;
            }
        }
        return configuration;
    }

    public static IConfigurationElement[] getAllActivityDeclaration() {
        return CadenceExtensions.getExtensionElt(ACTIVITY_ID);
    }

    public static IConfigurationElement[] getAllWorkflowElement(String workflow_id) {
        return CadenceExtensions.getWorkflowElementConfigElement(workflow_id, ATT_WORKFLOW_ELEMENT);
    }

    public static IConfigurationElement getWorkflowElementDescription(String workflow_id) {
        return CadenceExtensions.getWorkflowElementConfigElement(workflow_id, ATT_DESCRIPTION)[0];
    }

    public static IConfigurationElement[] getWorkflowElementConfigElement(String workflow_id, String workflowElt_id) {
        IConfigurationElement configElements = CadenceExtensions.getWorkflow(workflow_id);
        IConfigurationElement[] elt = configElements.getChildren(workflowElt_id);
        return elt;
    }

    public static IConfigurationElement[] getWorkflowElementParameters(IConfigurationElement workflowElement) {
        return workflowElement.getChildren("ParameterDefinition");
    }

    public static int getSize(String workflow_id, String workflowElement_id) {
        return CadenceExtensions.getWorkflowElementParameters(CadenceExtensions.getWorkflowElement(workflow_id, workflowElement_id)).length;
    }

    public static boolean isMultiple(String workflow_id, String workflowElement_id) {
        IConfigurationElement element = CadenceExtensions.getWorkflowElement(workflow_id, workflowElement_id);
        String isMultiple = element.getAttribute(ATT_MULTIPLE_CONTRIBUTIONS);
        return Boolean.parseBoolean(isMultiple);
    }

    public static String getOrder(String workflow_id, String workflowElement_id) {
        IConfigurationElement element = CadenceExtensions.getWorkflowElement(workflow_id, workflowElement_id);
        String order = element.getAttribute(ATT_ORDER_NUMBER);
        return order;
    }
}

