/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.transposer.ui.internal.tabs;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.polarsys.kitalpha.transposer.TransposerCorePlugin;
import org.polarsys.kitalpha.transposer.rules.handler.business.registry.GenericPurposeRegistry;
import org.polarsys.kitalpha.transposer.rules.handler.rules.common.Mapping;
import org.polarsys.kitalpha.transposer.rules.handler.rules.contribution.ContributedPurpose;
import org.polarsys.kitalpha.transposer.rules.handler.rules.runtime.RuntimePurpose;
import org.polarsys.kitalpha.transposer.ui.internal.providers.ComboContentProvider;
import org.polarsys.kitalpha.transposer.ui.internal.providers.ComboLabelProvider;
import org.polarsys.kitalpha.transposer.ui.internal.providers.MappingTreeContentProvider;
import org.polarsys.kitalpha.transposer.ui.internal.providers.MappingTreeLabelProvider;

public class TransposerMainTab
extends AbstractLaunchConfigurationTab {
    private static final String TAB_NAME = "Main";
    private static final String PURPOSE_GROUP_NAME = "Purpose";
    private static final String MAPPING_GROUP_NAME = "Mapping";
    private static final String VALIDATION_GROUP_NAME = "Validation";
    private Group _purposeGroup = null;
    private ComboViewer _purposeComboViewer = null;
    private Group _mappingGroup = null;
    private TreeViewer _mappingTreeViewer = null;
    private Text _selectedMappingDesciption = null;
    private Group _validationGroup = null;
    private Label _validationResultViewer = null;
    private boolean _validationResult = false;
    private ContributedPurpose _selectedPurpose = null;
    private Mapping _selectedMapping = null;

    public String getName() {
        return TAB_NAME;
    }

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        comp.setLayout((Layout)new GridLayout());
        comp.setFont(parent.getFont());
        this.createPurposeSelectionComponent(comp);
        this.createMappingSelectionComponent(comp);
        this.createValidationSelectionComponent(comp);
        this.initialize();
    }

    protected void createValidationSelectionComponent(Composite comp_p) {
        this._validationGroup = this.createGroup(comp_p, VALIDATION_GROUP_NAME, 1, 1, 1808, false);
        GridData gd = new GridData(1808);
        gd.grabExcessVerticalSpace = true;
        this._validationResultViewer = new Label((Composite)this._validationGroup, 8);
        this._validationResultViewer.setLayoutData((Object)gd);
    }

    protected void createPurposeSelectionComponent(Composite parent) {
        this._purposeGroup = this.createGroup(parent, PURPOSE_GROUP_NAME, 1, 2, 768, false);
        this._purposeComboViewer = new ComboViewer((Composite)this._purposeGroup, 131084);
        this._purposeComboViewer.setUseHashlookup(true);
        this._purposeComboViewer.setContentProvider((IContentProvider)new ComboContentProvider());
        this._purposeComboViewer.setLabelProvider((IBaseLabelProvider)new ComboLabelProvider());
        this._purposeComboViewer.setSorter(new ViewerSorter());
        Combo combo = this._purposeComboViewer.getCombo();
        combo.setLayoutData((Object)new GridData(768));
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TransposerMainTab.this.updateSelectedPurpose();
                TransposerMainTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    protected void createMappingSelectionComponent(Composite parent) {
        this._mappingGroup = this.createGroup(parent, MAPPING_GROUP_NAME, 1, 2, 1808, true);
        this._mappingTreeViewer = new TreeViewer((Composite)this._mappingGroup, 2820);
        GridData gdtv = new GridData(1808);
        gdtv.minimumHeight = 80;
        gdtv.grabExcessVerticalSpace = true;
        this._mappingTreeViewer.getControl().setLayoutData((Object)gdtv);
        this._mappingTreeViewer.setContentProvider((IContentProvider)new MappingTreeContentProvider());
        this._mappingTreeViewer.setLabelProvider((IBaseLabelProvider)new MappingTreeLabelProvider());
        this._mappingTreeViewer.getTree().setHeaderVisible(false);
        this._mappingTreeViewer.getTree().setLinesVisible(false);
        this._mappingTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event_p) {
                TransposerMainTab.this.updateSelectedMapping();
                TransposerMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        GridData gd = new GridData(1808);
        gd.grabExcessVerticalSpace = true;
        this._selectedMappingDesciption = new Text((Composite)this._mappingGroup, 2568);
        this._selectedMappingDesciption.setLayoutData((Object)gd);
    }

    private void updateSelectedPurpose() {
        ContributedPurpose selectedPurpose = (ContributedPurpose)((IStructuredSelection)this._purposeComboViewer.getSelection()).getFirstElement();
        if (selectedPurpose != null && !selectedPurpose.equals(this._selectedPurpose)) {
            this._selectedPurpose = selectedPurpose;
            this.updateMappingHierarchy();
        }
    }

    private boolean isValidSelection() {
        return this._validationResult && this._selectedPurpose != null && this._selectedMapping != null;
    }

    private void updateMappingHierarchy() {
        if (this._selectedPurpose != null && this._mappingTreeViewer != null) {
            this._mappingTreeViewer.setInput((Object)this._selectedPurpose);
            this._mappingTreeViewer.expandAll();
            this._selectedMapping = this._selectedPurpose.getMostGenericMapping();
            if (this._selectedMapping != null) {
                this._mappingTreeViewer.setSelection((ISelection)new StructuredSelection((Object)this._selectedMapping));
                this._selectedMappingDesciption.setText(this._selectedMapping.getCompleteDescription());
                this.validateSelection();
            }
        }
    }

    private void updateSelectedMapping() {
        Mapping selectedMapping = (Mapping)((IStructuredSelection)this._mappingTreeViewer.getSelection()).getFirstElement();
        if (selectedMapping != null && !selectedMapping.equals(this._selectedMapping)) {
            this._selectedMapping = selectedMapping;
            this._selectedMappingDesciption.setText(this._selectedMapping.getCompleteDescription());
            this.validateSelection();
        }
    }

    private void validateSelection() {
        IStatus status = null;
        RuntimePurpose runtimePurpose = null;
        if (this._selectedMapping != null) {
            runtimePurpose = GenericPurposeRegistry.getInstance().getRegisteredPurpose(this._selectedMapping.getPurpose().getName(), this._selectedMapping.getId());
        }
        if (runtimePurpose != null) {
            status = runtimePurpose.validate();
        }
        if (status == null) {
            this._validationResultViewer.setText("  No validation result");
            this._validationResult = false;
        } else {
            this._validationResultViewer.setText("  " + status.getMessage());
            this._validationResult = true;
            if (status.getSeverity() == 4) {
                this._validationResult = false;
                this._selectedPurpose.validate();
            }
        }
    }

    private void initialize() {
        EList purposes = GenericPurposeRegistry.getInstance().getContributedPurposes();
        Iterable filteredPurposes = Iterables.filter((Iterable)purposes, (Predicate)new Predicate<ContributedPurpose>(){

            public boolean apply(ContributedPurpose purpose) {
                return !purpose.isPrivate();
            }
        });
        if (filteredPurposes != null && !Iterables.isEmpty((Iterable)filteredPurposes)) {
            this._purposeComboViewer.setInput((Object)Iterables.toArray((Iterable)filteredPurposes, ContributedPurpose.class));
        }
    }

    public void initializeFrom(ILaunchConfiguration configuration_p) {
        this.updatePurposeFromConfig(configuration_p);
        this.updateMappingFromConfig(configuration_p);
    }

    private void updatePurposeFromConfig(ILaunchConfiguration configuration_p) {
        String purposeName = "";
        try {
            purposeName = configuration_p.getAttribute("purpose_name", "");
        }
        catch (CoreException e) {
            TransposerCorePlugin.getDefault().logError("org.polarsys.kitalpha.transposer.ui", e.getMessage(), (Throwable)e);
        }
        if (purposeName != null && !"".equals(purposeName)) {
            this._selectedPurpose = GenericPurposeRegistry.getInstance().getContributedPurpose(purposeName);
        }
        if (this._selectedPurpose != null) {
            this._purposeComboViewer.setSelection((ISelection)new StructuredSelection((Object)this._selectedPurpose));
            this._mappingTreeViewer.setInput((Object)this._selectedPurpose);
            this._mappingTreeViewer.expandAll();
        }
    }

    private void updateMappingFromConfig(ILaunchConfiguration configuration_p) {
        String mappingId = "";
        try {
            mappingId = configuration_p.getAttribute("mapping_id", "");
        }
        catch (CoreException e) {
            TransposerCorePlugin.getDefault().logError("org.polarsys.kitalpha.transposer.ui", e.getMessage(), (Throwable)e);
        }
        if (this._selectedPurpose != null && mappingId != null && !"".equals(mappingId)) {
            this._selectedMapping = this._selectedPurpose.getMapping(mappingId);
            this.validateSelection();
        }
        if (this._selectedMapping != null) {
            this._mappingTreeViewer.setSelection((ISelection)new StructuredSelection((Object)this._selectedMapping));
            this._selectedMappingDesciption.setText(this._selectedMapping.getCompleteDescription());
        }
    }

    public boolean isValid(ILaunchConfiguration launchConfig_p) {
        return this.isValidSelection() && super.isValid(launchConfig_p);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration_p) {
        if (this._selectedPurpose != null) {
            configuration_p.setAttribute("purpose_name", this._selectedPurpose.getName());
            if (this._selectedMapping != null) {
                configuration_p.setAttribute("mapping_id", this._selectedMapping.getId());
            }
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration_p) {
    }

    public Group createGroup(Composite parent, String text, int columns, int hspan, int fill, boolean verticalGrab) {
        Group g = new Group(parent, 0);
        g.setLayout((Layout)new GridLayout(columns, false));
        g.setText(text);
        g.setFont(parent.getFont());
        GridData gd = new GridData(fill);
        gd.horizontalSpan = hspan;
        gd.grabExcessVerticalSpace = verticalGrab;
        g.setLayoutData((Object)gd);
        return g;
    }

    public Composite createComposite(Composite parent, Font font, int columns, int hspan, int fill, int marginwidth, int marginheight) {
        Composite g = new Composite(parent, 0);
        GridLayout layout = new GridLayout(columns, false);
        layout.marginWidth = marginwidth;
        layout.marginHeight = marginheight;
        g.setLayout((Layout)layout);
        g.setFont(font);
        GridData gd = new GridData(fill);
        gd.horizontalSpan = hspan;
        g.setLayoutData((Object)gd);
        return g;
    }
}

