/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.transposer.scheduler.scheduler.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.polarsys.kitalpha.transposer.analyzer.graph.Edge;
import org.polarsys.kitalpha.transposer.analyzer.graph.Graph;
import org.polarsys.kitalpha.transposer.analyzer.graph.GraphFactory;
import org.polarsys.kitalpha.transposer.analyzer.graph.Vertex;
import org.polarsys.kitalpha.transposer.scheduler.api.ITransposerTask;
import org.polarsys.kitalpha.transposer.scheduler.exceptions.CycleException;
import org.polarsys.kitalpha.transposer.scheduler.scheduler.AbstractTopologicalSorter;
import org.polarsys.kitalpha.transposer.scheduler.taskwrapper.impl.TransposerTaskForVertex;

public class GenericTopologicalSorter
extends AbstractTopologicalSorter {
    public GenericTopologicalSorter(Set<Vertex<?>> toSort, Set<Edge<?>> backtracks_p) {
        super(toSort, backtracks_p);
    }

    private Set<Vertex<?>> findIndependantsInTypeSet(Set<Vertex<?>> toSort, Comparator<Vertex<?>> comparator_p, IProgressMonitor monitor_p) {
        Set<Object> independants = new LinkedHashSet();
        if (comparator_p != null) {
            independants = new TreeSet(comparator_p);
        }
        for (Vertex<?> currentType : toSort) {
            if (!this.isIndependantInTypeSet(currentType, toSort)) continue;
            independants.add(currentType);
            if (monitor_p == null) continue;
            monitor_p.worked(1 / this._model.size());
        }
        if (independants.size() == 0) {
            this.lookForOtherBacktracks(toSort);
            independants = this.findIndependantsInTypeSet(toSort, comparator_p, monitor_p);
        }
        return independants;
    }

    private void lookForOtherBacktracks(Set<Vertex<?>> toSort_p) {
        ArrayList nonBacktrackedEdges = new ArrayList();
        ArrayList edgesToBreak = new ArrayList();
        for (Vertex<?> v : toSort_p) {
            ArrayList<Edge> breakables = new ArrayList<Edge>();
            for (Edge e : v.getOutgoingEdges()) {
                if (!toSort_p.contains(e.getTarget()) || e.isCritical() || this._backtracks.contains(e)) continue;
                breakables.add(e);
            }
            if (breakables.size() > 1) {
                edgesToBreak.addAll(breakables);
                continue;
            }
            nonBacktrackedEdges.addAll(breakables);
        }
        if (edgesToBreak.isEmpty()) {
            this._backtracks.addAll(edgesToBreak);
        } else {
            this._backtracks.addAll(nonBacktrackedEdges);
        }
    }

    @Override
    public List<ITransposerTask<Vertex<?>>> getWork(IProgressMonitor monitor_p) {
        LinkedHashSet<TransposerTaskForVertex> taskBuffer = new LinkedHashSet<TransposerTaskForVertex>();
        LinkedList definitiveTasks = new LinkedList();
        LinkedHashSet<Vertex<?>> sorted = this.getSortedModel();
        if (monitor_p != null) {
            monitor_p.subTask("Compute tasks");
        }
        for (Vertex vertex : sorted) {
            taskBuffer.add(new TransposerTaskForVertex(vertex, false));
        }
        definitiveTasks.addAll(taskBuffer);
        for (TransposerTaskForVertex transposerTaskForVertex : taskBuffer) {
            EList edges = ((Vertex)transposerTaskForVertex.getTaskContent()).getOutgoingEdges();
            ArrayList edgesCopy = new ArrayList();
            edgesCopy.addAll(edges);
            edgesCopy.retainAll(this._backtracks);
            if (edgesCopy.size() == 0) {
                transposerTaskForVertex.setCompletelyTransposable(true);
            } else {
                definitiveTasks.add(new TransposerTaskForVertex((Vertex)transposerTaskForVertex.getTaskContent(), true));
            }
            if (monitor_p == null) continue;
            monitor_p.worked(1 / sorted.size());
        }
        return definitiveTasks;
    }

    private boolean isIndependantInTypeSet(Vertex<?> current, Set<Vertex<?>> toSort) {
        boolean independant = true;
        Iterator iterator = current.getOutgoingEdges().iterator();
        while (independant && iterator.hasNext()) {
            Edge currentedge = (Edge)iterator.next();
            if (this._backtracks.contains(currentedge)) {
                independant = true;
                continue;
            }
            Vertex currentType = currentedge.getTarget();
            boolean bl = independant = independant && !toSort.contains(currentType);
        }
        return independant;
    }

    @Override
    public LinkedHashSet<Vertex<?>> sort(Comparator<Vertex<?>> comparator_p, IProgressMonitor monitor_p) throws CycleException {
        if (monitor_p != null) {
            monitor_p.subTask("Topological sort");
        }
        this._sortedModel = this.topologicalSort(new LinkedHashSet(), this._model, comparator_p, monitor_p);
        return this.getSortedModel();
    }

    private LinkedHashSet<Vertex<?>> topologicalSort(LinkedHashSet<Vertex<?>> sorted, Set<Vertex<?>> toSort, Comparator<Vertex<?>> comparator_p, IProgressMonitor monitor_p) throws CycleException {
        LinkedHashSet dependants = new LinkedHashSet();
        if (toSort.size() == 0) {
            return sorted;
        }
        Set<Vertex<?>> independants = this.findIndependantsInTypeSet(toSort, comparator_p, monitor_p);
        if (independants.size() == 0) {
            ResourceSet rs = null;
            String uri = null;
            HashMap gToG2 = new HashMap();
            Graph g2 = GraphFactory.eINSTANCE.createGraph();
            for (Vertex<?> v : toSort) {
                Vertex v2 = GraphFactory.eINSTANCE.createVertex();
                g2.addVertex(v2);
                gToG2.put(v, v2);
                if (!(v.getContent() instanceof EObject)) continue;
                v2.setContent((Object)((EObject)v.getContent()));
                if (rs != null && uri != null || ((EObject)v.getContent()).eResource() == null) continue;
                rs = ((EObject)v.getContent()).eResource().getResourceSet();
                uri = ((EObject)v.getContent()).eResource().getURI().toPlatformString(false);
            }
            for (Vertex<?> v : toSort) {
                for (Edge e : v.getOutgoingEdges()) {
                    if (!toSort.contains(e.getTarget())) continue;
                    Edge e2 = GraphFactory.eINSTANCE.createEdge();
                    g2.addEdge(e2);
                    e2.update((Vertex)gToG2.get(v), (Vertex)gToG2.get(e.getTarget()), e.isCritical());
                    if (!this._backtracks.contains(e)) continue;
                    e2.setName("backtrack");
                }
            }
            Resource res = rs.createResource(URI.createURI((String)(String.valueOf(uri) + ".graph")));
            res.getContents().add((Object)g2);
            try {
                res.save(Collections.EMPTY_MAP);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            throw new CycleException();
        }
        for (Vertex<?> currentToSort : toSort) {
            if (independants.contains(currentToSort)) continue;
            dependants.add(currentToSort);
        }
        sorted.addAll(independants);
        this.topologicalSort(sorted, dependants, comparator_p, monitor_p);
        return sorted;
    }
}

