/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.massactions.core.table.layer.body;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.FilterList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.TransformedList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.nebula.widgets.nattable.data.IColumnAccessor;
import org.eclipse.nebula.widgets.nattable.data.IRowDataProvider;
import org.eclipse.nebula.widgets.nattable.data.ListDataProvider;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.GlazedListsEventLayer;
import org.eclipse.nebula.widgets.nattable.hideshow.ColumnHideShowLayer;
import org.eclipse.nebula.widgets.nattable.layer.AbstractLayerTransform;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.reorder.ColumnReorderLayer;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.viewport.ViewportLayer;
import org.polarsys.kitalpha.massactions.core.column.IMAColumn;
import org.polarsys.kitalpha.massactions.core.data.accessor.IMAColumnPropertyAccessor;
import org.polarsys.kitalpha.massactions.core.extensionpoint.columnfilter.IMAColumnFilter;
import org.polarsys.kitalpha.massactions.core.glazedlists.MAObservableElementList;
import org.polarsys.kitalpha.massactions.core.notification.MAConnector;
import org.polarsys.kitalpha.massactions.core.table.factory.IMAFactory;
import org.polarsys.kitalpha.massactions.core.table.layer.body.IMABodyLayer;
import org.polarsys.kitalpha.massactions.core.table.layer.body.MAColumnReorderLayer;
import org.polarsys.kitalpha.massactions.core.table.layer.body.MASelectionLayer;

public class MABodyLayer
extends AbstractLayerTransform
implements IMABodyLayer {
    private static final Log log = LogFactory.getLog(MABodyLayer.class);
    protected IMAFactory factory;
    protected Collection<EObject> data;
    protected IMAColumnPropertyAccessor columnPropertyAccessor;
    protected List<IMAColumnFilter> columnFilters;
    protected EventList<EObject> eventList;
    protected TransformedList<EObject, EObject> threadSafeList;
    protected MAObservableElementList observableElementList;
    protected SortedList<EObject> sortedList;
    protected FilterList<EObject> filteredList;
    protected IRowDataProvider<EObject> bodyDataProvider;
    protected DataLayer bodyDataLayer;
    protected GlazedListsEventLayer<EObject> glazedListsEventLayer;
    protected ColumnReorderLayer columnReorderLayer;
    protected ColumnHideShowLayer columnHideShowLayer;
    protected SelectionLayer selectionLayer;
    protected ViewportLayer viewportLayer;

    public MABodyLayer(Collection<EObject> data, IMAFactory factory) {
        this.data = data;
        this.factory = factory;
        ILayer finalLayer = this.initializeLayer();
        this.setUnderlyingLayer(finalLayer);
    }

    protected void initializeColumnFilters() {
        this.columnFilters = new ArrayList<IMAColumnFilter>();
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IConfigurationElement[] config = extensionRegistry.getConfigurationElementsFor("org.polarsys.kitalpha.massactions.core.columnfilter");
        try {
            IConfigurationElement[] iConfigurationElementArray = config;
            int n = config.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                Object o = element.createExecutableExtension("class");
                if (o instanceof IMAColumnFilter) {
                    IMAColumnFilter columnFilter = (IMAColumnFilter)o;
                    columnFilter.setBaseColumns(this.columnPropertyAccessor.getColumnList());
                    String displayName = element.getAttribute("displayName");
                    columnFilter.setDisplayName(displayName);
                    this.columnFilters.add(columnFilter);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            log.error((Object)e.getMessage());
        }
        Collections.sort(this.columnFilters, (f1, f2) -> f1.getDisplayName().compareTo(f2.getDisplayName()));
    }

    protected ILayer initializeLayer() {
        this.columnPropertyAccessor = this.factory.createColumnPropertyAccessor(this);
        this.initializeColumnFilters();
        this.eventList = GlazedLists.eventList(this.data);
        this.threadSafeList = GlazedLists.threadSafeList(this.eventList);
        this.observableElementList = new MAObservableElementList((EventList<EObject>)this.threadSafeList, new MAConnector());
        this.sortedList = new SortedList((EventList)this.observableElementList, null);
        this.filteredList = new FilterList(this.sortedList);
        this.bodyDataProvider = new ListDataProvider(this.filteredList, (IColumnAccessor)this.columnPropertyAccessor);
        this.bodyDataLayer = new DataLayer(this.bodyDataProvider);
        this.glazedListsEventLayer = new GlazedListsEventLayer((IUniqueIndexLayer)this.bodyDataLayer, this.filteredList);
        this.columnReorderLayer = new MAColumnReorderLayer((IUniqueIndexLayer)this.glazedListsEventLayer);
        this.columnHideShowLayer = new ColumnHideShowLayer((IUniqueIndexLayer)this.columnReorderLayer);
        this.selectionLayer = new MASelectionLayer((IUniqueIndexLayer)this.columnHideShowLayer);
        this.viewportLayer = new ViewportLayer((IUniqueIndexLayer)this.selectionLayer);
        return this.viewportLayer;
    }

    @Override
    public void applyColumnFilter(IMAColumnFilter columnFilter) {
        this.columnHideShowLayer.showAllColumns();
        List columnPositions = this.columnPropertyAccessor.getColumnList().stream().filter(columnFilter::shouldHide).map(IMAColumn::getIndex).collect(Collectors.toList());
        if (!columnPositions.isEmpty()) {
            this.columnHideShowLayer.hideColumnPositions(columnPositions);
        }
    }

    @Override
    public IMAColumnPropertyAccessor getColumnPropertyAccessor() {
        return this.columnPropertyAccessor;
    }

    @Override
    public void dataChanged(Collection<EObject> newData) {
        this.data = newData;
        this.columnPropertyAccessor.dataChanged(this.data);
    }

    @Override
    public DataLayer getBodyDataLayer() {
        return this.bodyDataLayer;
    }

    @Override
    public SelectionLayer getSelectionLayer() {
        return this.selectionLayer;
    }

    @Override
    public ViewportLayer getViewportLayer() {
        return this.viewportLayer;
    }

    @Override
    public SortedList<EObject> getSortedList() {
        return this.sortedList;
    }

    @Override
    public FilterList<EObject> getFilterList() {
        return this.filteredList;
    }

    @Override
    public IRowDataProvider<EObject> getBodyDataProvider() {
        return this.bodyDataProvider;
    }

    @Override
    public ColumnReorderLayer getColumnReorderLayer() {
        return this.columnReorderLayer;
    }

    @Override
    public ColumnHideShowLayer getColumnHideShowLayer() {
        return this.columnHideShowLayer;
    }

    @Override
    public Collection<EObject> getData() {
        return this.data;
    }

    @Override
    public List<IMAColumnFilter> getColumnFilterList() {
        return this.columnFilters;
    }

    @Override
    public void notifyListeners() {
        this.eventList.getReadWriteLock().writeLock().lock();
        try {
            this.eventList.clear();
            this.eventList.addAll(this.columnPropertyAccessor.getCurrentDataRepresentation());
        }
        finally {
            this.eventList.getReadWriteLock().writeLock().unlock();
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.eventList.getReadWriteLock().writeLock().lock();
        try {
            this.eventList.clear();
        }
        finally {
            this.eventList.getReadWriteLock().writeLock().unlock();
        }
    }
}

