/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.richtext.widget.tools.dialogs;

import java.util.List;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.polarsys.kitalpha.richtext.common.intf.MDERichTextWidget;
import org.polarsys.kitalpha.richtext.widget.tools.dialogs.MDEOkCancelDialog;
import org.polarsys.kitalpha.richtext.widget.tools.manager.LinkManager;
import org.polarsys.kitalpha.richtext.widget.tools.messages.Messages;
import org.polarsys.kitalpha.richtext.widget.tools.utils.Tuple;

public class MDEAddImageDialog
extends MDEOkCancelDialog {
    protected Text urlText;
    protected MDERichTextWidget richText;
    protected LinkManager linkManager;
    protected Combo linkTypeCombo;
    protected Button browseButton;
    private String linkType;
    protected ModifyListener urlTextListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            if (MDEAddImageDialog.this.getOK() != null) {
                MDEAddImageDialog.this.getOK().setEnabled(MDEAddImageDialog.this.urlText.getText().trim().length() > 0);
            }
        }
    };

    public MDEAddImageDialog(Shell parentShell, MDERichTextWidget richText, LinkManager linkManager) {
        super(parentShell);
        this.richText = richText;
        this.linkManager = linkManager;
    }

    @Override
    protected Control createDialogArea(Composite parent_p) {
        Composite parent = (Composite)super.createDialogArea(parent_p);
        GridLayout layout = (GridLayout)parent.getLayout();
        layout.numColumns = 3;
        Label linkTypeLabel = new Label(parent, 0);
        linkTypeLabel.setText("Type");
        this.linkTypeCombo = new Combo(parent, 2056);
        GridData comboGridData = new GridData(768);
        comboGridData.horizontalSpan = 2;
        this.linkTypeCombo.setLayoutData((Object)comboGridData);
        List<String> allLinkLabels = this.linkManager.getAllLinkLabels();
        final String[] labels = allLinkLabels.toArray(new String[0]);
        this.linkType = labels.length > 0 ? labels[0] : "";
        this.linkTypeCombo.setItems(labels);
        this.linkTypeCombo.setText(labels[0]);
        this.linkTypeCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                MDEAddImageDialog.this.linkType = labels[MDEAddImageDialog.this.linkTypeCombo.getSelectionIndex()];
                MDEAddImageDialog.this.urlText.setText("");
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        Label urlLabel = new Label(parent, 0);
        urlLabel.setText("URL");
        this.urlText = new Text(parent, 2048);
        GridData gridData = new GridData(768);
        gridData.widthHint = 300;
        this.urlText.setLayoutData((Object)gridData);
        this.urlText.addModifyListener(this.urlTextListener);
        this.browseButton = new Button(parent, 8);
        this.browseButton.setLayoutData((Object)new GridData());
        this.browseButton.setText("Browse");
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String first;
                Tuple<String, String> path = MDEAddImageDialog.this.linkManager.getURI(MDEAddImageDialog.this.linkType, null, MDEAddImageDialog.this.richText.getElement());
                if (path != null && (first = path.getFirst()) != null) {
                    MDEAddImageDialog.this.urlText.setText(first);
                }
            }
        });
        super.getShell().setText(Messages.RichTextWidget_Dialog_Add_Image);
        return parent;
    }

    protected void okPressed() {
        String text = this.urlText.getText();
        String image = this.linkManager.encode(this.linkType, text, null);
        this.richText.insertRawText(image);
        super.okPressed();
        this.richText.forceFocus();
    }

    @Override
    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getOK().setEnabled(false);
    }
}

