/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.massactions.core.selection;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.polarsys.kitalpha.massactions.core.selection.RowCellSelectionProvider;
import org.polarsys.kitalpha.massactions.core.table.IMATable;
import org.polarsys.kitalpha.massactions.core.table.layer.body.IMABodyLayer;

public class LazyRowSelectionProvider
implements ISelectionProvider {
    private IMATable table;
    private List<ISelectionChangedListener> lazySelectionChangedListeners;
    private RowCellSelectionProvider<EObject> rowSelectionProvider;

    public LazyRowSelectionProvider(IMATable table) {
        this.table = table;
        this.lazySelectionChangedListeners = new ArrayList<ISelectionChangedListener>();
    }

    public boolean enable() {
        boolean canEnable;
        boolean bl = canEnable = this.table.getGridLayerStack() != null;
        if (canEnable) {
            IMABodyLayer bodyLayer = this.table.getGridLayerStack().getBodyLayer();
            this.rowSelectionProvider = new RowCellSelectionProvider<EObject>(bodyLayer.getSelectionLayer(), bodyLayer.getBodyDataProvider(), false, true);
            this.lazySelectionChangedListeners.forEach(listener -> this.rowSelectionProvider.addSelectionChangedListener((ISelectionChangedListener)listener));
        }
        return canEnable;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.rowSelectionProvider == null) {
            this.lazySelectionChangedListeners.add(listener);
        } else {
            this.rowSelectionProvider.addSelectionChangedListener(listener);
        }
    }

    public ISelection getSelection() {
        if (this.rowSelectionProvider != null || this.enable()) {
            return this.rowSelectionProvider.getSelection();
        }
        return StructuredSelection.EMPTY;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.rowSelectionProvider == null) {
            this.lazySelectionChangedListeners.remove(listener);
        } else {
            this.rowSelectionProvider.removeSelectionChangedListener(listener);
        }
    }

    public void setSelection(ISelection selection) {
    }
}

