/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.transposer.transformation.emf.util;

import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;

public class EcoreIdentifierUtil {
    public static final String SEP = "::";

    public static String getIdentifier(ENamedElement element_p) {
        if (element_p instanceof EPackage) {
            return EcoreIdentifierUtil.getEPackageIdentifier((EPackage)element_p);
        }
        if (element_p instanceof EClassifier) {
            return EcoreIdentifierUtil.getEClassifierIdentifier((EClassifier)element_p);
        }
        if (element_p instanceof EStructuralFeature) {
            return EcoreIdentifierUtil.getFeatureIdentifier((EStructuralFeature)element_p);
        }
        if (element_p instanceof EEnumLiteral) {
            return EcoreIdentifierUtil.getLiteralIdentifier((EEnumLiteral)element_p);
        }
        if (element_p == null) {
            return "";
        }
        return element_p.getName();
    }

    private static String getFeatureIdentifier(EStructuralFeature feature_p) {
        if (feature_p == null) {
            return "";
        }
        return String.valueOf(EcoreIdentifierUtil.getEClassifierIdentifier((EClassifier)feature_p.getEContainingClass())) + SEP + feature_p.getName();
    }

    private static String getLiteralIdentifier(EEnumLiteral lit_p) {
        if (lit_p == null) {
            return "";
        }
        return String.valueOf(EcoreIdentifierUtil.getEClassifierIdentifier((EClassifier)lit_p.getEEnum())) + SEP + lit_p.getName();
    }

    private static String getEClassifierIdentifier(EClassifier classifier_p) {
        if (classifier_p == null) {
            return "";
        }
        return String.valueOf(EcoreIdentifierUtil.getEPackageIdentifier(classifier_p.getEPackage())) + SEP + classifier_p.getName();
    }

    private static String getEPackageIdentifier(EPackage package_p) {
        if (package_p == null) {
            return "";
        }
        if (package_p.getESuperPackage() != null) {
            return String.valueOf(EcoreIdentifierUtil.getEPackageIdentifier(package_p.getESuperPackage())) + SEP + package_p.getName();
        }
        return package_p.getName();
    }
}

