/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.transposer.ui.internal.configuration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.polarsys.kitalpha.transposer.rules.handler.business.registry.GenericPurposeRegistry;
import org.polarsys.kitalpha.transposer.rules.handler.rules.common.Mapping;

public final class TransposerLaunchConfigurationHelper {
    private TransposerLaunchConfigurationHelper() {
    }

    public static ILaunchConfiguration[] getAllTransposerLaunchConfigurations() throws CoreException {
        LinkedList<ILaunchConfiguration> result = new LinkedList<ILaunchConfiguration>();
        ILaunchConfiguration[] iLaunchConfigurationArray = TransposerLaunchConfigurationHelper.getLaunchManager().getLaunchConfigurations();
        int n = iLaunchConfigurationArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfiguration launchConfiguration = iLaunchConfigurationArray[n2];
            if (launchConfiguration.getType() != null && launchConfiguration.getType().getIdentifier() != null && launchConfiguration.getType().getIdentifier().equals("org.polarsys.kitalpha.transposer.ui.launch.TransposerConfigurationType")) {
                result.add(launchConfiguration);
            }
            ++n2;
        }
        return result.toArray(new ILaunchConfiguration[result.size()]);
    }

    public static ILaunchConfiguration[] getAllTransposerLaunchConfigurations(List<?> selection_p) throws CoreException {
        HashMap launchConfigurations = new HashMap();
        LinkedHashSet enabledConfigurations = new LinkedHashSet();
        LinkedHashSet<Mapping> enabledMapping = new LinkedHashSet<Mapping>();
        ILaunchConfiguration[] iLaunchConfigurationArray = TransposerLaunchConfigurationHelper.getAllTransposerLaunchConfigurations();
        int n = iLaunchConfigurationArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfiguration launchConfiguration = iLaunchConfigurationArray[n2];
            String purpose = launchConfiguration.getAttribute("purpose_name", "");
            String mappingId = launchConfiguration.getAttribute("mapping_id", "");
            Mapping mapping = GenericPurposeRegistry.getInstance().getContributedMapping(purpose, mappingId);
            if (mapping != null) {
                if (launchConfigurations.containsKey(mapping)) {
                    ((List)launchConfigurations.get(mapping)).add(launchConfiguration);
                } else {
                    ArrayList<ILaunchConfiguration> configs = new ArrayList<ILaunchConfiguration>();
                    configs.add(launchConfiguration);
                    launchConfigurations.put(mapping, configs);
                }
            }
            ++n2;
        }
        for (Mapping mapping : launchConfigurations.keySet()) {
            boolean mappingToEnable = false;
            for (Object obj : selection_p) {
                if (!mapping.getDomainHelper().isDomainFor(obj)) continue;
                mappingToEnable = true;
                break;
            }
            if (!mappingToEnable) continue;
            enabledMapping.add(mapping);
        }
        for (Mapping mapping : enabledMapping) {
            if (!launchConfigurations.containsKey(mapping)) continue;
            enabledConfigurations.addAll((Collection)launchConfigurations.get(mapping));
        }
        return enabledConfigurations.toArray(new ILaunchConfiguration[launchConfigurations.size()]);
    }

    private static ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }
}

