/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.configuration;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.eclipse.kura.KuraErrorCode;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.configuration.ComponentConfiguration;
import org.eclipse.kura.core.configuration.ComponentConfigurationImpl;
import org.eclipse.kura.core.configuration.ConfigurationServiceImpl;
import org.eclipse.kura.core.configuration.XmlComponentConfigurations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UpdateConfigurationsCallable
implements Callable<Void> {
    private static Logger s_logger = LoggerFactory.getLogger(UpdateConfigurationsCallable.class);
    private String m_pid;
    private XmlComponentConfigurations m_xmlConfigurations;
    private ConfigurationServiceImpl m_configurationService;

    public UpdateConfigurationsCallable(String pid, XmlComponentConfigurations xmlConfigurations, ConfigurationServiceImpl configurationService) {
        this.m_pid = pid;
        this.m_xmlConfigurations = xmlConfigurations;
        this.m_configurationService = configurationService;
    }

    @Override
    public Void call() throws Exception {
        List<ComponentConfigurationImpl> configImpls;
        block6: {
            s_logger.info("Updating configurations");
            Thread.currentThread().setName(this.getClass().getSimpleName());
            List<ComponentConfigurationImpl> list = configImpls = this.m_xmlConfigurations != null ? this.m_xmlConfigurations.getConfigurations() : null;
            if (configImpls != null) break block6;
            return null;
        }
        try {
            ArrayList<ComponentConfiguration> configs = new ArrayList<ComponentConfiguration>();
            configs.addAll(configImpls);
            if (this.m_pid == null) {
                this.m_configurationService.updateConfigurations(configs);
            } else {
                for (ComponentConfiguration config : configs) {
                    if (!this.m_pid.equals(config.getPid())) continue;
                    this.m_configurationService.updateConfiguration(this.m_pid, config.getConfigurationProperties());
                }
            }
        }
        catch (KuraException e) {
            s_logger.error("Error updating configurations: {}", (Throwable)e);
            throw new KuraException(KuraErrorCode.CONFIGURATION_UPDATE, (Throwable)e, new Object[0]);
        }
        return null;
    }
}

