/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.configuration.util;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.kura.configuration.metatype.AD;
import org.eclipse.kura.configuration.metatype.OCD;
import org.eclipse.kura.configuration.metatype.Scalar;
import org.eclipse.kura.core.configuration.Password;

public class CollectionsUtil {
    public static Map<String, Object> dictionaryToMap(Dictionary<String, Object> dictionary, OCD ocd) {
        if (dictionary == null) {
            return null;
        }
        HashMap<String, AD> ads = new HashMap<String, AD>();
        if (ocd != null) {
            for (AD ad : ocd.getAD()) {
                ads.put(ad.getId(), ad);
            }
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        Enumeration<String> keys = dictionary.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            Object value = dictionary.get(key);
            AD ad = (AD)ads.get(key);
            if (ad != null && ad.getType() != null && Scalar.PASSWORD.equals((Object)ad.getType())) {
                map.put(key, new Password(value.toString()));
                continue;
            }
            map.put(key, value);
        }
        return map;
    }

    public static Dictionary<String, Object> mapToDictionary(Map<String, Object> map) {
        if (map == null) {
            return null;
        }
        Hashtable<String, Object> dictionary = new Hashtable<String, Object>();
        for (String key : map.keySet()) {
            Object value = map.get(key);
            if (value == null) continue;
            if (value instanceof Password) {
                ((Dictionary)dictionary).put(key, value.toString());
                continue;
            }
            ((Dictionary)dictionary).put(key, value);
        }
        return dictionary;
    }
}

