/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.net;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.eclipse.kura.core.net.AbstractNetInterface;
import org.eclipse.kura.core.net.WifiInterfaceAddressImpl;
import org.eclipse.kura.net.NetInterface;
import org.eclipse.kura.net.NetInterfaceAddress;
import org.eclipse.kura.net.NetInterfaceType;
import org.eclipse.kura.net.wifi.WifiInterface;
import org.eclipse.kura.net.wifi.WifiInterfaceAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WifiInterfaceImpl<T extends WifiInterfaceAddress>
extends AbstractNetInterface<T>
implements WifiInterface<T> {
    private static final Logger s_logger = LoggerFactory.getLogger(WifiInterfaceImpl.class);
    private EnumSet<WifiInterface.Capability> capabilities = null;

    public WifiInterfaceImpl(String name) {
        super(name);
    }

    public WifiInterfaceImpl(WifiInterface<? extends WifiInterfaceAddress> other) {
        super((NetInterface<? extends NetInterfaceAddress>)other);
        this.capabilities = other.getCapabilities();
        List otherNetInterfaceAddresses = other.getNetInterfaceAddresses();
        ArrayList<WifiInterfaceAddressImpl> interfaceAddresses = new ArrayList<WifiInterfaceAddressImpl>();
        if (otherNetInterfaceAddresses != null) {
            for (WifiInterfaceAddress wifiInterfaceAddress : otherNetInterfaceAddresses) {
                try {
                    WifiInterfaceAddressImpl copiedInterfaceAddressImpl = new WifiInterfaceAddressImpl(wifiInterfaceAddress);
                    interfaceAddresses.add(copiedInterfaceAddressImpl);
                }
                catch (Exception exception) {
                    s_logger.debug("Could not copy interface address: " + wifiInterfaceAddress);
                }
            }
        }
        this.setNetInterfaceAddresses(interfaceAddresses);
    }

    public NetInterfaceType getType() {
        return NetInterfaceType.WIFI;
    }

    public EnumSet<WifiInterface.Capability> getCapabilities() {
        if (this.capabilities != null) {
            return EnumSet.copyOf(this.capabilities);
        }
        return null;
    }

    public void setCapabilities(EnumSet<WifiInterface.Capability> capabilities) {
        this.capabilities = capabilities;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        if (this.capabilities != null && this.capabilities.size() > 0) {
            sb.append(" :: capabilities=");
            for (WifiInterface.Capability capability : this.capabilities) {
                sb.append(capability).append(" ");
            }
        } else {
            sb.append(" :: capabilities=null");
        }
        return sb.toString();
    }
}

