/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.ssl;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSLSocketFactoryWrapper
extends SSLSocketFactory {
    private static final Logger s_logger = LoggerFactory.getLogger(SSLSocketFactoryWrapper.class);
    private String ciphers;
    private Boolean hostnameVerification;
    private SSLSocketFactory sslsf;

    public SSLSocketFactoryWrapper(SSLSocketFactory sslsf, String ciphers, Boolean hnVerify) {
        this.sslsf = sslsf;
        this.ciphers = ciphers;
        this.hostnameVerification = hnVerify;
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.sslsf.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.sslsf.getSupportedCipherSuites();
    }

    @Override
    public Socket createSocket() throws IOException {
        Socket socket = this.sslsf.createSocket();
        this.updateSSLParameters(socket);
        return socket;
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        Socket socket = this.sslsf.createSocket(host, port);
        this.updateSSLParameters(socket);
        return socket;
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
        Socket socket = this.sslsf.createSocket(host, port, localHost, localPort);
        this.updateSSLParameters(socket);
        return socket;
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        Socket socket = this.sslsf.createSocket(host, port);
        this.updateSSLParameters(socket);
        return socket;
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        Socket socket = this.sslsf.createSocket(address, port, address, localPort);
        this.updateSSLParameters(socket);
        return socket;
    }

    @Override
    public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
        Socket socket = this.sslsf.createSocket(s, host, port, autoClose);
        this.updateSSLParameters(socket);
        return socket;
    }

    private void updateSSLParameters(Socket socket) throws SocketException {
        if (socket instanceof SSLSocket) {
            SSLParameters sslParams = ((SSLSocket)socket).getSSLParameters();
            ArrayList<String> protocols = new ArrayList<String>(Arrays.asList(sslParams.getProtocols()));
            protocols.remove("SSLv2Hello");
            sslParams.setProtocols(protocols.toArray(new String[protocols.size()]));
            Class<SSLParameters> clSSLParameters = SSLParameters.class;
            try {
                Method m = clSSLParameters.getMethod("setEndpointIdentificationAlgorithm", String.class);
                if (m != null && this.hostnameVerification.booleanValue()) {
                    sslParams.setEndpointIdentificationAlgorithm("HTTPS");
                    s_logger.info("SSL Endpoint Identification enabled.");
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                s_logger.warn("Cannot enable SSL Endpoint Identification as it requires Java7");
            }
            if (this.ciphers != null && !this.ciphers.isEmpty()) {
                String[] arrCiphers = this.ciphers.split(",");
                ArrayList<String> lsCiphers = new ArrayList<String>();
                String[] stringArray = arrCiphers;
                int n = arrCiphers.length;
                int n2 = 0;
                while (n2 < n) {
                    String cipher = stringArray[n2];
                    lsCiphers.add(cipher.trim());
                    ++n2;
                }
                sslParams.setCipherSuites(lsCiphers.toArray(new String[lsCiphers.size()]));
            }
            ((SSLSocket)socket).setSSLParameters(sslParams);
            socket.setTcpNoDelay(true);
        }
    }
}

