/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.configuration;

import java.io.IOException;
import java.io.Serializable;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.eclipse.kura.core.configuration.Password;
import org.eclipse.kura.core.configuration.XmlConfigPropertiesAdapted;
import org.eclipse.kura.core.configuration.XmlConfigPropertyAdapted;
import org.eclipse.kura.crypto.CryptoService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public class XmlConfigPropertiesAdapter
extends XmlAdapter<XmlConfigPropertiesAdapted, Map<String, Object>> {
    public XmlConfigPropertiesAdapted marshal(Map<String, Object> props) throws Exception {
        ArrayList<XmlConfigPropertyAdapted> adaptedValues = new ArrayList<XmlConfigPropertyAdapted>();
        if (props != null) {
            Iterator<String> keys = props.keySet().iterator();
            while (keys.hasNext()) {
                String[] stringValues;
                Serializable[] nativeValues;
                CryptoService cryptoService;
                ServiceReference cryptoServiceRef;
                BundleContext bundleContext;
                XmlConfigPropertyAdapted adaptedValue = new XmlConfigPropertyAdapted();
                adaptedValues.add(adaptedValue);
                String key = keys.next();
                adaptedValue.setName(key);
                Object value = props.get(key);
                if (value instanceof String) {
                    adaptedValue.setArray(false);
                    adaptedValue.setType(XmlConfigPropertyAdapted.ConfigPropertyType.stringType);
                    adaptedValue.setValues(new String[]{value.toString()});
                    continue;
                }
                if (value instanceof Long) {
                    adaptedValue.setArray(false);
                    adaptedValue.setType(XmlConfigPropertyAdapted.ConfigPropertyType.longType);
                    adaptedValue.setValues(new String[]{value.toString()});
                    continue;
                }
                if (value instanceof Double) {
                    adaptedValue.setArray(false);
                    adaptedValue.setType(XmlConfigPropertyAdapted.ConfigPropertyType.doubleType);
                    adaptedValue.setValues(new String[]{value.toString()});
                    continue;
                }
                if (value instanceof Float) {
                    adaptedValue.setArray(false);
                    adaptedValue.setType(XmlConfigPropertyAdapted.ConfigPropertyType.floatType);
                    adaptedValue.setValues(new String[]{value.toString()});
                    continue;
                }
                if (value instanceof Integer) {
                    adaptedValue.setArray(false);
                    adaptedValue.setType(XmlConfigPropertyAdapted.ConfigPropertyType.integerType);
                    adaptedValue.setValues(new String[]{value.toString()});
                    continue;
                }
                if (value instanceof Byte) {
                    adaptedValue.setArray(false);
                    adaptedValue.setType(XmlConfigPropertyAdapted.ConfigPropertyType.byteType);
                    adaptedValue.setValues(new String[]{value.toString()});
                    continue;
                }
                if (value instanceof Character) {
                    adaptedValue.setArray(false);
                    adaptedValue.setType(XmlConfigPropertyAdapted.ConfigPropertyType.charType);
                    adaptedValue.setValues(new String[]{value.toString()});
                    continue;
                }
                if (value instanceof Boolean) {
                    adaptedValue.setArray(false);
                    adaptedValue.setType(XmlConfigPropertyAdapted.ConfigPropertyType.booleanType);
                    adaptedValue.setValues(new String[]{value.toString()});
                    continue;
                }
                if (value instanceof Short) {
                    adaptedValue.setArray(false);
                    adaptedValue.setType(XmlConfigPropertyAdapted.ConfigPropertyType.shortType);
                    adaptedValue.setValues(new String[]{value.toString()});
                    continue;
                }
                if (value instanceof Password) {
                    bundleContext = FrameworkUtil.getBundle(((Object)((Object)this)).getClass()).getBundleContext();
                    cryptoServiceRef = bundleContext.getServiceReference(CryptoService.class);
                    cryptoService = (CryptoService)bundleContext.getService(cryptoServiceRef);
                    adaptedValue.setArray(false);
                    adaptedValue.setEncrypted(true);
                    adaptedValue.setType(XmlConfigPropertyAdapted.ConfigPropertyType.passwordType);
                    adaptedValue.setValues(new String[]{cryptoService.encodeBase64(value.toString())});
                    continue;
                }
                if (value instanceof String[]) {
                    adaptedValue.setArray(true);
                    adaptedValue.setType(XmlConfigPropertyAdapted.ConfigPropertyType.stringType);
                    adaptedValue.setValues((String[])value);
                    continue;
                }
                if (value instanceof Long[]) {
                    adaptedValue.setArray(true);
                    adaptedValue.setType(XmlConfigPropertyAdapted.ConfigPropertyType.longType);
                    nativeValues = (Long[])value;
                    stringValues = new String[nativeValues.length];
                    int i = 0;
                    while (i < nativeValues.length) {
                        if (nativeValues[i] != null) {
                            stringValues[i] = ((Long)nativeValues[i]).toString();
                        }
                        ++i;
                    }
                    adaptedValue.setValues(stringValues);
                    continue;
                }
                if (value instanceof Double[]) {
                    adaptedValue.setArray(true);
                    adaptedValue.setType(XmlConfigPropertyAdapted.ConfigPropertyType.doubleType);
                    nativeValues = (Double[])value;
                    stringValues = new String[nativeValues.length];
                    int i = 0;
                    while (i < nativeValues.length) {
                        if (nativeValues[i] != null) {
                            stringValues[i] = ((Double)nativeValues[i]).toString();
                        }
                        ++i;
                    }
                    adaptedValue.setValues(stringValues);
                    continue;
                }
                if (value instanceof Float[]) {
                    adaptedValue.setArray(true);
                    adaptedValue.setType(XmlConfigPropertyAdapted.ConfigPropertyType.floatType);
                    nativeValues = (Float[])value;
                    stringValues = new String[nativeValues.length];
                    int i = 0;
                    while (i < nativeValues.length) {
                        if (nativeValues[i] != null) {
                            stringValues[i] = ((Float)nativeValues[i]).toString();
                        }
                        ++i;
                    }
                    adaptedValue.setValues(stringValues);
                    continue;
                }
                if (value instanceof Integer[]) {
                    adaptedValue.setArray(true);
                    adaptedValue.setType(XmlConfigPropertyAdapted.ConfigPropertyType.integerType);
                    nativeValues = (Integer[])value;
                    stringValues = new String[nativeValues.length];
                    int i = 0;
                    while (i < nativeValues.length) {
                        if (nativeValues[i] != null) {
                            stringValues[i] = ((Integer)nativeValues[i]).toString();
                        }
                        ++i;
                    }
                    adaptedValue.setValues(stringValues);
                    continue;
                }
                if (value instanceof Byte[]) {
                    adaptedValue.setArray(true);
                    adaptedValue.setType(XmlConfigPropertyAdapted.ConfigPropertyType.byteType);
                    nativeValues = (Byte[])value;
                    stringValues = new String[nativeValues.length];
                    int i = 0;
                    while (i < nativeValues.length) {
                        if (nativeValues[i] != null) {
                            stringValues[i] = ((Byte)nativeValues[i]).toString();
                        }
                        ++i;
                    }
                    adaptedValue.setValues(stringValues);
                    continue;
                }
                if (value instanceof Character[]) {
                    adaptedValue.setArray(true);
                    adaptedValue.setType(XmlConfigPropertyAdapted.ConfigPropertyType.charType);
                    nativeValues = (Character[])value;
                    stringValues = new String[nativeValues.length];
                    int i = 0;
                    while (i < nativeValues.length) {
                        if (nativeValues[i] != null) {
                            stringValues[i] = ((Character)nativeValues[i]).toString();
                        }
                        ++i;
                    }
                    adaptedValue.setValues(stringValues);
                    continue;
                }
                if (value instanceof Boolean[]) {
                    adaptedValue.setArray(true);
                    adaptedValue.setType(XmlConfigPropertyAdapted.ConfigPropertyType.booleanType);
                    nativeValues = (Boolean[])value;
                    stringValues = new String[nativeValues.length];
                    int i = 0;
                    while (i < nativeValues.length) {
                        if (nativeValues[i] != null) {
                            stringValues[i] = ((Boolean)nativeValues[i]).toString();
                        }
                        ++i;
                    }
                    adaptedValue.setValues(stringValues);
                    continue;
                }
                if (value instanceof Short[]) {
                    adaptedValue.setArray(true);
                    adaptedValue.setType(XmlConfigPropertyAdapted.ConfigPropertyType.shortType);
                    nativeValues = (Short[])value;
                    stringValues = new String[nativeValues.length];
                    int i = 0;
                    while (i < nativeValues.length) {
                        if (nativeValues[i] != null) {
                            stringValues[i] = ((Short)nativeValues[i]).toString();
                        }
                        ++i;
                    }
                    adaptedValue.setValues(stringValues);
                    continue;
                }
                if (!(value instanceof Password[])) continue;
                bundleContext = FrameworkUtil.getBundle(((Object)((Object)this)).getClass()).getBundleContext();
                cryptoServiceRef = bundleContext.getServiceReference(CryptoService.class);
                cryptoService = (CryptoService)bundleContext.getService(cryptoServiceRef);
                adaptedValue.setArray(true);
                adaptedValue.setEncrypted(true);
                adaptedValue.setType(XmlConfigPropertyAdapted.ConfigPropertyType.passwordType);
                Password[] nativeValues2 = (Password[])value;
                String[] stringValues2 = new String[nativeValues2.length];
                int i = 0;
                while (i < nativeValues2.length) {
                    if (nativeValues2[i] != null) {
                        stringValues2[i] = cryptoService.encodeBase64(nativeValues2[i].toString());
                    }
                    ++i;
                }
                adaptedValue.setValues(stringValues2);
            }
        }
        XmlConfigPropertiesAdapted result = new XmlConfigPropertiesAdapted();
        result.setProperties(adaptedValues.toArray(new XmlConfigPropertyAdapted[0]));
        return result;
    }

    public Map<String, Object> unmarshal(XmlConfigPropertiesAdapted adaptedPropsAdapted) throws Exception {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        XmlConfigPropertyAdapted[] adaptedProps = adaptedPropsAdapted.getProperties();
        if (adaptedProps == null) {
            return properties;
        }
        XmlConfigPropertyAdapted[] xmlConfigPropertyAdaptedArray = adaptedProps;
        int n = adaptedProps.length;
        int n2 = 0;
        while (n2 < n) {
            XmlConfigPropertyAdapted adaptedProp = xmlConfigPropertyAdaptedArray[n2];
            String propName = adaptedProp.getName();
            XmlConfigPropertyAdapted.ConfigPropertyType type = adaptedProp.getType();
            if (type != null) {
                Object propvalue = null;
                if (!adaptedProp.getArray()) {
                    switch (adaptedProp.getType()) {
                        case stringType: {
                            propvalue = adaptedProp.getValues()[0];
                            break;
                        }
                        case longType: {
                            propvalue = Long.parseLong(adaptedProp.getValues()[0]);
                            break;
                        }
                        case doubleType: {
                            propvalue = Double.parseDouble(adaptedProp.getValues()[0]);
                            break;
                        }
                        case floatType: {
                            propvalue = Float.valueOf(Float.parseFloat(adaptedProp.getValues()[0]));
                            break;
                        }
                        case integerType: {
                            propvalue = Integer.parseInt(adaptedProp.getValues()[0]);
                            break;
                        }
                        case byteType: {
                            propvalue = Byte.parseByte(adaptedProp.getValues()[0]);
                            break;
                        }
                        case charType: {
                            String s = adaptedProp.getValues()[0];
                            propvalue = new Character(s.charAt(0));
                            break;
                        }
                        case booleanType: {
                            propvalue = Boolean.parseBoolean(adaptedProp.getValues()[0]);
                            break;
                        }
                        case shortType: {
                            propvalue = Short.parseShort(adaptedProp.getValues()[0]);
                            break;
                        }
                        case passwordType: {
                            BundleContext bundleContext = FrameworkUtil.getBundle(((Object)((Object)this)).getClass()).getBundleContext();
                            ServiceReference cryptoServiceRef = bundleContext.getServiceReference(CryptoService.class);
                            CryptoService cryptoService = (CryptoService)bundleContext.getService(cryptoServiceRef);
                            propvalue = adaptedProp.getValues()[0];
                            if (adaptedProp.isEncrypted()) {
                                try {
                                    propvalue = new Password(cryptoService.decryptAes((String)propvalue));
                                    break;
                                }
                                catch (Exception e) {
                                    if (e instanceof IllegalBlockSizeException || e instanceof NoSuchAlgorithmException || e instanceof NoSuchPaddingException || e instanceof InvalidKeyException || e instanceof IOException || e instanceof IllegalBlockSizeException || e instanceof BadPaddingException) {
                                        propvalue = new Password(cryptoService.decodeBase64((String)propvalue));
                                        break;
                                    }
                                    throw e;
                                }
                            }
                            propvalue = new Password((String)propvalue);
                        }
                    }
                } else {
                    switch (adaptedProp.getType()) {
                        case stringType: {
                            propvalue = adaptedProp.getValues();
                            break;
                        }
                        case longType: {
                            Long[] longValues = new Long[adaptedProp.getValues().length];
                            int i = 0;
                            while (i < adaptedProp.getValues().length) {
                                if (adaptedProp.getValues()[i] != null) {
                                    longValues[i] = Long.parseLong(adaptedProp.getValues()[i]);
                                }
                                ++i;
                            }
                            propvalue = longValues;
                            break;
                        }
                        case doubleType: {
                            Double[] doubleValues = new Double[adaptedProp.getValues().length];
                            int i = 0;
                            while (i < adaptedProp.getValues().length) {
                                if (adaptedProp.getValues()[i] != null) {
                                    doubleValues[i] = Double.parseDouble(adaptedProp.getValues()[i]);
                                }
                                ++i;
                            }
                            propvalue = doubleValues;
                            break;
                        }
                        case floatType: {
                            Float[] floatValues = new Float[adaptedProp.getValues().length];
                            int i = 0;
                            while (i < adaptedProp.getValues().length) {
                                if (adaptedProp.getValues()[i] != null) {
                                    floatValues[i] = Float.valueOf(Float.parseFloat(adaptedProp.getValues()[i]));
                                }
                                ++i;
                            }
                            propvalue = floatValues;
                            break;
                        }
                        case integerType: {
                            Integer[] intValues = new Integer[adaptedProp.getValues().length];
                            int i = 0;
                            while (i < adaptedProp.getValues().length) {
                                if (adaptedProp.getValues()[i] != null) {
                                    intValues[i] = Integer.parseInt(adaptedProp.getValues()[i]);
                                }
                                ++i;
                            }
                            propvalue = intValues;
                            break;
                        }
                        case byteType: {
                            Byte[] byteValues = new Byte[adaptedProp.getValues().length];
                            int i = 0;
                            while (i < adaptedProp.getValues().length) {
                                if (adaptedProp.getValues()[i] != null) {
                                    byteValues[i] = Byte.parseByte(adaptedProp.getValues()[i]);
                                }
                                ++i;
                            }
                            propvalue = byteValues;
                            break;
                        }
                        case charType: {
                            Character[] charValues = new Character[adaptedProp.getValues().length];
                            int i = 0;
                            while (i < adaptedProp.getValues().length) {
                                if (adaptedProp.getValues()[i] != null) {
                                    String s = adaptedProp.getValues()[i];
                                    charValues[i] = new Character(s.charAt(0));
                                }
                                ++i;
                            }
                            propvalue = charValues;
                            break;
                        }
                        case booleanType: {
                            Boolean[] booleanValues = new Boolean[adaptedProp.getValues().length];
                            int i = 0;
                            while (i < adaptedProp.getValues().length) {
                                if (adaptedProp.getValues()[i] != null) {
                                    booleanValues[i] = Boolean.parseBoolean(adaptedProp.getValues()[i]);
                                }
                                ++i;
                            }
                            propvalue = booleanValues;
                            break;
                        }
                        case shortType: {
                            Short[] shortValues = new Short[adaptedProp.getValues().length];
                            int i = 0;
                            while (i < adaptedProp.getValues().length) {
                                if (adaptedProp.getValues()[i] != null) {
                                    shortValues[i] = Short.parseShort(adaptedProp.getValues()[i]);
                                }
                                ++i;
                            }
                            propvalue = shortValues;
                            break;
                        }
                        case passwordType: {
                            BundleContext bundleContext = FrameworkUtil.getBundle(((Object)((Object)this)).getClass()).getBundleContext();
                            ServiceReference cryptoServiceRef = bundleContext.getServiceReference(CryptoService.class);
                            CryptoService cryptoService = (CryptoService)bundleContext.getService(cryptoServiceRef);
                            Password[] pwdValues = new Password[adaptedProp.getValues().length];
                            int i = 0;
                            while (i < adaptedProp.getValues().length) {
                                if (adaptedProp.getValues()[i] != null) {
                                    if (adaptedProp.isEncrypted()) {
                                        try {
                                            pwdValues[i] = new Password(cryptoService.decryptAes(adaptedProp.getValues()[i]));
                                        }
                                        catch (Exception e) {
                                            if (e instanceof IllegalBlockSizeException || e instanceof NoSuchAlgorithmException || e instanceof NoSuchPaddingException || e instanceof InvalidKeyException || e instanceof IOException || e instanceof IllegalBlockSizeException || e instanceof BadPaddingException) {
                                                pwdValues[i] = new Password(cryptoService.decodeBase64(adaptedProp.getValues()[i]));
                                            }
                                            throw e;
                                        }
                                    } else {
                                        pwdValues[i] = new Password(adaptedProp.getValues()[i]);
                                    }
                                }
                                ++i;
                            }
                            propvalue = pwdValues;
                        }
                    }
                }
                properties.put(propName, propvalue);
            }
            ++n2;
        }
        return properties;
    }
}

