/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.ssl;

import java.util.Map;

public class SslManagerServiceOptions {
    public static final String PROP_PROTOCOL = "ssl.default.protocol";
    public static final String PROP_TRUST_STORE = "ssl.default.trustStore";
    public static final String PROP_CIPHERS = "ssl.default.cipherSuites";
    public static final String PROP_HN_VERIFY = "ssl.hostname.verification";
    public static final String PROP_TRUST_PASSWORD = "ssl.keystore.password";
    public static final String PROP_DEFAULT_PROTOCOL = "TLSv1";
    public static final Boolean PROP_DEFAULT_HN_VERIFY = true;
    public static final String PROP_DEFAULT_TRUST_PASSWORD = "changeit";
    private final Map<String, Object> properties;

    public SslManagerServiceOptions(Map<String, Object> properties) {
        this.properties = properties;
    }

    public Map<String, Object> getConfigurationProperties() {
        return this.properties;
    }

    public String getSslProtocol() {
        if (this.properties != null && this.properties.get(PROP_PROTOCOL) != null && this.properties.get(PROP_PROTOCOL) instanceof String) {
            return (String)this.properties.get(PROP_PROTOCOL);
        }
        return PROP_DEFAULT_PROTOCOL;
    }

    public String getSslKeyStore() {
        if (this.properties != null && this.properties.get(PROP_TRUST_STORE) != null && this.properties.get(PROP_TRUST_STORE) instanceof String) {
            return (String)this.properties.get(PROP_TRUST_STORE);
        }
        return null;
    }

    public String getSslCiphers() {
        if (this.properties != null && this.properties.get(PROP_CIPHERS) != null && this.properties.get(PROP_CIPHERS) instanceof String) {
            return (String)this.properties.get(PROP_CIPHERS);
        }
        return null;
    }

    public String getSslKeystorePassword() {
        if (this.properties != null && this.properties.get(PROP_TRUST_PASSWORD) != null && this.properties.get(PROP_TRUST_PASSWORD) instanceof String) {
            return (String)this.properties.get(PROP_TRUST_PASSWORD);
        }
        return PROP_DEFAULT_TRUST_PASSWORD;
    }

    public Boolean isSslHostnameVerification() {
        if (this.properties != null && this.properties.get(PROP_HN_VERIFY) != null && this.properties.get(PROP_HN_VERIFY) instanceof Boolean) {
            return (Boolean)this.properties.get(PROP_HN_VERIFY);
        }
        return PROP_DEFAULT_HN_VERIFY;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SslManagerServiceOptions)) {
            return false;
        }
        SslManagerServiceOptions other = (SslManagerServiceOptions)obj;
        return !(this.properties == null ? other.properties != null : !this.properties.equals(other.properties));
    }
}

