/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.mtoolkit.iagent.internal.mbsa;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class DataFormater {
    public static final byte ID_C_CHAR = 1;
    public static final byte ID_C_SHORT = 2;
    public static final byte ID_C_INT = 3;
    public static final byte ID_C_LONG = 4;
    public static final byte ID_C_BYTE = 5;
    public static final byte ID_C_WORD = 6;
    public static final byte ID_C_DWORD = 7;
    public static final byte ID_C_QWORD = 8;
    public static final byte ID_STRING = 9;
    public static final byte ARRAY_FLAG = -128;
    public static final int CHAR_SIZE = 1;
    public static final int SHORT_SIZE = 2;
    public static final int INT_SIZE = 4;
    public static final int LONG_SIZE = 8;
    public static final int BYTE_SIZE = 1;
    public static final int WORD_SIZE = 2;
    public static final int DWORD_SIZE = 4;
    public static final int QWORD_SIZE = 8;

    public static byte getByte(InputStream is) throws IOException {
        int byte0 = is.read();
        if (byte0 < 0) {
            throw new EOFException();
        }
        return (byte)byte0;
    }

    public static byte[] getByteArray(InputStream is) throws IOException {
        int expectedLenght = DataFormater.getInt(is);
        byte[] array = new byte[expectedLenght];
        if (expectedLenght > 0) {
            int actualLenght = 0;
            int res = -1;
            while (actualLenght != expectedLenght) {
                res = is.read(array, actualLenght, expectedLenght - actualLenght);
                if (res == -1) {
                    throw new EOFException("The actual data length is " + actualLenght + ", but the expected data length is " + expectedLenght + "!");
                }
                actualLenght += res;
            }
        }
        return array;
    }

    public static void appendByte(OutputStream os, byte value) throws IOException {
        os.write(value);
    }

    public static void appendByteArray(OutputStream os, byte[] array) throws IOException {
        int len = array == null ? 0 : array.length;
        DataFormater.appendInt(os, len);
        if (len > 0) {
            os.write(array);
        }
    }

    public static void appendByteArray(OutputStream os, byte[] array, int off, int len) throws IOException {
        int l_len = array == null ? 0 : len;
        DataFormater.appendInt(os, l_len);
        if (l_len > 0) {
            os.write(array, off, len);
        }
    }

    public static int getInt(InputStream is) throws IOException {
        int byte3;
        int byte2;
        int byte1;
        int byte0 = is.read();
        if ((byte0 | (byte1 = is.read()) | (byte2 = is.read()) | (byte3 = is.read())) < 0) {
            throw new EOFException();
        }
        return (byte0 & 0xFF) << 24 | (byte1 & 0xFF) << 16 | (byte2 & 0xFF) << 8 | byte3 & 0xFF;
    }

    public static int[] getIntArray(InputStream is) throws IOException {
        int[] array = new int[DataFormater.getInt(is)];
        int i = 0;
        while (i < array.length) {
            array[i] = DataFormater.getInt(is);
            ++i;
        }
        return array;
    }

    public static void appendInt(OutputStream os, int value) throws IOException {
        os.write((value & 0xFF000000) >> 24);
        os.write((value & 0xFF0000) >> 16);
        os.write((value & 0xFF00) >> 8);
        os.write(value & 0xFF);
    }

    public static void appendIntArray(OutputStream os, int[] array) throws IOException {
        int len = array == null ? 0 : array.length;
        DataFormater.appendInt(os, len);
        if (len > 0) {
            int i = 0;
            while (i < len) {
                DataFormater.appendInt(os, array[i]);
                ++i;
            }
        }
    }

    public static short getShort(InputStream is) throws IOException {
        int byte1;
        int byte0 = is.read();
        if ((byte0 | (byte1 = is.read())) < 0) {
            throw new EOFException();
        }
        return (short)((byte0 & 0xFF) << 8 | byte1 & 0xFF);
    }

    public static short[] getShortArray(InputStream is) throws IOException {
        short[] array = new short[DataFormater.getInt(is)];
        int i = 0;
        while (i < array.length) {
            array[i] = DataFormater.getShort(is);
            ++i;
        }
        return array;
    }

    public static void appendShort(OutputStream os, short value) throws IOException {
        os.write((value & 0xFF00) >> 8);
        os.write(value & 0xFF);
    }

    public static void appendShortArray(OutputStream os, short[] array) throws IOException {
        int len = array == null ? 0 : array.length;
        DataFormater.appendInt(os, len);
        if (len > 0) {
            int i = 0;
            while (i < len) {
                DataFormater.appendShort(os, array[i]);
                ++i;
            }
        }
    }

    public static long getLong(InputStream is) throws IOException {
        int byte7;
        int byte6;
        int byte5;
        int byte4;
        int byte3;
        int byte2;
        int byte1;
        int byte0 = is.read();
        if ((byte0 | (byte1 = is.read()) | (byte2 = is.read()) | (byte3 = is.read()) | (byte4 = is.read()) | (byte5 = is.read()) | (byte6 = is.read()) | (byte7 = is.read())) < 0) {
            throw new EOFException();
        }
        return ((long)byte0 & 0xFFL) << 56 | ((long)byte1 & 0xFFL) << 48 | ((long)byte2 & 0xFFL) << 40 | ((long)byte3 & 0xFFL) << 32 | ((long)byte4 & 0xFFL) << 24 | ((long)byte5 & 0xFFL) << 16 | ((long)byte6 & 0xFFL) << 8 | (long)byte7 & 0xFFL;
    }

    public static long[] getLongArray(InputStream is) throws IOException {
        long[] array = new long[DataFormater.getInt(is)];
        int i = 0;
        while (i < array.length) {
            array[i] = DataFormater.getLong(is);
            ++i;
        }
        return array;
    }

    public static void appendLong(OutputStream os, long value) throws IOException {
        os.write((int)((value & 0xFF00000000000000L) >> 56));
        os.write((int)((value & 0xFF000000000000L) >> 48));
        os.write((int)((value & 0xFF0000000000L) >> 40));
        os.write((int)((value & 0xFF00000000L) >> 32));
        os.write((int)((value & 0xFF000000L) >> 24));
        os.write((int)((value & 0xFF0000L) >> 16));
        os.write((int)((value & 0xFF00L) >> 8));
        os.write((int)(value & 0xFFL));
    }

    public static void appendLongArray(OutputStream os, long[] array) throws IOException {
        int len = array == null ? 0 : array.length;
        DataFormater.appendInt(os, len);
        if (len > 0) {
            int i = 0;
            while (i < len) {
                DataFormater.appendLong(os, array[i]);
                ++i;
            }
        }
    }

    public static void writeByte(OutputStream os, byte value) throws IOException {
        DataFormater.appendByte(os, (byte)5);
        DataFormater.appendByte(os, value);
    }

    public static byte readByte(InputStream is) throws IOException {
        if (DataFormater.getByte(is) != 5) {
            throw new IOException("Expects data type: 0x" + Integer.toHexString(5));
        }
        return DataFormater.getByte(is);
    }

    public static void writeByteArray(OutputStream os, byte[] value) throws IOException {
        DataFormater.appendByte(os, (byte)-123);
        DataFormater.appendByteArray(os, value);
    }

    public static void writeByteArray(OutputStream os, byte[] value, int off, int len) throws IOException {
        DataFormater.appendByte(os, (byte)-123);
        DataFormater.appendByteArray(os, value, off, len);
    }

    public static void writeChar(OutputStream os, byte value) throws IOException {
        DataFormater.appendByte(os, (byte)1);
        DataFormater.appendByte(os, value);
    }

    public static byte readChar(InputStream is) throws IOException {
        if (DataFormater.getByte(is) != 1) {
            throw new IOException("Expects data type: 0x" + Integer.toHexString(1));
        }
        return DataFormater.getByte(is);
    }

    public static void writeCharArray(OutputStream os, byte[] value) throws IOException {
        DataFormater.appendByte(os, (byte)-127);
        DataFormater.appendByteArray(os, value);
    }

    public static byte[] readByteArray(InputStream is) throws IOException {
        if (DataFormater.getByte(is) != -123) {
            throw new IOException("Expects data type: 0x" + Integer.toHexString(-123));
        }
        return DataFormater.getByteArray(is);
    }

    public static byte[] readCharArray(InputStream is) throws IOException {
        if (DataFormater.getByte(is) != -127) {
            throw new IOException("Expects data type: 0x" + Integer.toHexString(129));
        }
        return DataFormater.getByteArray(is);
    }

    public static void writeShort(OutputStream os, short value) throws IOException {
        DataFormater.appendByte(os, (byte)2);
        DataFormater.appendShort(os, value);
    }

    public static short readShort(InputStream is) throws IOException {
        if (DataFormater.getByte(is) != 2) {
            throw new IOException("Expects data type: 0x" + Integer.toHexString(2));
        }
        return DataFormater.getShort(is);
    }

    public static void writeShortArray(OutputStream os, short[] value) throws IOException {
        DataFormater.appendByte(os, (byte)-126);
        DataFormater.appendShortArray(os, value);
    }

    public static short[] readShortArray(InputStream is) throws IOException {
        if (DataFormater.getByte(is) != -126) {
            throw new IOException("Expects data type: 0x" + Integer.toHexString(130));
        }
        return DataFormater.getShortArray(is);
    }

    public static void writeWord(OutputStream os, short value) throws IOException {
        DataFormater.appendByte(os, (byte)6);
        DataFormater.appendShort(os, value);
    }

    public static short readWord(InputStream is) throws IOException {
        if (DataFormater.getByte(is) != 6) {
            throw new IOException("Expects data type: 0x" + Integer.toHexString(6));
        }
        return DataFormater.getShort(is);
    }

    public static void writeWordArray(OutputStream os, short[] value) throws IOException {
        DataFormater.appendByte(os, (byte)-122);
        DataFormater.appendShortArray(os, value);
    }

    public static short[] readWordArray(InputStream is) throws IOException {
        if (DataFormater.getByte(is) != -122) {
            throw new IOException("Expects data type: 0x" + Integer.toHexString(134));
        }
        return DataFormater.getShortArray(is);
    }

    public static void writeInt(OutputStream os, int value) throws IOException {
        DataFormater.appendByte(os, (byte)3);
        DataFormater.appendInt(os, value);
    }

    public static int readInt(InputStream is) throws IOException {
        if (DataFormater.getByte(is) != 3) {
            throw new IOException("Expects data type: 0x" + Integer.toHexString(3));
        }
        return DataFormater.getInt(is);
    }

    public static void writeIntArray(OutputStream os, int[] value) throws IOException {
        DataFormater.appendByte(os, (byte)-125);
        DataFormater.appendIntArray(os, value);
    }

    public static int[] readIntArray(InputStream is) throws IOException {
        if (DataFormater.getByte(is) != -125) {
            throw new IOException("Expects data type: 0x" + Integer.toHexString(131));
        }
        return DataFormater.getIntArray(is);
    }

    public static void writeDWord(OutputStream os, int value) throws IOException {
        DataFormater.appendByte(os, (byte)7);
        DataFormater.appendInt(os, value);
    }

    public static int readDWord(InputStream is) throws IOException {
        if (DataFormater.getByte(is) != 7) {
            throw new IOException("Expects data type: 0x" + Integer.toHexString(7));
        }
        return DataFormater.getInt(is);
    }

    public static void writeDWordArray(OutputStream os, int[] value) throws IOException {
        DataFormater.appendByte(os, (byte)-121);
        DataFormater.appendIntArray(os, value);
    }

    public static int[] readDWordArray(InputStream is) throws IOException {
        if (DataFormater.getByte(is) != -121) {
            throw new IOException("Expects data type: 0x" + Integer.toHexString(135));
        }
        return DataFormater.getIntArray(is);
    }

    public static void writeLong(OutputStream os, long value) throws IOException {
        DataFormater.appendByte(os, (byte)4);
        DataFormater.appendLong(os, value);
    }

    public static long readLong(InputStream is) throws IOException {
        if (DataFormater.getByte(is) != 4) {
            throw new IOException("Expects data type: 0x" + Integer.toHexString(4));
        }
        return DataFormater.getLong(is);
    }

    public static void writeLongArray(OutputStream os, long[] value) throws IOException {
        DataFormater.appendByte(os, (byte)-124);
        DataFormater.appendLongArray(os, value);
    }

    public static long[] readLongArray(InputStream is) throws IOException {
        if (DataFormater.getByte(is) != -124) {
            throw new IOException("Expects data type: 0x" + Integer.toHexString(132));
        }
        return DataFormater.getLongArray(is);
    }

    public static void writeQWord(OutputStream os, long value) throws IOException {
        DataFormater.appendByte(os, (byte)8);
        DataFormater.appendLong(os, value);
    }

    public static long readQWord(InputStream is) throws IOException {
        if (DataFormater.getByte(is) != 8) {
            throw new IOException("Expects data type: 0x" + Integer.toHexString(8));
        }
        return DataFormater.getLong(is);
    }

    public static void writeQWordArray(OutputStream os, long[] value) throws IOException {
        DataFormater.appendByte(os, (byte)-120);
        DataFormater.appendLongArray(os, value);
    }

    public static long[] readQWordArray(InputStream is) throws IOException {
        if (DataFormater.getByte(is) != -120) {
            throw new IOException("Expects data type: 0x" + Integer.toHexString(136));
        }
        return DataFormater.getLongArray(is);
    }

    public static void writeString(OutputStream os, String value) throws IOException {
        byte[] utf8 = value == null || value.length() == 0 ? (byte[])null : value.getBytes("UTF8");
        DataFormater.writeByteArray(os, utf8);
    }

    public static void writeStringArray(OutputStream os, String[] value) throws IOException {
        int len = value == null ? 0 : value.length;
        DataFormater.writeInt(os, len);
        if (len > 0) {
            int i = 0;
            while (i < len) {
                DataFormater.writeString(os, value[i]);
                ++i;
            }
        }
    }

    public static String readString(InputStream is) throws IOException {
        byte[] utf8 = DataFormater.readByteArray(is);
        if (utf8 == null || utf8.length == 0) {
            return "";
        }
        return new String(utf8, "UTF8");
    }

    public static String[] readStringArray(InputStream is) throws IOException {
        int len = DataFormater.readInt(is);
        String[] arr = new String[len];
        int i = 0;
        while (i < len) {
            arr[i] = DataFormater.readString(is);
            ++i;
        }
        return arr;
    }

    public static final void closeOutputStream(OutputStream os) {
        if (os != null) {
            try {
                os.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static final void closeInputStream(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
    }
}

