/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.mtoolkit.iagent.internal.pmp;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.tigris.mtoolkit.iagent.internal.pmp.ObjectInfo;
import org.tigris.mtoolkit.iagent.internal.pmp.PMPConnectionDispatcher;
import org.tigris.mtoolkit.iagent.internal.pmp.PMPSessionThread;
import org.tigris.mtoolkit.iagent.internal.utils.ThreadPool;
import org.tigris.mtoolkit.iagent.pmp.PMPConnectionListener;
import org.tigris.mtoolkit.iagent.pmp.PMPPeer;

public class PMPPeerImpl
implements PMPPeer {
    protected List connections = new ArrayList();
    protected int numSessions;
    protected int maxStringLength = -1;
    protected int maxArrayLength = -1;
    protected ThreadPool pool;
    protected Vector listeners = new Vector(2, 5);
    protected PMPConnectionDispatcher connDispatcher;

    public PMPPeerImpl() {
        this.pool = ThreadPool.getPool();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addElement(PMPSessionThread ss) {
        List list = this.connections;
        synchronized (list) {
            if (!this.connections.contains(ss)) {
                this.connections.add(ss);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeElement(PMPSessionThread ss) {
        List list = this.connections;
        synchronized (list) {
            this.connections.remove(ss);
        }
    }

    protected synchronized String createSessionId() {
        return String.valueOf(this.numSessions++);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeConnections(String reason) {
        List list = this.connections;
        synchronized (list) {
            PMPSessionThread[] copied = this.connections.toArray(new PMPSessionThread[this.connections.size()]);
            int i = 0;
            while (i < copied.length) {
                PMPSessionThread session = copied[i];
                session.disconnect(reason, true);
                ++i;
            }
        }
    }

    public void close() {
        if (this.pool != null) {
            ThreadPool.releasePool(this.pool);
            this.pool = null;
        }
    }

    protected ObjectInfo getService(String clazz, String filter) {
        throw new UnsupportedOperationException();
    }

    protected void ungetService(ObjectInfo info) {
        throw new UnsupportedOperationException();
    }

    protected byte removeListener(String evType, PMPSessionThread listener) {
        throw new UnsupportedOperationException();
    }

    protected void removeListeners(Vector evTypes, PMPSessionThread listener) {
        throw new UnsupportedOperationException();
    }

    protected byte addListener(String evType, PMPSessionThread listener) {
        throw new UnsupportedOperationException();
    }

    public String getRole() {
        return "Peer";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectionListener(PMPConnectionListener listener) {
        if (this.connDispatcher == null) {
            this.connDispatcher = new PMPConnectionDispatcher(this);
        }
        Vector vector = this.listeners;
        synchronized (vector) {
            if (!this.listeners.contains(listener)) {
                this.listeners.addElement(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnectionListener(PMPConnectionListener listener) {
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.removeElement(listener);
        }
    }

    protected void fireConnectionEvent(boolean created, PMPSessionThread ss) {
        if (this.connDispatcher != null) {
            this.connDispatcher.addEvent(created, ss);
        }
    }
}

