/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.mtoolkit.iagent.internal.pmp;

import java.net.Socket;
import java.util.Dictionary;
import org.tigris.mtoolkit.iagent.internal.pmp.Connection;
import org.tigris.mtoolkit.iagent.internal.pmp.PMPPeerImpl;
import org.tigris.mtoolkit.iagent.internal.pmp.PMPSessionThread;
import org.tigris.mtoolkit.iagent.pmp.PMPConnection;
import org.tigris.mtoolkit.iagent.pmp.PMPException;
import org.tigris.mtoolkit.iagent.pmp.PMPService;
import org.tigris.mtoolkit.iagent.transport.Transport;

public class PMPServiceImpl
extends PMPPeerImpl
implements PMPService {
    private static final int DEFAULT_PMP_PORT = 1450;
    protected boolean running = false;
    protected static ClassLoader loader;

    public PMPServiceImpl() {
        this.numSessions = 0;
        loader = this.getClass().getClassLoader();
        this.running = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        PMPServiceImpl pMPServiceImpl = this;
        synchronized (pMPServiceImpl) {
            if (!this.running) {
                return;
            }
            this.running = false;
        }
        this.info("Disconnecting Clients ...");
        this.closeConnections("PMP Service has been stopped.");
        if (this.connDispatcher != null) {
            this.connDispatcher.stopEvent();
        }
        super.close();
    }

    public String getName() {
        return "PMPService";
    }

    public PMPConnection connect(String uri) throws PMPException {
        if (!this.running) {
            throw new PMPException("Stopping pmpservice");
        }
        if (uri == null || uri.length() == 0) {
            throw new PMPException("URI can't be null");
        }
        try {
            this.info("Creating new connection for " + uri);
            PMPSessionThread st = null;
            Socket socket = new Socket(uri, 1450);
            socket.setSoTimeout(1000);
            st = new PMPSessionThread(this, socket, this.createSessionId(), uri);
            Connection con = st.getConnection();
            con.connect();
            this.addElement(st);
            return con;
        }
        catch (Exception exc) {
            this.error("Error creating connection for " + uri, exc);
            if (exc instanceof PMPException) {
                throw (PMPException)exc;
            }
            throw new PMPException(exc.getMessage(), exc);
        }
    }

    public PMPConnection connect(Transport transport, Dictionary properties) throws PMPException {
        if (!this.running) {
            throw new PMPException("Stopping pmpservice");
        }
        try {
            this.info("Creating new connection for " + transport);
            Object pmpPort = properties.get("pmp-port");
            int port = -1;
            if (pmpPort != null && pmpPort instanceof Integer) {
                port = (Integer)pmpPort;
            }
            if (port < 0) {
                port = 1450;
            }
            PMPSessionThread st = null;
            st = new PMPSessionThread(this, transport.createConnection(port), this.createSessionId());
            Connection con = st.getConnection();
            con.connect();
            this.addElement(st);
            return con;
        }
        catch (Exception exc) {
            this.error("Error creating connection for " + transport, exc);
            if (exc instanceof PMPException) {
                throw (PMPException)exc;
            }
            throw new PMPException(exc.getMessage(), exc);
        }
    }

    protected void removeElement(PMPSessionThread ss) {
        super.removeElement(ss);
        if (this.connDispatcher != null && ss.connected) {
            this.connDispatcher.addEvent(false, ss);
        }
    }

    protected static boolean checkInstance(Class[] interfaces, Class serviceClass) {
        if (interfaces == null) {
            return false;
        }
        boolean toRet = false;
        int i = 0;
        while (i < interfaces.length) {
            if (interfaces[i] != null) {
                toRet = true;
                if (!interfaces[i].isAssignableFrom(serviceClass)) {
                    return false;
                }
            }
            ++i;
        }
        return toRet;
    }

    protected void debug(String msg) {
    }

    protected void error(String msg, Throwable exc) {
    }

    protected void info(String msg) {
    }

    public String getRole() {
        return "Client";
    }
}

