/*
 * Decompiled with CFR 0.152.
 */
package com.codeminders.hidapi;

import com.codeminders.hidapi.HIDDevice;
import com.codeminders.hidapi.HIDDeviceInfo;
import com.codeminders.hidapi.HIDManager;
import java.io.IOException;

public class HIDAPITest {
    private static final long READ_UPDATE_DELAY_MS = 50L;
    static final int VENDOR_ID = 3695;
    static final int PRODUCT_ID = 25346;
    private static final int BUFSIZE = 2048;

    public static void main(String[] args) throws IOException {
        HIDAPITest.listDevices();
        HIDAPITest.readDevice();
    }

    private static void readDevice() {
        try {
            HIDManager hid_mgr = HIDManager.getInstance();
            HIDDevice dev = hid_mgr.openById(3695, 25346, null);
            System.err.print("Manufacturer: " + dev.getManufacturerString() + "\n");
            System.err.print("Product: " + dev.getProductString() + "\n");
            System.err.print("Serial Number: " + dev.getSerialNumberString() + "\n");
            try {
                byte[] buf = new byte[2048];
                dev.enableBlocking();
                while (true) {
                    int n = dev.read(buf);
                    for (int i = 0; i < n; ++i) {
                        int v = buf[i];
                        if (v < 0) {
                            v += 256;
                        }
                        String hs = Integer.toHexString(v);
                        if (v < 16) {
                            System.err.print("0");
                        }
                        System.err.print(hs + " ");
                    }
                    System.err.println("");
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (Throwable throwable) {
                dev.close();
                hid_mgr.release();
                System.gc();
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
    }

    private static void listDevices() {
        String property = System.getProperty("java.library.path");
        System.err.println(property);
        try {
            HIDManager manager = HIDManager.getInstance();
            HIDDeviceInfo[] devs = manager.listDevices();
            System.err.println("Devices:\n\n");
            for (int i = 0; i < devs.length; ++i) {
                System.err.println("" + i + ".\t" + devs[i]);
                System.err.println("---------------------------------------------\n");
            }
            System.gc();
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
    }

    static {
        System.loadLibrary("hidapi-jni");
    }
}

