/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.cloudconnection.eclipseiot.mqtt.cloud;

import java.util.Map;
import org.eclipse.kura.cloud.CloudPayloadEncoding;
import org.eclipse.kura.internal.cloudconnection.eclipseiot.mqtt.cloud.CloudServiceLifecycleCertsPolicy;
import org.eclipse.kura.system.SystemService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudConnectionManagerOptions {
    private static final Logger logger = LoggerFactory.getLogger(CloudConnectionManagerOptions.class);
    private static final String TOPIC_SEPARATOR = "/";
    private static final String TOPIC_BIRTH_SUFFIX = "MQTT/BIRTH";
    private static final String TOPIC_DISCONNECT_SUFFIX = "MQTT/DC";
    private static final String TOPIC_APPS_SUFFIX = "MQTT/APPS";
    private static final String TOPIC_WILD_CARD = "#";
    private static final String DEVICE_DISPLAY_NAME = "device.display-name";
    private static final String DEVICE_CUSTOM_NAME = "device.custom-name";
    private static final String ENCODE_GZIP = "encode.gzip";
    private static final String REPUB_BIRTH_ON_GPS_LOCK = "republish.mqtt.birth.cert.on.gps.lock";
    private static final String REPUB_BIRTH_ON_MODEM_DETECT = "republish.mqtt.birth.cert.on.modem.detect";
    private static final String BIRTH_CERT_POLICY = "birth.cert.policy";
    private static final String PAYLOAD_ENCODING = "payload.encoding";
    private static final int LIFECYCLE_QOS = 1;
    private static final int LIFECYCLE_PRIORITY = 0;
    private static final boolean LIFECYCLE_RETAIN = false;
    private final Map<String, Object> properties;
    private final SystemService systemService;

    CloudConnectionManagerOptions(Map<String, Object> properties, SystemService systemService) {
        this.properties = properties;
        this.systemService = systemService;
    }

    public String getDeviceDisplayName() {
        String displayName = "";
        if (this.properties == null) {
            return displayName;
        }
        String deviceDisplayNameOption = (String)this.properties.get(DEVICE_DISPLAY_NAME);
        if ("device-name".equals(deviceDisplayNameOption)) {
            displayName = this.systemService.getDeviceName();
        } else if ("hostname".equals(deviceDisplayNameOption)) {
            displayName = this.systemService.getHostname();
        } else if ("custom".equals(deviceDisplayNameOption) && this.properties.get(DEVICE_CUSTOM_NAME) instanceof String) {
            displayName = (String)this.properties.get(DEVICE_CUSTOM_NAME);
        } else if ("server".equals(deviceDisplayNameOption)) {
            displayName = "";
        }
        return displayName;
    }

    public boolean getEncodeGzip() {
        boolean encodeGzip = false;
        if (this.properties != null && this.properties.get(ENCODE_GZIP) != null && this.properties.get(ENCODE_GZIP) instanceof Boolean) {
            encodeGzip = (Boolean)this.properties.get(ENCODE_GZIP);
        }
        return encodeGzip;
    }

    public boolean getRepubBirthCertOnGpsLock() {
        boolean repubBirth = false;
        if (this.properties != null && this.properties.get(REPUB_BIRTH_ON_GPS_LOCK) != null && this.properties.get(REPUB_BIRTH_ON_GPS_LOCK) instanceof Boolean) {
            repubBirth = (Boolean)this.properties.get(REPUB_BIRTH_ON_GPS_LOCK);
        }
        return repubBirth;
    }

    public boolean getRepubBirthCertOnModemDetection() {
        boolean repubBirth = false;
        if (this.properties != null && this.properties.get(REPUB_BIRTH_ON_MODEM_DETECT) != null && this.properties.get(REPUB_BIRTH_ON_MODEM_DETECT) instanceof Boolean) {
            repubBirth = (Boolean)this.properties.get(REPUB_BIRTH_ON_MODEM_DETECT);
        }
        return repubBirth;
    }

    public boolean isLifecycleCertsDisabled() {
        boolean birthPubDisabled = false;
        String birthPubPolicy = "";
        if (this.properties != null && this.properties.get(BIRTH_CERT_POLICY) != null && this.properties.get(BIRTH_CERT_POLICY) instanceof String) {
            birthPubPolicy = (String)this.properties.get(BIRTH_CERT_POLICY);
        }
        if (CloudServiceLifecycleCertsPolicy.DISABLE_PUBLISHING.getValue().equals(birthPubPolicy)) {
            birthPubDisabled = true;
        }
        return birthPubDisabled;
    }

    public boolean getRepubBirthCertOnReconnect() {
        boolean republishBirt = true;
        String birthPubPolicy = "";
        if (this.properties != null && this.properties.get(BIRTH_CERT_POLICY) != null && this.properties.get(BIRTH_CERT_POLICY) instanceof String) {
            birthPubPolicy = (String)this.properties.get(BIRTH_CERT_POLICY);
        }
        if (!CloudServiceLifecycleCertsPolicy.PUBLISH_BIRTH_CONNECT_RECONNECT.getValue().equals(birthPubPolicy)) {
            republishBirt = false;
        }
        return republishBirt;
    }

    public CloudPayloadEncoding getPayloadEncoding() {
        CloudPayloadEncoding result = CloudPayloadEncoding.KURA_PROTOBUF;
        String encodingString = "";
        if (this.properties != null && this.properties.get(PAYLOAD_ENCODING) != null && this.properties.get(PAYLOAD_ENCODING) instanceof String) {
            encodingString = (String)this.properties.get(PAYLOAD_ENCODING);
        }
        try {
            result = CloudPayloadEncoding.getEncoding((String)encodingString);
        }
        catch (IllegalArgumentException e) {
            logger.warn("Cannot parse the provided payload encoding.", (Throwable)e);
        }
        return result;
    }

    public String getTopicSeparator() {
        return TOPIC_SEPARATOR;
    }

    public String getTopicBirthSuffix() {
        return TOPIC_BIRTH_SUFFIX;
    }

    public String getTopicDisconnectSuffix() {
        return TOPIC_DISCONNECT_SUFFIX;
    }

    public String getTopicAppsSuffix() {
        return TOPIC_APPS_SUFFIX;
    }

    public String getTopicWildCard() {
        return TOPIC_WILD_CARD;
    }

    public int getLifeCycleMessageQos() {
        return 1;
    }

    public int getLifeCycleMessagePriority() {
        return 0;
    }

    public boolean getLifeCycleMessageRetain() {
        return false;
    }
}

