/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.cloud.app.command;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.kura.KuraErrorCode;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.cloud.app.command.KuraCommandRequestPayload;
import org.eclipse.kura.cloud.app.command.KuraCommandResponsePayload;
import org.eclipse.kura.cloud.app.command.ProcessMonitorThread;
import org.eclipse.kura.cloud.app.command.UnZip;
import org.eclipse.kura.cloudconnection.message.KuraMessage;
import org.eclipse.kura.cloudconnection.request.RequestHandler;
import org.eclipse.kura.cloudconnection.request.RequestHandlerContext;
import org.eclipse.kura.cloudconnection.request.RequestHandlerMessageConstants;
import org.eclipse.kura.cloudconnection.request.RequestHandlerRegistry;
import org.eclipse.kura.command.PasswordCommandService;
import org.eclipse.kura.configuration.ConfigurableComponent;
import org.eclipse.kura.configuration.Password;
import org.eclipse.kura.crypto.CryptoService;
import org.eclipse.kura.message.KuraPayload;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandCloudApp
implements ConfigurableComponent,
PasswordCommandService,
RequestHandler {
    private static final Logger logger = LoggerFactory.getLogger(CommandCloudApp.class);
    private static final String EDC_PASSWORD_METRIC_NAME = "command.password";
    private static final String COMMAND_ENABLED_ID = "command.enable";
    private static final String COMMAND_PASSWORD_ID = "command.password.value";
    private static final String COMMAND_WORKDIR_ID = "command.working.directory";
    private static final String COMMAND_TIMEOUT_ID = "command.timeout";
    private static final String COMMAND_ENVIRONMENT_ID = "command.environment";
    public static final String APP_ID = "CMD-V1";
    private Map<String, Object> properties;
    private CryptoService cryptoService;
    private boolean currentStatus;
    public static final String RESOURCE_COMMAND = "command";

    public void setCryptoService(CryptoService cryptoService) {
        this.cryptoService = cryptoService;
    }

    public void unsetCryptoService(CryptoService cryptoService) {
        this.cryptoService = null;
    }

    public void setRequestHandlerRegistry(RequestHandlerRegistry requestHandlerRegistry) {
        try {
            requestHandlerRegistry.registerRequestHandler(APP_ID, (RequestHandler)this);
        }
        catch (KuraException kuraException) {
            logger.info("Unable to register request handler {} in {}", (Object)APP_ID, (Object)requestHandlerRegistry.getClass().getName());
        }
    }

    public void unsetRequestHandlerRegistry(RequestHandlerRegistry requestHandlerRegistry) {
        try {
            requestHandlerRegistry.unregister(APP_ID);
        }
        catch (KuraException kuraException) {
            logger.info("Unable to register request handler {} in {}", (Object)APP_ID, (Object)requestHandlerRegistry.getClass().getName());
        }
    }

    protected void activate(Map<String, Object> properties) {
        logger.info("Request handler {} has started with config!", (Object)APP_ID);
        this.updated(properties);
    }

    public void updated(Map<String, Object> properties) {
        logger.info("updated...: {}", properties);
        this.currentStatus = (Boolean)properties.get(COMMAND_ENABLED_ID);
        this.properties = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (key.equals(COMMAND_PASSWORD_ID)) {
                try {
                    Password decryptedPassword = new Password(this.cryptoService.decryptAes(value.toString().toCharArray()));
                    this.properties.put(key, decryptedPassword);
                }
                catch (Exception exception) {
                    this.properties.put(key, new Password((String)value));
                }
                continue;
            }
            this.properties.put(key, value);
        }
    }

    protected void deactivate(ComponentContext componentContext) {
        logger.info("Request handler {} is deactivating!", (Object)APP_ID);
    }

    public KuraMessage doExec(RequestHandlerContext requestContext, KuraMessage reqMessage) throws KuraException {
        if (!this.currentStatus) {
            throw new KuraException(KuraErrorCode.NOT_FOUND);
        }
        Object requestObject = reqMessage.getProperties().get(RequestHandlerMessageConstants.ARGS_KEY.value());
        if (!(requestObject instanceof List)) {
            throw new KuraException(KuraErrorCode.BAD_REQUEST);
        }
        List resources = (List)requestObject;
        if (resources.size() != 1) {
            logger.error("Bad request topic: {}", (Object)resources);
            logger.error("Expected one resource but found {}", (Object)resources.size());
            throw new KuraException(KuraErrorCode.BAD_REQUEST);
        }
        if (!((String)resources.get(0)).equals(RESOURCE_COMMAND)) {
            logger.error("Bad request topic: {}", (Object)resources);
            logger.error("Cannot find resource with name: {}", resources.get(0));
            throw new KuraException(KuraErrorCode.NOT_FOUND);
        }
        logger.info("EXECuting resource: {}", (Object)RESOURCE_COMMAND);
        KuraPayload reqPayload = reqMessage.getPayload();
        KuraPayload resPayload = this.execute(reqPayload);
        return new KuraMessage(resPayload);
    }

    public KuraPayload execute(KuraPayload reqPayload) throws KuraException {
        KuraCommandRequestPayload commandReq = new KuraCommandRequestPayload(reqPayload);
        String receivedPassword = (String)commandReq.getMetric(EDC_PASSWORD_METRIC_NAME);
        Password commandPassword = (Password)this.properties.get(COMMAND_PASSWORD_ID);
        KuraCommandResponsePayload commandResp = new KuraCommandResponsePayload(200);
        boolean isExecutionAllowed = this.verifyPasswords(commandPassword, receivedPassword);
        if (isExecutionAllowed) {
            String command = commandReq.getCommand();
            if (command == null || command.trim().isEmpty()) {
                logger.error("null command");
                throw new KuraException(KuraErrorCode.BAD_REQUEST);
            }
            String[] cmdarray = this.prepareCommandArray(commandReq, command);
            String[] envp = this.getEnvironment(commandReq);
            String dir = this.getDir(commandReq);
            byte[] zipBytes = commandReq.getZipBytes();
            if (zipBytes != null) {
                try {
                    UnZip.unZipBytes(zipBytes, dir);
                }
                catch (IOException e) {
                    logger.error("Error unzipping command zip bytes", (Throwable)e);
                    throw new KuraException(KuraErrorCode.DECODER_ERROR);
                }
            }
            Process proc = null;
            try {
                proc = this.createExecutionProcess(dir, cmdarray, envp);
            }
            catch (Throwable t) {
                logger.error("Error executing command {}", t);
                throw new KuraException(KuraErrorCode.PROCESS_EXECUTION_ERROR);
            }
            boolean runAsync = commandReq.isRunAsync() != null ? commandReq.isRunAsync() : false;
            int timeout = this.getTimeout(commandReq);
            ProcessMonitorThread pmt = new ProcessMonitorThread(proc, commandReq.getStdin(), timeout);
            pmt.start();
            if (!runAsync) {
                try {
                    pmt.join();
                    this.prepareResponseNoTimeout(commandResp, pmt);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    pmt.interrupt();
                    this.prepareTimeoutResponse(commandResp, pmt);
                }
            }
        } else {
            logger.error("Password required but not correct and/or missing");
            throw new KuraException(KuraErrorCode.BAD_REQUEST);
        }
        return commandResp;
    }

    public String execute(String cmd, String password) throws KuraException {
        boolean verificationEnabled = (Boolean)this.properties.get(COMMAND_ENABLED_ID);
        if (verificationEnabled) {
            Password commandPassword = (Password)this.properties.get(COMMAND_PASSWORD_ID);
            boolean isExecutionAllowed = this.verifyPasswords(commandPassword, password);
            if (isExecutionAllowed) {
                String[] cmdArray = cmd.split(" ");
                String defaultDir = this.getDefaultWorkDir();
                String[] environment = this.getDefaultEnvironment();
                try {
                    Process proc = this.createExecutionProcess(defaultDir, cmdArray, environment);
                    int timeout = this.getDefaultTimeout();
                    ProcessMonitorThread pmt = new ProcessMonitorThread(proc, null, timeout);
                    pmt.start();
                    try {
                        pmt.join();
                        if (pmt.getExitValue() != null && pmt.getExitValue() == 0) {
                            return pmt.getStdout();
                        }
                        return pmt.getStderr();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        pmt.interrupt();
                        throw KuraException.internalError((Throwable)e);
                    }
                }
                catch (IOException ex) {
                    throw new KuraException(KuraErrorCode.INTERNAL_ERROR, (Throwable)ex, new Object[0]);
                }
            }
            throw new KuraException(KuraErrorCode.CONFIGURATION_ATTRIBUTE_INVALID);
        }
        throw new KuraException(KuraErrorCode.OPERATION_NOT_SUPPORTED);
    }

    private String getDefaultWorkDir() {
        String workDir = (String)this.properties.get(COMMAND_WORKDIR_ID);
        if (workDir != null && !workDir.isEmpty()) {
            return workDir;
        }
        return System.getProperty("java.io.tmpdir");
    }

    private int getDefaultTimeout() {
        return (Integer)this.properties.get(COMMAND_TIMEOUT_ID);
    }

    private String[] getDefaultEnvironment() {
        String envString = (String)this.properties.get(COMMAND_ENVIRONMENT_ID);
        if (envString != null) {
            return envString.split(" ");
        }
        return null;
    }

    private String getDir(KuraCommandRequestPayload req) {
        String dir = req.getWorkingDir();
        String defaultDir = this.getDefaultWorkDir();
        if (dir != null && !dir.isEmpty()) {
            return dir;
        }
        return defaultDir;
    }

    private int getTimeout(KuraCommandRequestPayload req) {
        Integer timeout = req.getTimeout();
        int defaultTimeout = this.getDefaultTimeout();
        if (timeout != null) {
            return timeout;
        }
        return defaultTimeout;
    }

    private String[] getEnvironment(KuraCommandRequestPayload req) {
        String[] envp = req.getEnvironmentPairs();
        String[] defaultEnv = this.getDefaultEnvironment();
        if (envp != null && envp.length != 0) {
            return envp;
        }
        return defaultEnv;
    }

    private boolean verifyPasswords(Password commandPassword, String receivedPassword) {
        if (commandPassword == null && receivedPassword == null) {
            return true;
        }
        if (commandPassword == null && "".equals(receivedPassword)) {
            return true;
        }
        if (commandPassword == null) {
            return false;
        }
        if ("".equals(commandPassword.toString()) && receivedPassword == null) {
            return true;
        }
        if ("".equals(commandPassword.toString()) && "".equals(receivedPassword)) {
            return true;
        }
        String pwd = commandPassword.toString();
        return pwd.equals(receivedPassword);
    }

    private Process createExecutionProcess(String dir, String[] cmdarray, String[] envp) throws IOException {
        Runtime rt = Runtime.getRuntime();
        File fileDir = dir == null ? null : new File(dir);
        return rt.exec(cmdarray, envp, fileDir);
    }

    private String[] prepareCommandArray(KuraCommandRequestPayload req, String command) {
        String[] args = req.getArguments();
        int argsCount = args != null ? args.length : 0;
        String[] cmdarray = new String[1 + argsCount];
        cmdarray[0] = command;
        if (args != null) {
            System.arraycopy(args, 0, cmdarray, 1, argsCount);
        }
        String[] stringArray = cmdarray;
        int n = cmdarray.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            logger.debug("cmdarray: {}", (Object)element);
            ++n2;
        }
        return cmdarray;
    }

    private void prepareResponseNoTimeout(KuraCommandResponsePayload resp, ProcessMonitorThread pmt) {
        if (pmt.getException() != null) {
            resp.setResponseCode(500);
            resp.setException(pmt.getException());
        } else {
            resp.setTimedout(pmt.isTimedOut());
            if (!pmt.isTimedOut()) {
                resp.setExitCode(pmt.getExitValue());
            }
        }
        resp.setStderr(pmt.getStderr());
        resp.setStdout(pmt.getStdout());
    }

    private void prepareTimeoutResponse(KuraCommandResponsePayload resp, ProcessMonitorThread pmt) {
        resp.setStderr(pmt.getStderr());
        resp.setStdout(pmt.getStdout());
        resp.setTimedout(true);
    }
}

