/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.cloud;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Date;
import org.eclipse.kura.core.cloud.CloudPayloadJsonFields;
import org.eclipse.kura.message.KuraPayload;
import org.eclipse.kura.message.KuraPosition;

public class CloudPayloadJsonEncoder {
    private CloudPayloadJsonEncoder() {
    }

    public static byte[] getBytes(KuraPayload kuraPayload) {
        JsonObject json = Json.object();
        CloudPayloadJsonEncoder.encodeTimestamp(kuraPayload, json);
        CloudPayloadJsonEncoder.encodePosition(kuraPayload, json);
        CloudPayloadJsonEncoder.encodeMetrics(kuraPayload, json);
        CloudPayloadJsonEncoder.encodeBody(kuraPayload, json);
        return json.toString().getBytes(StandardCharsets.UTF_8);
    }

    private static void encodeBody(KuraPayload kuraPayload, JsonObject json) {
        byte[] body = kuraPayload.getBody();
        if (body != null) {
            json.add(CloudPayloadJsonFields.BODY.value(), Base64.getEncoder().encodeToString(body));
        }
    }

    private static void encodeMetrics(KuraPayload kuraPayload, JsonObject json) {
        JsonObject jsonMetrics = Json.object();
        for (String name : kuraPayload.metricNames()) {
            Object object = kuraPayload.getMetric(name);
            if (object instanceof Boolean) {
                jsonMetrics.add(name, ((Boolean)object).booleanValue());
                continue;
            }
            if (object instanceof Double) {
                jsonMetrics.add(name, ((Double)object).doubleValue());
                continue;
            }
            if (object instanceof Float) {
                jsonMetrics.add(name, ((Float)object).floatValue());
                continue;
            }
            if (object instanceof Integer) {
                jsonMetrics.add(name, ((Integer)object).intValue());
                continue;
            }
            if (object instanceof Long) {
                jsonMetrics.add(name, ((Long)object).longValue());
                continue;
            }
            if (object instanceof String) {
                jsonMetrics.add(name, (String)object);
                continue;
            }
            if (object instanceof byte[]) {
                jsonMetrics.add(name, Base64.getEncoder().encodeToString((byte[])object));
                continue;
            }
            throw new IllegalArgumentException("Cannot encode this value: " + object.toString());
        }
        json.add(CloudPayloadJsonFields.METRICS.value(), (JsonValue)jsonMetrics);
    }

    private static void encodePosition(KuraPayload kuraPayload, JsonObject json) {
        KuraPosition position = kuraPayload.getPosition();
        if (position != null) {
            JsonObject jsonPosition = Json.object();
            if (position.getLatitude() != null) {
                jsonPosition.add(CloudPayloadJsonFields.CloudPayloadJsonPositionFields.LATITUDE.value(), position.getLatitude().doubleValue());
            }
            if (position.getLongitude() != null) {
                jsonPosition.add(CloudPayloadJsonFields.CloudPayloadJsonPositionFields.LONGITUDE.value(), position.getLongitude().doubleValue());
            }
            if (position.getAltitude() != null) {
                jsonPosition.add(CloudPayloadJsonFields.CloudPayloadJsonPositionFields.ALTITUDE.value(), position.getAltitude().doubleValue());
            }
            if (position.getHeading() != null) {
                jsonPosition.add(CloudPayloadJsonFields.CloudPayloadJsonPositionFields.HEADING.value(), position.getHeading().doubleValue());
            }
            if (position.getPrecision() != null) {
                jsonPosition.add(CloudPayloadJsonFields.CloudPayloadJsonPositionFields.PRECISION.value(), position.getPrecision().doubleValue());
            }
            if (position.getSatellites() != null) {
                jsonPosition.add(CloudPayloadJsonFields.CloudPayloadJsonPositionFields.SATELLITES.value(), position.getSatellites().intValue());
            }
            if (position.getSpeed() != null) {
                jsonPosition.add(CloudPayloadJsonFields.CloudPayloadJsonPositionFields.SPEED.value(), position.getSpeed().doubleValue());
            }
            if (position.getTimestamp() != null) {
                jsonPosition.add(CloudPayloadJsonFields.CloudPayloadJsonPositionFields.TIMESTAMP.value(), position.getTimestamp().getTime());
            }
            if (position.getStatus() != null) {
                jsonPosition.add(CloudPayloadJsonFields.CloudPayloadJsonPositionFields.STATUS.value(), position.getStatus().intValue());
            }
            json.add(CloudPayloadJsonFields.POSITION.value(), (JsonValue)jsonPosition);
        }
    }

    private static void encodeTimestamp(KuraPayload kuraPayload, JsonObject json) {
        Date timestamp = kuraPayload.getTimestamp();
        if (timestamp != null) {
            json.add(CloudPayloadJsonFields.SENTON.value(), timestamp.getTime());
        }
    }
}

