/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.cloud.publisher;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.kura.KuraErrorCode;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.cloudconnection.listener.CloudConnectionListener;
import org.eclipse.kura.cloudconnection.listener.CloudDeliveryListener;
import org.eclipse.kura.cloudconnection.message.KuraMessage;
import org.eclipse.kura.cloudconnection.publisher.CloudNotificationPublisher;
import org.eclipse.kura.core.cloud.CloudServiceImpl;
import org.eclipse.kura.core.cloud.CloudServiceOptions;
import org.eclipse.kura.core.message.MessageConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationPublisherImpl
implements CloudNotificationPublisher {
    private static final Logger logger = LoggerFactory.getLogger(NotificationPublisherImpl.class);
    private static final String TOPIC_PATTERN_STRING = "\\$([^\\s/]+)";
    private static final Pattern TOPIC_PATTERN = Pattern.compile("\\$([^\\s/]+)");
    private static final int DFLT_PUB_QOS = 0;
    private static final boolean DFLT_RETAIN = false;
    private static final int DFLT_PRIORITY = 1;
    private static final String MESSAGE_TYPE_KEY = "messageType";
    private static final String REQUESTOR_CLIENT_ID_KEY = "requestorClientId";
    private static final String APP_ID_KEY = "appId";
    private final CloudServiceImpl cloudServiceImpl;

    public NotificationPublisherImpl(CloudServiceImpl cloudServiceImpl) {
        this.cloudServiceImpl = cloudServiceImpl;
    }

    public void registerCloudConnectionListener(CloudConnectionListener cloudConnectionListener) {
    }

    public void unregisterCloudConnectionListener(CloudConnectionListener cloudConnectionListener) {
    }

    public void registerCloudDeliveryListener(CloudDeliveryListener cloudDeliveryListener) {
    }

    public void unregisterCloudDeliveryListener(CloudDeliveryListener cloudDeliveryListener) {
    }

    public String publish(KuraMessage message) throws KuraException {
        if (this.cloudServiceImpl == null) {
            logger.warn("Null cloud connection");
            throw new KuraException(KuraErrorCode.SERVICE_UNAVAILABLE);
        }
        if (message == null) {
            logger.warn("Received null message!");
            throw new IllegalArgumentException();
        }
        String fullTopic = this.encodeFullTopic(message);
        HashMap<String, Object> publishMessageProps = new HashMap<String, Object>();
        publishMessageProps.put(MessageConstants.FULL_TOPIC.name(), fullTopic);
        publishMessageProps.put(MessageConstants.QOS.name(), 0);
        publishMessageProps.put(MessageConstants.RETAIN.name(), false);
        publishMessageProps.put(MessageConstants.PRIORITY.name(), 1);
        publishMessageProps.put(MessageConstants.CONTROL.name(), true);
        KuraMessage publishMessage = new KuraMessage(message.getPayload(), publishMessageProps);
        return this.cloudServiceImpl.publish(publishMessage);
    }

    private String encodeFullTopic(KuraMessage message) {
        String appId = (String)message.getProperties().get(APP_ID_KEY);
        String messageType = (String)message.getProperties().get(MESSAGE_TYPE_KEY);
        String requestorClientId = (String)message.getProperties().get(REQUESTOR_CLIENT_ID_KEY);
        if (Objects.isNull(appId) || Objects.isNull(messageType) || Objects.isNull(requestorClientId)) {
            throw new IllegalArgumentException("Incomplete properties in received message.");
        }
        String fullTopic = this.encodeTopic(appId, messageType, requestorClientId);
        return this.fillAppTopicPlaceholders(fullTopic, message);
    }

    private String encodeTopic(String appId, String messageType, String requestorClientId) {
        CloudServiceOptions options = this.cloudServiceImpl.getCloudServiceOptions();
        String deviceId = CloudServiceOptions.getTopicClientIdToken();
        String topicSeparator = CloudServiceOptions.getTopicSeparator();
        StringBuilder sb = new StringBuilder();
        sb.append(options.getTopicControlPrefix()).append(topicSeparator);
        sb.append(CloudServiceOptions.getTopicAccountToken()).append(topicSeparator).append(requestorClientId).append(topicSeparator).append(appId);
        sb.append(topicSeparator).append("NOTIFY").append(topicSeparator).append(deviceId).append(topicSeparator).append(messageType);
        return sb.toString();
    }

    private String fillAppTopicPlaceholders(String fullTopic, KuraMessage message) {
        Matcher matcher = TOPIC_PATTERN.matcher(fullTopic);
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            Map properties = message.getProperties();
            if (!properties.containsKey(matcher.group(1))) continue;
            String replacement = matcher.group(0);
            Object value = properties.get(matcher.group(1));
            if (replacement == null) continue;
            matcher.appendReplacement(buffer, value.toString());
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }
}

