/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.cloud.subscriber;

import org.eclipse.kura.core.cloud.CloudServiceOptions;
import org.eclipse.kura.core.util.MqttTopicUtil;

public class CloudSubscriptionRecord {
    private final String topic;
    private final int qos;
    private String topicFilter;

    public CloudSubscriptionRecord(String topic, int qos) {
        this.topic = topic;
        this.qos = qos;
    }

    public String getTopic() {
        return this.topic;
    }

    public int getQos() {
        return this.qos;
    }

    public boolean matches(String topic) {
        if (this.topicFilter == null) {
            this.topicFilter = this.topic.replaceAll(CloudServiceOptions.getTopicAccountToken(), "+").replaceAll(CloudServiceOptions.getTopicClientIdToken(), "+");
        }
        return MqttTopicUtil.isMatched((String)this.topicFilter, (String)topic);
    }

    public int hashCode() {
        return this.topic.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CloudSubscriptionRecord)) {
            return false;
        }
        return ((CloudSubscriptionRecord)obj).topic.equals(this.topic);
    }
}

