/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.cloud;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.cloud.ServiceDefinition;
import org.apache.camel.cloud.ServiceHealth;
import org.apache.camel.impl.cloud.DefaultServiceHealth;

public class DefaultServiceDefinition
implements ServiceDefinition {
    private static final ServiceHealth DEFAULT_SERVICE_HEALTH = new DefaultServiceHealth();
    private final String name;
    private final String host;
    private final int port;
    private final Map<String, String> meta;
    private final ServiceHealth health;

    public DefaultServiceDefinition(String name, String host, int port) {
        this.name = name;
        this.host = host;
        this.port = port;
        this.meta = Collections.emptyMap();
        this.health = DEFAULT_SERVICE_HEALTH;
    }

    public DefaultServiceDefinition(String name, String host, int port, ServiceHealth health) {
        this.name = name;
        this.host = host;
        this.port = port;
        this.meta = Collections.emptyMap();
        this.health = health;
    }

    public DefaultServiceDefinition(String name, String host, int port, Map<String, String> meta) {
        this.name = name;
        this.host = host;
        this.port = port;
        this.meta = meta != null ? Collections.unmodifiableMap(new HashMap<String, String>(meta)) : Collections.emptyMap();
        this.health = DEFAULT_SERVICE_HEALTH;
    }

    public DefaultServiceDefinition(String name, String host, int port, Map<String, String> meta, ServiceHealth health) {
        this.name = name;
        this.host = host;
        this.port = port;
        this.meta = meta != null ? Collections.unmodifiableMap(new HashMap<String, String>(meta)) : Collections.emptyMap();
        this.health = health;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public ServiceHealth getHealth() {
        return this.health;
    }

    @Override
    public Map<String, String> getMetadata() {
        return this.meta;
    }

    public String toString() {
        return "DefaultServiceCallService[" + this.name + "@" + this.host + ":" + this.port + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultServiceDefinition that = (DefaultServiceDefinition)o;
        if (this.port != that.port) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return this.host != null ? this.host.equals(that.host) : that.host == null;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.host != null ? this.host.hashCode() : 0);
        result = 31 * result + this.port;
        return result;
    }
}

