/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.rest;

import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.camel.CamelContext;
import org.apache.camel.model.NoOutputDefinition;
import org.apache.camel.model.OptionalIdentifiedDefinition;
import org.apache.camel.model.ProcessorDefinitionHelper;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.ToDefinition;
import org.apache.camel.model.ToDynamicDefinition;
import org.apache.camel.model.rest.DeleteVerbDefinition;
import org.apache.camel.model.rest.GetVerbDefinition;
import org.apache.camel.model.rest.HeadVerbDefinition;
import org.apache.camel.model.rest.OptionsVerbDefinition;
import org.apache.camel.model.rest.PatchVerbDefinition;
import org.apache.camel.model.rest.PostVerbDefinition;
import org.apache.camel.model.rest.PutVerbDefinition;
import org.apache.camel.model.rest.RestBindingDefinition;
import org.apache.camel.model.rest.RestBindingMode;
import org.apache.camel.model.rest.RestOperationParamDefinition;
import org.apache.camel.model.rest.RestOperationResponseMsgDefinition;
import org.apache.camel.model.rest.RestParamType;
import org.apache.camel.model.rest.VerbDefinition;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.util.CamelContextHelper;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;

@Metadata(label="rest")
@XmlRootElement(name="rest")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class RestDefinition
extends OptionalIdentifiedDefinition<RestDefinition> {
    @XmlAttribute
    private String path;
    @XmlAttribute
    private String tag;
    @XmlAttribute
    private String consumes;
    @XmlAttribute
    private String produces;
    @XmlAttribute
    @Metadata(defaultValue="auto")
    private RestBindingMode bindingMode;
    @XmlAttribute
    private Boolean skipBindingOnErrorCode;
    @XmlAttribute
    private Boolean enableCORS;
    @XmlAttribute
    private Boolean apiDocs;
    @XmlElementRef
    private List<VerbDefinition> verbs = new ArrayList<VerbDefinition>();

    @Override
    public String getLabel() {
        return "rest";
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public String getConsumes() {
        return this.consumes;
    }

    public void setConsumes(String consumes) {
        this.consumes = consumes;
    }

    public String getProduces() {
        return this.produces;
    }

    public void setProduces(String produces) {
        this.produces = produces;
    }

    public RestBindingMode getBindingMode() {
        return this.bindingMode;
    }

    public void setBindingMode(RestBindingMode bindingMode) {
        this.bindingMode = bindingMode;
    }

    public List<VerbDefinition> getVerbs() {
        return this.verbs;
    }

    public void setVerbs(List<VerbDefinition> verbs) {
        this.verbs = verbs;
    }

    public Boolean getSkipBindingOnErrorCode() {
        return this.skipBindingOnErrorCode;
    }

    public void setSkipBindingOnErrorCode(Boolean skipBindingOnErrorCode) {
        this.skipBindingOnErrorCode = skipBindingOnErrorCode;
    }

    public Boolean getEnableCORS() {
        return this.enableCORS;
    }

    public void setEnableCORS(Boolean enableCORS) {
        this.enableCORS = enableCORS;
    }

    public Boolean getApiDocs() {
        return this.apiDocs;
    }

    public void setApiDocs(Boolean apiDocs) {
        this.apiDocs = apiDocs;
    }

    public RestDefinition path(String path) {
        this.setPath(path);
        return this;
    }

    public RestDefinition tag(String tag) {
        this.setTag(tag);
        return this;
    }

    public RestDefinition get() {
        return this.addVerb("get", null);
    }

    public RestDefinition get(String uri) {
        return this.addVerb("get", uri);
    }

    public RestDefinition post() {
        return this.addVerb("post", null);
    }

    public RestDefinition post(String uri) {
        return this.addVerb("post", uri);
    }

    public RestDefinition put() {
        return this.addVerb("put", null);
    }

    public RestDefinition put(String uri) {
        return this.addVerb("put", uri);
    }

    public RestDefinition patch() {
        return this.addVerb("patch", null);
    }

    public RestDefinition patch(String uri) {
        return this.addVerb("patch", uri);
    }

    public RestDefinition delete() {
        return this.addVerb("delete", null);
    }

    public RestDefinition delete(String uri) {
        return this.addVerb("delete", uri);
    }

    public RestDefinition head() {
        return this.addVerb("head", null);
    }

    public RestDefinition head(String uri) {
        return this.addVerb("head", uri);
    }

    @Deprecated
    public RestDefinition options() {
        return this.addVerb("options", null);
    }

    @Deprecated
    public RestDefinition options(String uri) {
        return this.addVerb("options", uri);
    }

    public RestDefinition verb(String verb) {
        return this.addVerb(verb, null);
    }

    public RestDefinition verb(String verb, String uri) {
        return this.addVerb(verb, uri);
    }

    @Override
    public RestDefinition id(String id) {
        if (this.getVerbs().isEmpty()) {
            super.id(id);
        } else {
            VerbDefinition verb = this.getVerbs().get(this.getVerbs().size() - 1);
            verb.id(id);
        }
        return this;
    }

    @Override
    public RestDefinition description(String text) {
        if (this.getVerbs().isEmpty()) {
            super.description(text);
        } else {
            VerbDefinition verb = this.getVerbs().get(this.getVerbs().size() - 1);
            verb.description(text);
        }
        return this;
    }

    @Override
    public RestDefinition description(String id, String text, String lang) {
        if (this.getVerbs().isEmpty()) {
            super.description(id, text, lang);
        } else {
            VerbDefinition verb = this.getVerbs().get(this.getVerbs().size() - 1);
            verb.description(id, text, lang);
        }
        return this;
    }

    public RestDefinition consumes(String mediaType) {
        if (this.getVerbs().isEmpty()) {
            this.consumes = mediaType;
        } else {
            VerbDefinition verb = this.getVerbs().get(this.getVerbs().size() - 1);
            verb.setConsumes(mediaType);
        }
        return this;
    }

    public RestOperationParamDefinition param() {
        if (this.getVerbs().isEmpty()) {
            throw new IllegalArgumentException("Must add verb first, such as get/post/delete");
        }
        VerbDefinition verb = this.getVerbs().get(this.getVerbs().size() - 1);
        return this.param(verb);
    }

    public RestDefinition param(RestOperationParamDefinition param) {
        if (this.getVerbs().isEmpty()) {
            throw new IllegalArgumentException("Must add verb first, such as get/post/delete");
        }
        VerbDefinition verb = this.getVerbs().get(this.getVerbs().size() - 1);
        verb.getParams().add(param);
        return this;
    }

    public RestDefinition params(List<RestOperationParamDefinition> params) {
        if (this.getVerbs().isEmpty()) {
            throw new IllegalArgumentException("Must add verb first, such as get/post/delete");
        }
        VerbDefinition verb = this.getVerbs().get(this.getVerbs().size() - 1);
        verb.getParams().addAll(params);
        return this;
    }

    public RestOperationParamDefinition param(VerbDefinition verb) {
        return new RestOperationParamDefinition(verb);
    }

    public RestDefinition responseMessage(RestOperationResponseMsgDefinition msg) {
        if (this.getVerbs().isEmpty()) {
            throw new IllegalArgumentException("Must add verb first, such as get/post/delete");
        }
        VerbDefinition verb = this.getVerbs().get(this.getVerbs().size() - 1);
        verb.getResponseMsgs().add(msg);
        return this;
    }

    public RestOperationResponseMsgDefinition responseMessage() {
        if (this.getVerbs().isEmpty()) {
            throw new IllegalArgumentException("Must add verb first, such as get/post/delete");
        }
        VerbDefinition verb = this.getVerbs().get(this.getVerbs().size() - 1);
        return this.responseMessage(verb);
    }

    public RestOperationResponseMsgDefinition responseMessage(VerbDefinition verb) {
        return new RestOperationResponseMsgDefinition(verb);
    }

    public RestDefinition responseMessages(List<RestOperationResponseMsgDefinition> msgs) {
        if (this.getVerbs().isEmpty()) {
            throw new IllegalArgumentException("Must add verb first, such as get/post/delete");
        }
        VerbDefinition verb = this.getVerbs().get(this.getVerbs().size() - 1);
        verb.getResponseMsgs().addAll(msgs);
        return this;
    }

    public RestDefinition produces(String mediaType) {
        if (this.getVerbs().isEmpty()) {
            this.produces = mediaType;
        } else {
            VerbDefinition verb = this.getVerbs().get(this.getVerbs().size() - 1);
            verb.setProduces(mediaType);
        }
        return this;
    }

    public RestDefinition type(Class<?> classType) {
        if (this.getVerbs().isEmpty()) {
            throw new IllegalArgumentException("Must add verb first, such as get/post/delete");
        }
        VerbDefinition verb = this.getVerbs().get(this.getVerbs().size() - 1);
        verb.setType(classType.getCanonicalName());
        return this;
    }

    @Deprecated
    public RestDefinition typeList(Class<?> classType) {
        if (this.getVerbs().isEmpty()) {
            throw new IllegalArgumentException("Must add verb first, such as get/post/delete");
        }
        VerbDefinition verb = this.getVerbs().get(this.getVerbs().size() - 1);
        verb.setType(classType.getCanonicalName() + "[]");
        return this;
    }

    public RestDefinition outType(Class<?> classType) {
        if (this.getVerbs().isEmpty()) {
            throw new IllegalArgumentException("Must add verb first, such as get/post/delete");
        }
        VerbDefinition verb = this.getVerbs().get(this.getVerbs().size() - 1);
        verb.setOutType(classType.getCanonicalName());
        return this;
    }

    @Deprecated
    public RestDefinition outTypeList(Class<?> classType) {
        if (this.getVerbs().isEmpty()) {
            throw new IllegalArgumentException("Must add verb first, such as get/post/delete");
        }
        VerbDefinition verb = this.getVerbs().get(this.getVerbs().size() - 1);
        verb.setOutType(classType.getCanonicalName() + "[]");
        return this;
    }

    public RestDefinition bindingMode(RestBindingMode mode) {
        if (this.getVerbs().isEmpty()) {
            this.bindingMode = mode;
        } else {
            VerbDefinition verb = this.getVerbs().get(this.getVerbs().size() - 1);
            verb.setBindingMode(mode);
        }
        return this;
    }

    public RestDefinition skipBindingOnErrorCode(boolean skipBindingOnErrorCode) {
        if (this.getVerbs().isEmpty()) {
            this.skipBindingOnErrorCode = skipBindingOnErrorCode;
        } else {
            VerbDefinition verb = this.getVerbs().get(this.getVerbs().size() - 1);
            verb.setSkipBindingOnErrorCode(skipBindingOnErrorCode);
        }
        return this;
    }

    public RestDefinition enableCORS(boolean enableCORS) {
        if (this.getVerbs().isEmpty()) {
            this.enableCORS = enableCORS;
        } else {
            VerbDefinition verb = this.getVerbs().get(this.getVerbs().size() - 1);
            verb.setEnableCORS(enableCORS);
        }
        return this;
    }

    public RestDefinition apiDocs(Boolean apiDocs) {
        if (this.getVerbs().isEmpty()) {
            this.apiDocs = apiDocs;
        } else {
            VerbDefinition verb = this.getVerbs().get(this.getVerbs().size() - 1);
            verb.setApiDocs(apiDocs);
        }
        return this;
    }

    public RestDefinition to(String uri) {
        if (this.getVerbs().isEmpty()) {
            throw new IllegalArgumentException("Must add verb first, such as get/post/delete");
        }
        ToDefinition to = new ToDefinition(uri);
        VerbDefinition verb = this.getVerbs().get(this.getVerbs().size() - 1);
        verb.setTo(to);
        return this;
    }

    public RestDefinition toD(String uri) {
        if (this.getVerbs().isEmpty()) {
            throw new IllegalArgumentException("Must add verb first, such as get/post/delete");
        }
        ToDynamicDefinition to = new ToDynamicDefinition(uri);
        VerbDefinition verb = this.getVerbs().get(this.getVerbs().size() - 1);
        verb.setToD(to);
        return this;
    }

    public RouteDefinition route() {
        if (this.getVerbs().isEmpty()) {
            throw new IllegalArgumentException("Must add verb first, such as get/post/delete");
        }
        RouteDefinition route = new RouteDefinition();
        route.setRestDefinition(this);
        VerbDefinition verb = this.getVerbs().get(this.getVerbs().size() - 1);
        verb.setRoute(route);
        return route;
    }

    private RestDefinition addVerb(String verb, String uri) {
        VerbDefinition answer;
        if ("get".equals(verb)) {
            answer = new GetVerbDefinition();
        } else if ("post".equals(verb)) {
            answer = new PostVerbDefinition();
        } else if ("delete".equals(verb)) {
            answer = new DeleteVerbDefinition();
        } else if ("head".equals(verb)) {
            answer = new HeadVerbDefinition();
        } else if ("put".equals(verb)) {
            answer = new PutVerbDefinition();
        } else if ("patch".equals(verb)) {
            answer = new PatchVerbDefinition();
        } else if ("options".equals(verb)) {
            answer = new OptionsVerbDefinition();
        } else {
            answer = new VerbDefinition();
            answer.setMethod(verb);
        }
        this.getVerbs().add(answer);
        answer.setRest(this);
        answer.setUri(uri);
        return this;
    }

    public List<RouteDefinition> asRouteDefinition(CamelContext camelContext) {
        ObjectHelper.notNull(camelContext, "CamelContext");
        this.validateUniquePaths();
        ArrayList<RouteDefinition> answer = new ArrayList<RouteDefinition>();
        if (camelContext.getRestConfigurations().isEmpty()) {
            RestConfiguration conf = CamelContextHelper.lookup(camelContext, "rest-configuration", RestConfiguration.class);
            if (conf == null) {
                conf = CamelContextHelper.findByType(camelContext, RestConfiguration.class);
            }
            if (conf != null) {
                camelContext.setRestConfiguration(conf);
            } else {
                camelContext.setRestConfiguration(new RestConfiguration());
            }
        }
        for (RestConfiguration config : camelContext.getRestConfigurations()) {
            this.addRouteDefinition(camelContext, answer, config.getComponent());
        }
        return answer;
    }

    public List<RouteDefinition> asRouteDefinition(CamelContext camelContext, RestConfiguration restConfiguration) {
        ObjectHelper.notNull(camelContext, "CamelContext");
        ObjectHelper.notNull(restConfiguration, "RestConfiguration");
        this.validateUniquePaths();
        ArrayList<RouteDefinition> answer = new ArrayList<RouteDefinition>();
        this.addRouteDefinition(camelContext, answer, restConfiguration.getComponent());
        return answer;
    }

    protected void validateUniquePaths() {
        HashSet<String> paths = new HashSet<String>();
        for (VerbDefinition verb : this.verbs) {
            String path = verb.asVerb();
            if (verb.getUri() != null) {
                path = path + ":" + verb.getUri();
            }
            if (paths.add(path)) continue;
            throw new IllegalArgumentException("Duplicate verb detected in rest-dsl: " + path);
        }
    }

    public static RouteDefinition asRouteApiDefinition(CamelContext camelContext, RestConfiguration configuration) {
        RouteDefinition answer = new RouteDefinition();
        String from = "rest-api:" + configuration.getApiContextPath();
        HashMap<String, Object> options = new HashMap<String, Object>();
        String routeId = configuration.getApiContextRouteId();
        if (routeId == null) {
            routeId = answer.idOrCreate(camelContext.getNodeIdFactory());
        }
        options.put("routeId", routeId);
        if (configuration.getComponent() != null && !configuration.getComponent().isEmpty()) {
            options.put("componentName", configuration.getComponent());
        }
        if (configuration.getApiContextIdPattern() != null) {
            options.put("contextIdPattern", configuration.getApiContextIdPattern());
        }
        if (!options.isEmpty()) {
            String query;
            try {
                query = URISupport.createQueryString(options);
            }
            catch (URISyntaxException e) {
                throw ObjectHelper.wrapRuntimeCamelException(e);
            }
            from = from + "?" + query;
        }
        String to = from;
        answer.fromRest(from);
        answer.id(routeId);
        answer.to(to);
        return answer;
    }

    /*
     * WARNING - void declaration
     */
    private void addRouteDefinition(CamelContext camelContext, List<RouteDefinition> answer, String component) {
        for (VerbDefinition verb : this.getVerbs()) {
            void var8_9;
            String description;
            String id;
            String outType;
            RouteDefinition route = verb.getRoute();
            if (route == null) {
                route = new RouteDefinition();
                NoOutputDefinition def = verb.getTo() != null ? verb.getTo() : verb.getToD();
                route.getOutputs().add(def);
            }
            try {
                ProcessorDefinitionHelper.resolvePropertyPlaceholders(camelContext, (Object)verb);
                for (RestOperationParamDefinition restOperationParamDefinition : verb.getParams()) {
                    ProcessorDefinitionHelper.resolvePropertyPlaceholders(camelContext, (Object)restOperationParamDefinition);
                }
            }
            catch (Exception e) {
                throw ObjectHelper.wrapRuntimeCamelException(e);
            }
            RestBindingDefinition binding = new RestBindingDefinition();
            binding.setComponent(component);
            binding.setType(verb.getType());
            binding.setOutType(verb.getOutType());
            if (verb.getConsumes() != null) {
                binding.setConsumes(verb.getConsumes());
            } else {
                binding.setConsumes(this.getConsumes());
            }
            if (verb.getProduces() != null) {
                binding.setProduces(verb.getProduces());
            } else {
                binding.setProduces(this.getProduces());
            }
            if (verb.getBindingMode() != null) {
                binding.setBindingMode(verb.getBindingMode());
            } else {
                binding.setBindingMode(this.getBindingMode());
            }
            if (verb.getSkipBindingOnErrorCode() != null) {
                binding.setSkipBindingOnErrorCode(verb.getSkipBindingOnErrorCode());
            } else {
                binding.setSkipBindingOnErrorCode(this.getSkipBindingOnErrorCode());
            }
            if (verb.getEnableCORS() != null) {
                binding.setEnableCORS(verb.getEnableCORS());
            } else {
                binding.setEnableCORS(this.getEnableCORS());
            }
            for (RestOperationParamDefinition param3 : verb.getParams()) {
                if (RestParamType.query != param3.getType() || !ObjectHelper.isNotEmpty(param3.getDefaultValue())) continue;
                binding.addDefaultValue(param3.getName(), param3.getDefaultValue());
            }
            route.setRestBindingDefinition(binding);
            String string = "rest:" + verb.asVerb() + ":" + this.buildUri(verb);
            HashMap<String, Object> options = new HashMap<String, Object>();
            if (verb.getConsumes() != null) {
                options.put("consumes", verb.getConsumes());
            } else if (this.getConsumes() != null) {
                options.put("consumes", this.getConsumes());
            }
            if (verb.getProduces() != null) {
                options.put("produces", verb.getProduces());
            } else if (this.getProduces() != null) {
                options.put("produces", this.getProduces());
            }
            String inType = binding.getType();
            if (inType != null) {
                options.put("inType", inType);
            }
            if ((outType = binding.getOutType()) != null) {
                options.put("outType", outType);
            }
            if (!route.hasCustomIdAssigned() && (id = verb.getId()) != null) {
                route.setId(id);
            }
            String routeId = verb.idOrCreate(camelContext.getNodeIdFactory());
            if (!verb.getUsedForGeneratingNodeId().booleanValue()) {
                routeId = route.idOrCreate(camelContext.getNodeIdFactory());
            }
            verb.setRouteId(routeId);
            options.put("routeId", routeId);
            if (component != null && !component.isEmpty()) {
                options.put("componentName", component);
            }
            String string2 = description = verb.getTo() != null ? verb.getTo().getDescriptionText() : route.getDescriptionText();
            if (description == null) {
                description = verb.getDescriptionText();
            }
            if (description == null) {
                description = this.getDescriptionText();
            }
            if (description != null) {
                options.put("description", description);
            }
            if (!options.isEmpty()) {
                String query;
                try {
                    query = URISupport.createQueryString(options);
                }
                catch (URISyntaxException e) {
                    throw ObjectHelper.wrapRuntimeCamelException(e);
                }
                String string3 = string + "?" + query;
            }
            String path = this.getPath();
            String s1 = FileUtil.stripTrailingSeparator(path);
            String s2 = FileUtil.stripLeadingSeparator(verb.getUri());
            String allPath = s1 != null && s2 != null ? s1 + "/" + s2 : (path != null ? path : verb.getUri());
            if (allPath != null) {
                String[] arr;
                for (String a : arr = allPath.split("\\/")) {
                    try {
                        a = camelContext.resolvePropertyPlaceholders(a);
                    }
                    catch (Exception e) {
                        throw ObjectHelper.wrapRuntimeCamelException(e);
                    }
                    if (!a.startsWith("{") || !a.endsWith("}")) continue;
                    String key = a.substring(1, a.length() - 1);
                    boolean found = false;
                    for (RestOperationParamDefinition param4 : verb.getParams()) {
                        String name = param4.getName();
                        ObjectHelper.notEmpty(name, "parameter name");
                        try {
                            name = camelContext.resolvePropertyPlaceholders(name);
                        }
                        catch (Exception e) {
                            throw ObjectHelper.wrapRuntimeCamelException(e);
                        }
                        if (!name.equalsIgnoreCase(key)) continue;
                        param4.type(RestParamType.path);
                        found = true;
                        break;
                    }
                    if (found) continue;
                    this.param(verb).name(key).type(RestParamType.path).endParam();
                }
            }
            if (verb.getType() != null) {
                RestOperationParamDefinition param5;
                String bodyType = verb.getType();
                if (bodyType.endsWith("[]")) {
                    bodyType = "List[" + bodyType.substring(0, bodyType.length() - 2) + "]";
                }
                if ((param5 = this.findParam(verb, RestParamType.body.name())) == null) {
                    this.param(verb).name(RestParamType.body.name()).type(RestParamType.body).dataType(bodyType).endParam();
                } else {
                    param5.type(RestParamType.body).dataType(bodyType);
                }
            }
            route.fromRest((String)var8_9);
            route.routeId(routeId);
            route.setRestDefinition(this);
            answer.add(route);
        }
    }

    private String buildUri(VerbDefinition verb) {
        if (this.path != null && verb.getUri() != null) {
            return this.path + ":" + verb.getUri();
        }
        if (this.path != null) {
            return this.path;
        }
        if (verb.getUri() != null) {
            return verb.getUri();
        }
        return "";
    }

    private RestOperationParamDefinition findParam(VerbDefinition verb, String name) {
        for (RestOperationParamDefinition param : verb.getParams()) {
            if (!name.equals(param.getName())) continue;
            return param;
        }
        return null;
    }
}

