/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.saga;

import java.util.concurrent.CompletableFuture;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.model.SagaCompletionMode;
import org.apache.camel.processor.DelegateAsyncProcessor;
import org.apache.camel.saga.CamelSagaCoordinator;
import org.apache.camel.saga.CamelSagaService;
import org.apache.camel.saga.CamelSagaStep;
import org.apache.camel.util.ObjectHelper;

public abstract class SagaProcessor
extends DelegateAsyncProcessor {
    protected CamelContext camelContext;
    protected CamelSagaService sagaService;
    protected CamelSagaStep step;
    protected SagaCompletionMode completionMode;

    public SagaProcessor(CamelContext camelContext, Processor childProcessor, CamelSagaService sagaService, SagaCompletionMode completionMode, CamelSagaStep step) {
        super(ObjectHelper.notNull(childProcessor, "childProcessor"));
        this.camelContext = ObjectHelper.notNull(camelContext, "camelContext");
        this.sagaService = ObjectHelper.notNull(sagaService, "sagaService");
        this.completionMode = ObjectHelper.notNull(completionMode, "completionMode");
        this.step = ObjectHelper.notNull(step, "step");
    }

    protected CompletableFuture<CamelSagaCoordinator> getCurrentSagaCoordinator(Exchange exchange) {
        String currentSaga = exchange.getIn().getHeader("Long-Running-Action", String.class);
        if (currentSaga != null) {
            return this.sagaService.getSaga(currentSaga);
        }
        return CompletableFuture.completedFuture(null);
    }

    protected void setCurrentSagaCoordinator(Exchange exchange, CamelSagaCoordinator coordinator) {
        if (coordinator != null) {
            exchange.getIn().setHeader("Long-Running-Action", coordinator.getId());
        } else {
            exchange.getIn().removeHeader("Long-Running-Action");
        }
    }

    protected void handleSagaCompletion(Exchange exchange, CamelSagaCoordinator coordinator, CamelSagaCoordinator previousCoordinator, AsyncCallback callback) {
        if (this.completionMode == SagaCompletionMode.AUTO) {
            if (exchange.getException() != null) {
                coordinator.compensate().whenComplete((done, ex) -> this.ifNotException((Throwable)ex, exchange, callback, () -> {
                    this.setCurrentSagaCoordinator(exchange, previousCoordinator);
                    callback.done(false);
                }));
            } else {
                coordinator.complete().whenComplete((done, ex) -> this.ifNotException((Throwable)ex, exchange, callback, () -> {
                    this.setCurrentSagaCoordinator(exchange, previousCoordinator);
                    callback.done(false);
                }));
            }
        } else if (this.completionMode == SagaCompletionMode.MANUAL) {
            callback.done(false);
        } else {
            throw new IllegalStateException("Unsupported completion mode: " + (Object)((Object)this.completionMode));
        }
    }

    public CamelSagaService getSagaService() {
        return this.sagaService;
    }

    @Override
    public String toString() {
        return "saga";
    }

    protected void ifNotException(Throwable ex, Exchange exchange, AsyncCallback callback, Runnable code) {
        if (ex != null) {
            exchange.setException(ex);
            callback.done(false);
        } else {
            code.run();
        }
    }
}

