/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.client.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import org.eclipse.kura.web.client.configuration.HasConfiguration;
import org.eclipse.kura.web.client.ui.AbstractServicesUi;
import org.eclipse.kura.web.shared.model.GwtConfigComponent;
import org.eclipse.kura.web.shared.model.GwtConfigParameter;
import org.gwtbootstrap3.client.ui.FieldSet;
import org.gwtbootstrap3.client.ui.FormGroup;

public class ConfigurableComponentUi
extends AbstractServicesUi
implements HasConfiguration {
    private static GenericWireComponentUiUiBinder uiBinder = (GenericWireComponentUiUiBinder)GWT.create(GenericWireComponentUiUiBinder.class);
    private boolean dirty;
    private HasConfiguration.Listener listener;
    @UiField
    FieldSet fields;
    @UiField
    Label componentDescription;

    public ConfigurableComponentUi(GwtConfigComponent originalConfig) {
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
        this.setConfiguration(originalConfig);
    }

    public void setConfiguration(GwtConfigComponent originalConfig) {
        String description = originalConfig.getComponentDescription();
        this.componentDescription.setText(description != null ? description : "");
        this.restoreConfiguration(originalConfig);
        this.fields.clear();
        this.renderForm();
        this.setDirty(false);
    }

    @Override
    public void setDirty(boolean flag) {
        boolean isDirtyStateChanged = flag ^ this.dirty;
        this.dirty = flag;
        if (this.listener != null) {
            if (isDirtyStateChanged) {
                this.listener.onDirtyStateChanged(this);
            }
            if (this.isValid()) {
                this.listener.onConfigurationChanged(this);
            }
        }
    }

    @Override
    protected void reset() {
    }

    @Override
    public void renderForm() {
        this.fields.clear();
        for (GwtConfigParameter param : this.configurableComponent.getParameters()) {
            if (param.getCardinality() == 0 || param.getCardinality() == 1 || param.getCardinality() == -1) {
                FormGroup formGroup = new FormGroup();
                this.renderConfigParameter(param, true, formGroup);
                continue;
            }
            this.renderMultiFieldConfigParameter(param);
        }
    }

    @Override
    protected void renderTextField(GwtConfigParameter param, boolean isFirstInstance, FormGroup formGroup) {
        super.renderTextField(param, isFirstInstance, formGroup);
        this.fields.add((Widget)formGroup);
    }

    @Override
    protected void renderPasswordField(GwtConfigParameter param, boolean isFirstInstance, FormGroup formGroup) {
        super.renderPasswordField(param, isFirstInstance, formGroup);
        this.fields.add((Widget)formGroup);
    }

    @Override
    protected void renderBooleanField(GwtConfigParameter param, boolean isFirstInstance, FormGroup formGroup) {
        super.renderBooleanField(param, isFirstInstance, formGroup);
        this.fields.add((Widget)formGroup);
    }

    @Override
    protected void renderChoiceField(GwtConfigParameter param, boolean isFirstInstance, FormGroup formGroup) {
        super.renderChoiceField(param, isFirstInstance, formGroup);
        this.fields.add((Widget)formGroup);
    }

    @Override
    public void setListener(HasConfiguration.Listener listener) {
        this.listener = listener;
        listener.onConfigurationChanged(this);
    }

    protected GwtConfigComponent getUpdatedConfiguration() {
        for (Widget w : this.fields) {
            if (!(w instanceof FormGroup)) continue;
            FormGroup fg = (FormGroup)w;
            this.fillUpdatedConfiguration(fg);
        }
        return this.configurableComponent;
    }

    @Override
    public GwtConfigComponent getConfiguration() {
        GwtConfigComponent result = this.getUpdatedConfiguration();
        result.getProperties().putAll(this.configurableComponent.getProperties());
        return result;
    }

    @Override
    public void clearDirtyState() {
        this.dirty = false;
    }

    @Override
    public boolean isValid() {
        return super.isValid();
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void markAsDirty() {
        this.setDirty(true);
    }

    static interface GenericWireComponentUiUiBinder
    extends UiBinder<Widget, ConfigurableComponentUi> {
    }
}

