/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.client.ui.Device;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.Header;
import com.google.gwt.user.cellview.client.TextColumn;
import com.google.gwt.user.cellview.client.TextHeader;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.ListDataProvider;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.google.gwt.view.client.SingleSelectionModel;
import java.util.ArrayList;
import org.eclipse.kura.web.client.messages.Messages;
import org.eclipse.kura.web.client.messages.ValidationMessages;
import org.eclipse.kura.web.client.ui.EntryClassUi;
import org.eclipse.kura.web.client.ui.Tab;
import org.eclipse.kura.web.client.util.EventService;
import org.eclipse.kura.web.client.util.FailureHandler;
import org.eclipse.kura.web.shared.ForwardedEventTopic;
import org.eclipse.kura.web.shared.model.GwtEventInfo;
import org.eclipse.kura.web.shared.model.GwtGroupedNVPair;
import org.eclipse.kura.web.shared.model.GwtXSRFToken;
import org.eclipse.kura.web.shared.service.GwtDeviceService;
import org.eclipse.kura.web.shared.service.GwtDeviceServiceAsync;
import org.eclipse.kura.web.shared.service.GwtSecurityTokenService;
import org.eclipse.kura.web.shared.service.GwtSecurityTokenServiceAsync;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.gwt.CellTable;

public class BundlesTabUi
extends Composite
implements Tab {
    private static BundlesTabUiUiBinder uiBinder = (BundlesTabUiUiBinder)GWT.create(BundlesTabUiUiBinder.class);
    private static final Messages MSGS = (Messages)GWT.create(Messages.class);
    private static final ValidationMessages msgs = (ValidationMessages)GWT.create(ValidationMessages.class);
    private static final String ROW_HEADER_STYLE = "rowHeader";
    private static final String STATUS_TABLE_ROW_STYLE = "status-table-row";
    private final GwtSecurityTokenServiceAsync gwtXSRFService = (GwtSecurityTokenServiceAsync)GWT.create(GwtSecurityTokenService.class);
    private final GwtDeviceServiceAsync gwtDeviceService = (GwtDeviceServiceAsync)GWT.create(GwtDeviceService.class);
    private boolean isRequestRunning = false;
    @UiField
    Button bundlesRefresh;
    @UiField
    Button bundleStart;
    @UiField
    Button bundleStop;
    @UiField
    CellTable<GwtGroupedNVPair> bundlesGrid = new CellTable();
    private final ListDataProvider<GwtGroupedNVPair> bundlesDataProvider = new ListDataProvider();
    private final SingleSelectionModel<GwtGroupedNVPair> selectionModel = new SingleSelectionModel();
    private final GwtDeviceServiceAsync deviceService = (GwtDeviceServiceAsync)GWT.create(GwtDeviceService.class);
    private final GwtSecurityTokenServiceAsync securityTokenService = (GwtSecurityTokenServiceAsync)GWT.create(GwtSecurityTokenService.class);

    public BundlesTabUi() {
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
        this.loadBundlesTable(this.bundlesGrid, this.bundlesDataProvider);
        this.bundlesRefresh.setText("Refresh");
        this.bundleStart.setText("Start Bundle");
        this.bundleStop.setText("Stop Bundle");
        this.updateButtons();
        this.bundlesGrid.setSelectionModel(this.selectionModel);
        this.selectionModel.addSelectionChangeHandler(new SelectionChangeEvent.Handler(){

            public void onSelectionChange(SelectionChangeEvent event) {
                BundlesTabUi.this.updateButtons();
            }
        });
        this.bundlesRefresh.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                BundlesTabUi.this.refresh();
            }
        });
        this.bundleStart.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                BundlesTabUi.this.startSelectedBundle();
            }
        });
        this.bundleStop.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                BundlesTabUi.this.stopSelectedBundle();
            }
        });
        EventService.Handler onBundleUpdatedHandler = new EventService.Handler(){

            @Override
            public void handleEvent(GwtEventInfo eventInfo) {
                if (BundlesTabUi.this.isVisible() && BundlesTabUi.this.isAttached()) {
                    BundlesTabUi.this.refresh();
                }
            }
        };
        EventService.subscribe(ForwardedEventTopic.BUNDLE_INSTALLED, onBundleUpdatedHandler);
        EventService.subscribe(ForwardedEventTopic.BUNDLE_RESOLVED, onBundleUpdatedHandler);
        EventService.subscribe(ForwardedEventTopic.BUNDLE_STARTED, onBundleUpdatedHandler);
        EventService.subscribe(ForwardedEventTopic.BUNDLE_STOPPED, onBundleUpdatedHandler);
        EventService.subscribe(ForwardedEventTopic.BUNDLE_UNINSTALLED, onBundleUpdatedHandler);
        EventService.subscribe(ForwardedEventTopic.BUNDLE_UNRESOLVED, onBundleUpdatedHandler);
    }

    private void updateButtons() {
        String status;
        GwtGroupedNVPair selected = (GwtGroupedNVPair)this.selectionModel.getSelectedObject();
        this.bundleStart.setEnabled(false);
        this.bundleStop.setEnabled(false);
        if (selected == null || (status = selected.getStatus()) == null) {
            return;
        }
        boolean isActive = "bndActive".equals(status);
        this.bundleStart.setEnabled(!isActive);
        this.bundleStop.setEnabled(isActive);
    }

    private void startSelectedBundle() {
        EntryClassUi.showWaitModal();
        this.securityTokenService.generateSecurityToken(new AsyncCallback<GwtXSRFToken>(){

            public void onSuccess(GwtXSRFToken token) {
                BundlesTabUi.this.deviceService.startBundle(token, ((GwtGroupedNVPair)BundlesTabUi.this.selectionModel.getSelectedObject()).getId(), new AsyncCallback<Void>(){

                    public void onFailure(Throwable caught) {
                        EntryClassUi.hideWaitModal();
                        FailureHandler.handle(caught);
                    }

                    public void onSuccess(Void result) {
                        EntryClassUi.hideWaitModal();
                    }
                });
            }

            public void onFailure(Throwable caught) {
                EntryClassUi.hideWaitModal();
                FailureHandler.handle(caught);
            }
        });
    }

    private void stopSelectedBundle() {
        EntryClassUi.showWaitModal();
        this.securityTokenService.generateSecurityToken(new AsyncCallback<GwtXSRFToken>(){

            public void onFailure(Throwable caught) {
                EntryClassUi.hideWaitModal();
                FailureHandler.handle(caught);
            }

            public void onSuccess(GwtXSRFToken token) {
                BundlesTabUi.this.deviceService.stopBundle(token, ((GwtGroupedNVPair)BundlesTabUi.this.selectionModel.getSelectedObject()).getId(), new AsyncCallback<Void>(){

                    public void onFailure(Throwable caught) {
                        EntryClassUi.hideWaitModal();
                        FailureHandler.handle(caught);
                    }

                    public void onSuccess(Void result) {
                        EntryClassUi.hideWaitModal();
                    }
                });
            }
        });
    }

    private void loadBundlesTable(CellTable<GwtGroupedNVPair> bundlesGrid2, ListDataProvider<GwtGroupedNVPair> dataProvider) {
        TextColumn<GwtGroupedNVPair> col1 = new TextColumn<GwtGroupedNVPair>(){

            public String getValue(GwtGroupedNVPair object) {
                return object.getId();
            }
        };
        col1.setCellStyleNames(STATUS_TABLE_ROW_STYLE);
        TextHeader id = new TextHeader(MSGS.deviceBndId());
        id.setHeaderStyleNames(ROW_HEADER_STYLE);
        bundlesGrid2.addColumn((Column)col1, (Header)id);
        TextColumn<GwtGroupedNVPair> col2 = new TextColumn<GwtGroupedNVPair>(){

            public String getValue(GwtGroupedNVPair object) {
                return object.getName();
            }
        };
        col2.setCellStyleNames(STATUS_TABLE_ROW_STYLE);
        TextHeader name = new TextHeader(MSGS.deviceBndName());
        name.setHeaderStyleNames(ROW_HEADER_STYLE);
        bundlesGrid2.addColumn((Column)col2, (Header)name);
        TextColumn<GwtGroupedNVPair> col3 = new TextColumn<GwtGroupedNVPair>(){

            public String getValue(GwtGroupedNVPair object) {
                return msgs.getString(object.getStatus());
            }
        };
        col3.setCellStyleNames(STATUS_TABLE_ROW_STYLE);
        TextHeader state = new TextHeader(MSGS.deviceBndState());
        state.setHeaderStyleNames(ROW_HEADER_STYLE);
        bundlesGrid2.addColumn((Column)col3, (Header)state);
        TextColumn<GwtGroupedNVPair> col4 = new TextColumn<GwtGroupedNVPair>(){

            public String getValue(GwtGroupedNVPair object) {
                return object.getVersion();
            }
        };
        col4.setCellStyleNames(STATUS_TABLE_ROW_STYLE);
        TextHeader version = new TextHeader(MSGS.deviceBndVersion());
        version.setHeaderStyleNames(ROW_HEADER_STYLE);
        bundlesGrid2.addColumn((Column)col4, (Header)version);
        dataProvider.addDataDisplay(bundlesGrid2);
    }

    @Override
    public void setDirty(boolean flag) {
    }

    @Override
    public boolean isDirty() {
        return true;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public void refresh() {
        if (this.isRequestRunning) {
            return;
        }
        this.isRequestRunning = true;
        EntryClassUi.showWaitModal();
        this.bundlesDataProvider.getList().clear();
        this.gwtXSRFService.generateSecurityToken(new AsyncCallback<GwtXSRFToken>(){

            public void onFailure(Throwable ex) {
                BundlesTabUi.this.isRequestRunning = false;
                EntryClassUi.hideWaitModal();
                FailureHandler.handle(ex);
            }

            public void onSuccess(GwtXSRFToken token) {
                BundlesTabUi.this.gwtDeviceService.findBundles(token, new AsyncCallback<ArrayList<GwtGroupedNVPair>>(){

                    public void onFailure(Throwable caught) {
                        BundlesTabUi.this.isRequestRunning = false;
                        EntryClassUi.hideWaitModal();
                        FailureHandler.handle(caught);
                        BundlesTabUi.this.bundlesDataProvider.flush();
                    }

                    public void onSuccess(ArrayList<GwtGroupedNVPair> result) {
                        EntryClassUi.hideWaitModal();
                        BundlesTabUi.this.isRequestRunning = false;
                        for (GwtGroupedNVPair resultPair : result) {
                            BundlesTabUi.this.bundlesDataProvider.getList().add(resultPair);
                        }
                        int size = BundlesTabUi.this.bundlesDataProvider.getList().size();
                        (this).BundlesTabUi.this.bundlesGrid.setVisibleRange(0, size);
                        BundlesTabUi.this.bundlesDataProvider.flush();
                    }
                });
            }
        });
    }

    static interface BundlesTabUiUiBinder
    extends UiBinder<Widget, BundlesTabUi> {
    }
}

