/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.client.ui.Network;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import org.eclipse.kura.web.client.messages.Messages;
import org.eclipse.kura.web.client.ui.Network.NetworkTab;
import org.eclipse.kura.web.client.ui.Network.TabDhcpNatUi;
import org.eclipse.kura.web.client.ui.Network.TabHardwareUi;
import org.eclipse.kura.web.client.ui.Network.TabModemGpsUi;
import org.eclipse.kura.web.client.ui.Network.TabModemUi;
import org.eclipse.kura.web.client.ui.Network.TabTcpIpUi;
import org.eclipse.kura.web.client.ui.Network.TabWirelessUi;
import org.eclipse.kura.web.client.util.MessageUtils;
import org.eclipse.kura.web.shared.model.GwtModemInterfaceConfig;
import org.eclipse.kura.web.shared.model.GwtNetIfStatus;
import org.eclipse.kura.web.shared.model.GwtNetIfType;
import org.eclipse.kura.web.shared.model.GwtNetInterfaceConfig;
import org.eclipse.kura.web.shared.model.GwtSession;
import org.eclipse.kura.web.shared.model.GwtWifiNetInterfaceConfig;
import org.eclipse.kura.web.shared.model.GwtWifiWirelessMode;
import org.gwtbootstrap3.client.ui.AnchorListItem;
import org.gwtbootstrap3.client.ui.NavbarNav;
import org.gwtbootstrap3.client.ui.PanelBody;

public class NetworkTabsUi
extends Composite {
    private static final String WIFI_ACCESS_POINT = GwtWifiWirelessMode.netWifiWirelessModeAccessPoint.name();
    private static final String IPV4_STATUS_DISABLED_MESSAGE = MessageUtils.get(GwtNetIfStatus.netIPv4StatusDisabled.name());
    private static final String IPV4_STATUS_UNMANAGED_MESSAGE = MessageUtils.get(GwtNetIfStatus.netIPv4StatusUnmanaged.name());
    private static final String IPV4_STATUS_ENABLED_LAN_MESSAGE = MessageUtils.get(GwtNetIfStatus.netIPv4StatusEnabledLAN.name());
    private static NetworkTabsUiUiBinder uiBinder = (NetworkTabsUiUiBinder)GWT.create(NetworkTabsUiUiBinder.class);
    private static final Messages MSGS = (Messages)GWT.create(Messages.class);
    AnchorListItem hardwareTab;
    AnchorListItem tcpIpTab;
    AnchorListItem dhcpNatTab;
    AnchorListItem wirelessTab;
    AnchorListItem modemTab;
    AnchorListItem modemGpsTab;
    ArrayList<AnchorListItem> visibleTabs = new ArrayList();
    NetworkTab selectedTab;
    TabHardwareUi hardware;
    TabTcpIpUi tcpIp;
    TabDhcpNatUi dhcpNat;
    TabWirelessUi wireless;
    TabModemUi modem;
    TabModemGpsUi modemGps;
    GwtNetInterfaceConfig netIfConfig;
    GwtSession session;
    @UiField
    NavbarNav tabsPanel;
    @UiField
    PanelBody content;

    public NetworkTabsUi(GwtSession session) {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.session = session;
        this.initTabs();
    }

    public void setNetInterface(GwtNetInterfaceConfig selection) {
        this.netIfConfig = selection;
        this.tcpIp.setNetInterface(selection);
        this.hardware.setNetInterface(selection);
        this.wireless.setNetInterface(selection);
        this.dhcpNat.setNetInterface(selection);
        this.modem.setNetInterface(selection);
        this.modemGps.setNetInterface(selection);
        this.removeInterfaceTabs();
        if (!GwtNetIfStatus.netIPv4StatusDisabled.equals(selection.getStatusEnum())) {
            this.adjustInterfaceTabs();
        }
        if (this.visibleTabs.contains(this.tcpIpTab)) {
            this.setSelected(this.tcpIpTab);
            this.selectedTab = this.tcpIp;
            this.content.clear();
            this.content.add((Widget)this.tcpIp);
            this.tcpIp.refresh();
        }
        if (this.visibleTabs.contains(this.hardwareTab)) {
            this.hardware.refresh();
        }
        if (this.visibleTabs.contains(this.dhcpNatTab)) {
            this.dhcpNat.refresh();
        }
        if (this.visibleTabs.contains(this.wirelessTab)) {
            this.wireless.refresh();
        }
        if (this.visibleTabs.contains(this.modemTab)) {
            this.modem.refresh();
        }
        if (this.visibleTabs.contains(this.modemGpsTab)) {
            this.modemGps.refresh();
        }
    }

    public boolean isDirty() {
        if (this.tcpIp != null && this.visibleTabs.contains(this.tcpIpTab) && this.tcpIp.isDirty()) {
            return true;
        }
        if (this.hardware != null && this.visibleTabs.contains(this.hardwareTab) && this.hardware.isDirty()) {
            return true;
        }
        if (this.dhcpNat != null && this.visibleTabs.contains(this.dhcpNatTab) && this.dhcpNat.isDirty()) {
            return true;
        }
        if (this.wireless != null && this.visibleTabs.contains(this.wirelessTab) && this.wireless.isDirty()) {
            return true;
        }
        if (this.modem != null && this.visibleTabs.contains(this.modemTab) && this.modem.isDirty()) {
            return true;
        }
        return this.modemGps != null && this.visibleTabs.contains(this.modemGpsTab) && this.modemGps.isDirty();
    }

    public void setDirty(boolean b) {
        if (this.tcpIp != null) {
            this.tcpIp.setDirty(b);
        }
        if (this.hardware != null) {
            this.hardware.setDirty(b);
        }
        if (this.dhcpNat != null) {
            this.dhcpNat.setDirty(b);
        }
        if (this.wireless != null) {
            this.wireless.setDirty(b);
        }
        if (this.modem != null) {
            this.modem.setDirty(b);
        }
        if (this.modemGps != null) {
            this.modemGps.setDirty(b);
        }
    }

    public void refresh() {
        if (this.tcpIp != null) {
            this.tcpIp.refresh();
        }
        if (this.hardware != null) {
            this.hardware.refresh();
        }
        if (this.dhcpNat != null) {
            this.dhcpNat.refresh();
        }
        if (this.wireless != null) {
            this.wireless.refresh();
        }
        if (this.modem != null) {
            this.modem.refresh();
        }
        if (this.modemGps != null) {
            this.modemGps.refresh();
        }
    }

    public void adjustInterfaceTabs() {
        boolean includeDhcpNat;
        String netIfStatus = this.tcpIp.getStatus();
        boolean bl = includeDhcpNat = !this.tcpIp.isDhcp() && netIfStatus.equals(IPV4_STATUS_ENABLED_LAN_MESSAGE);
        if (this.netIfConfig instanceof GwtWifiNetInterfaceConfig) {
            this.removeTab(this.modemTab);
            this.removeTab(this.modemGpsTab);
            this.insertTab(this.wirelessTab, 1);
            if (!this.wirelessTab.isEnabled()) {
                this.wirelessTab.setEnabled(true);
            }
            this.insertTab(this.dhcpNatTab, 2);
            String mode = this.wireless.getWirelessMode().name();
            if (mode != null && !mode.equals(WIFI_ACCESS_POINT)) {
                includeDhcpNat = false;
            }
        } else if (this.netIfConfig instanceof GwtModemInterfaceConfig) {
            includeDhcpNat = false;
            this.removeTab(this.wirelessTab);
            this.removeTab(this.dhcpNatTab);
            this.insertTab(this.modemTab, 1);
            if (!this.modemTab.isEnabled()) {
                this.modemTab.setEnabled(true);
            }
            this.insertTab(this.modemGpsTab, 2);
        } else {
            this.removeTab(this.wirelessTab);
            this.removeTab(this.modemTab);
            this.removeTab(this.modemGpsTab);
            if (this.netIfConfig.getHwTypeEnum() == GwtNetIfType.LOOPBACK || this.netIfConfig.getName().startsWith("mon.wlan")) {
                this.removeTab(this.dhcpNatTab);
            } else {
                this.insertTab(this.dhcpNatTab, 1);
            }
        }
        if (includeDhcpNat) {
            this.dhcpNatTab.setEnabled(true);
        } else {
            this.dhcpNatTab.setEnabled(false);
        }
        if (netIfStatus.equals(IPV4_STATUS_DISABLED_MESSAGE) || netIfStatus.equals(IPV4_STATUS_UNMANAGED_MESSAGE)) {
            this.disableInterfaceTabs();
        }
        if (this.netIfConfig instanceof GwtModemInterfaceConfig) {
            if (((GwtModemInterfaceConfig)this.netIfConfig).isGpsSupported() && !netIfStatus.equals(IPV4_STATUS_UNMANAGED_MESSAGE)) {
                this.modemGpsTab.setEnabled(true);
            } else {
                this.modemGpsTab.setEnabled(false);
            }
        }
    }

    public GwtNetInterfaceConfig getUpdatedInterface() {
        GwtNetInterfaceConfig updatedNetIf = null;
        updatedNetIf = this.netIfConfig instanceof GwtWifiNetInterfaceConfig ? new GwtWifiNetInterfaceConfig() : (this.netIfConfig instanceof GwtModemInterfaceConfig ? new GwtModemInterfaceConfig() : new GwtNetInterfaceConfig());
        updatedNetIf.setProperties(this.netIfConfig.getProperties());
        if (this.visibleTabs.contains(this.tcpIpTab)) {
            this.tcpIp.getUpdatedNetInterface(updatedNetIf);
        }
        if (this.visibleTabs.contains(this.hardwareTab)) {
            this.hardware.getUpdatedNetInterface(updatedNetIf);
        }
        if (this.visibleTabs.contains(this.dhcpNatTab)) {
            this.dhcpNat.getUpdatedNetInterface(updatedNetIf);
        }
        if (this.visibleTabs.contains(this.wirelessTab)) {
            this.wireless.getUpdatedNetInterface(updatedNetIf);
        }
        if (this.visibleTabs.contains(this.modemTab)) {
            this.modem.getUpdatedNetInterface(updatedNetIf);
        }
        if (this.visibleTabs.contains(this.modemGpsTab)) {
            this.modemGps.getUpdatedNetInterface(updatedNetIf);
        }
        return updatedNetIf;
    }

    public NetworkTab getSelectedTab() {
        return this.selectedTab;
    }

    public boolean isValid() {
        if (this.visibleTabs.contains(this.tcpIpTab) && !this.tcpIp.isValid()) {
            return false;
        }
        if (this.visibleTabs.contains(this.hardwareTab) && !this.hardware.isValid()) {
            return false;
        }
        if (this.visibleTabs.contains(this.dhcpNatTab) && !this.dhcpNat.isValid()) {
            return false;
        }
        if (this.visibleTabs.contains(this.wirelessTab) && !this.wireless.isValid()) {
            return false;
        }
        if (this.visibleTabs.contains(this.modemTab) && !this.modem.isValid()) {
            return false;
        }
        return !this.visibleTabs.contains(this.modemGpsTab) || this.modemGps.isValid();
    }

    private void initTabs() {
        this.tabsPanel.clear();
        this.visibleTabs.clear();
        this.tcpIpTab = new AnchorListItem(MSGS.netIPv4());
        this.visibleTabs.add(this.tcpIpTab);
        this.tcpIp = new TabTcpIpUi(this.session, this);
        this.tcpIpTab.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                NetworkTabsUi.this.setSelected(NetworkTabsUi.this.tcpIpTab);
                NetworkTabsUi.this.selectedTab = NetworkTabsUi.this.tcpIp;
                NetworkTabsUi.this.content.clear();
                NetworkTabsUi.this.content.add((Widget)NetworkTabsUi.this.tcpIp);
            }
        });
        this.tabsPanel.add((Widget)this.tcpIpTab);
        this.wirelessTab = new AnchorListItem(MSGS.netWifiWireless());
        this.visibleTabs.add(this.wirelessTab);
        this.wireless = new TabWirelessUi(this.session, this.tcpIp, this);
        this.wirelessTab.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                NetworkTabsUi.this.setSelected(NetworkTabsUi.this.wirelessTab);
                NetworkTabsUi.this.selectedTab = NetworkTabsUi.this.wireless;
                NetworkTabsUi.this.content.clear();
                NetworkTabsUi.this.content.add((Widget)NetworkTabsUi.this.wireless);
            }
        });
        this.tabsPanel.add((Widget)this.wirelessTab);
        this.modemTab = new AnchorListItem(MSGS.netModemCellular());
        this.visibleTabs.add(this.modemTab);
        this.modem = new TabModemUi(this.session, this.tcpIp);
        this.modemTab.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                NetworkTabsUi.this.setSelected(NetworkTabsUi.this.modemTab);
                NetworkTabsUi.this.selectedTab = NetworkTabsUi.this.modem;
                NetworkTabsUi.this.content.clear();
                NetworkTabsUi.this.content.add((Widget)NetworkTabsUi.this.modem);
            }
        });
        this.tabsPanel.add((Widget)this.modemTab);
        this.modemGpsTab = new AnchorListItem(MSGS.netModemGps());
        this.visibleTabs.add(this.modemGpsTab);
        this.modemGps = new TabModemGpsUi(this.session);
        this.modemGpsTab.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                NetworkTabsUi.this.setSelected(NetworkTabsUi.this.modemGpsTab);
                NetworkTabsUi.this.modemGps.refresh();
                NetworkTabsUi.this.selectedTab = NetworkTabsUi.this.modemGps;
                NetworkTabsUi.this.content.clear();
                NetworkTabsUi.this.content.add((Widget)NetworkTabsUi.this.modemGps);
            }
        });
        this.tabsPanel.add((Widget)this.modemGpsTab);
        this.dhcpNatTab = new AnchorListItem(MSGS.netRouter());
        this.visibleTabs.add(this.dhcpNatTab);
        this.dhcpNat = new TabDhcpNatUi(this.session, this.tcpIp, this.wireless);
        this.dhcpNatTab.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                NetworkTabsUi.this.setSelected(NetworkTabsUi.this.dhcpNatTab);
                NetworkTabsUi.this.selectedTab = NetworkTabsUi.this.dhcpNat;
                NetworkTabsUi.this.content.clear();
                NetworkTabsUi.this.content.add((Widget)NetworkTabsUi.this.dhcpNat);
            }
        });
        this.tabsPanel.add((Widget)this.dhcpNatTab);
        this.hardwareTab = new AnchorListItem(MSGS.netHwHardware());
        this.visibleTabs.add(this.hardwareTab);
        this.hardware = new TabHardwareUi(this.session);
        this.hardwareTab.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                NetworkTabsUi.this.setSelected(NetworkTabsUi.this.hardwareTab);
                NetworkTabsUi.this.selectedTab = NetworkTabsUi.this.hardware;
                NetworkTabsUi.this.content.clear();
                NetworkTabsUi.this.content.add((Widget)NetworkTabsUi.this.hardware);
            }
        });
        this.tabsPanel.add((Widget)this.hardwareTab);
        this.setSelected(this.tcpIpTab);
        this.selectedTab = this.tcpIp;
        this.content.clear();
        this.content.add((Widget)this.tcpIp);
    }

    private void disableInterfaceTabs() {
        this.visibleTabs.remove(this.wirelessTab);
        this.visibleTabs.remove(this.modemTab);
        this.visibleTabs.remove(this.dhcpNatTab);
        this.wirelessTab.setEnabled(false);
        this.modemTab.setEnabled(false);
        this.modemGpsTab.setEnabled(false);
        this.dhcpNatTab.setEnabled(false);
    }

    private void removeTab(AnchorListItem tab) {
        if (this.visibleTabs.contains(tab)) {
            this.visibleTabs.remove(tab);
        }
        if (this.tabsPanel.getWidgetIndex((Widget)tab) > -1) {
            this.tabsPanel.remove((Widget)tab);
        }
    }

    private void insertTab(AnchorListItem tab, int index) {
        if (!this.visibleTabs.contains(tab)) {
            this.visibleTabs.add(index, tab);
        }
        if (this.tabsPanel.getWidgetIndex((Widget)tab) == -1) {
            this.tabsPanel.insert((Widget)tab, index);
        }
    }

    private void removeInterfaceTabs() {
        this.visibleTabs.remove(this.wirelessTab);
        this.visibleTabs.remove(this.modemTab);
        this.visibleTabs.remove(this.modemGpsTab);
        this.visibleTabs.remove(this.dhcpNatTab);
        this.tabsPanel.remove((Widget)this.wirelessTab);
        this.tabsPanel.remove((Widget)this.modemTab);
        this.tabsPanel.remove((Widget)this.dhcpNatTab);
    }

    private void setSelected(AnchorListItem item) {
        this.hardwareTab.setActive(false);
        this.tcpIpTab.setActive(false);
        this.dhcpNatTab.setActive(false);
        this.wirelessTab.setActive(false);
        this.modemTab.setActive(false);
        this.modemGpsTab.setActive(false);
        item.setActive(true);
    }

    static interface NetworkTabsUiUiBinder
    extends UiBinder<Widget, NetworkTabsUi> {
    }
}

