/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.client.ui.wires;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.kura.web.client.configuration.Configurations;
import org.eclipse.kura.web.client.configuration.HasConfiguration;
import org.eclipse.kura.web.client.messages.Messages;
import org.eclipse.kura.web.client.ui.AlertDialog;
import org.eclipse.kura.web.client.ui.wires.ConfigurationAreaUi;
import org.eclipse.kura.web.client.ui.wires.WireComponentDescriptors;
import org.eclipse.kura.web.client.ui.wires.WireComponentsAnchorListItem;
import org.eclipse.kura.web.client.ui.wires.WiresDialogs;
import org.eclipse.kura.web.client.ui.wires.WiresRPC;
import org.eclipse.kura.web.client.ui.wires.composer.BlinkEffect;
import org.eclipse.kura.web.client.ui.wires.composer.DropEvent;
import org.eclipse.kura.web.client.ui.wires.composer.PortNames;
import org.eclipse.kura.web.client.ui.wires.composer.Wire;
import org.eclipse.kura.web.client.ui.wires.composer.WireComponent;
import org.eclipse.kura.web.client.ui.wires.composer.WireComposer;
import org.eclipse.kura.web.shared.AssetConstants;
import org.eclipse.kura.web.shared.IdHelper;
import org.eclipse.kura.web.shared.model.GwtConfigComponent;
import org.eclipse.kura.web.shared.model.GwtWireComponentConfiguration;
import org.eclipse.kura.web.shared.model.GwtWireComponentDescriptor;
import org.eclipse.kura.web.shared.model.GwtWireComposerStaticInfo;
import org.eclipse.kura.web.shared.model.GwtWireConfiguration;
import org.eclipse.kura.web.shared.model.GwtWireGraphConfiguration;
import org.gwtbootstrap3.client.ui.Alert;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.NavPills;
import org.gwtbootstrap3.client.ui.Panel;
import org.gwtbootstrap3.client.ui.PanelBody;
import org.gwtbootstrap3.client.ui.PanelHeader;
import org.gwtbootstrap3.client.ui.Row;
import org.gwtbootstrap3.client.ui.constants.AlertType;

public class WiresPanelUi
extends Composite
implements WireComposer.Listener,
HasConfiguration.Listener,
WiresDialogs.Listener {
    private static final WiresPanelUiUiBinder uiBinder = (WiresPanelUiUiBinder)GWT.create(WiresPanelUiUiBinder.class);
    private static final Messages MSGS = (Messages)GWT.create(Messages.class);
    static final String WIRE_ASSET = "WireAsset";
    static final String FACTORY_PID_DROP_PREFIX = "factory://";
    private static final String WIRE_ASSET_PID = "org.eclipse.kura.wire.WireAsset";
    private static final String DRIVER_PID = "driver.pid";
    @UiField
    Button btnSave;
    @UiField
    Button btnReset;
    @UiField
    Button btnDownload;
    @UiField
    Button btnZoomIn;
    @UiField
    Button btnZoomOut;
    @UiField
    Button btnZoomFit;
    @UiField
    Button btnDelete;
    @UiField
    Button btnGraphDelete;
    @UiField
    Panel propertiesPanel;
    @UiField
    PanelBody propertiesPanelBody;
    @UiField
    PanelHeader propertiesPanelHeader;
    @UiField
    Row configurationRow;
    @UiField
    NavPills wireComponentsMenu;
    @UiField
    Widget composer;
    @UiField
    WiresDialogs dialogs;
    @UiField
    AlertDialog confirmDialog;
    private WireComposer wireComposer;
    private BlinkEffect blinkEffect;
    private WireComponentDescriptors descriptors = new WireComponentDescriptors();
    private Configurations configurations = new Configurations();

    public WiresPanelUi() {
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
        this.wireComposer = WireComposer.create((Element)this.composer.getElement());
        this.wireComposer.setListener(this);
        this.blinkEffect = BlinkEffect.create(this.wireComposer);
        this.dialogs.setListener(this);
        this.initButtons();
    }

    private void initButtons() {
        this.btnZoomIn.addClickHandler(event -> this.wireComposer.zoomIn());
        this.btnZoomOut.addClickHandler(event -> this.wireComposer.zoomOut());
        this.btnZoomFit.addClickHandler(event -> this.wireComposer.fitContent(true));
        this.btnSave.addClickHandler(event -> {
            List<String> invalidConfigurationPids = this.configurations.getInvalidConfigurationPids();
            if (!invalidConfigurationPids.isEmpty()) {
                this.confirmDialog.show(MSGS.cannotSaveWiresConfigurationInvalid(invalidConfigurationPids.toString().replaceAll("[\\[\\]]", "")), AlertDialog.Severity.ALERT, null);
                return;
            }
            this.confirmDialog.show(MSGS.wiresSave(), () -> WiresRPC.updateWiresConfiguration(this.getGwtWireGraphConfiguration(), this.getModifiedDriverConfigurations(), result -> this.clearDirtyState()));
        });
        this.btnReset.addClickHandler(event -> this.confirmDialog.show(MSGS.deviceConfigDirty(), this::load));
        this.btnDelete.addClickHandler(event -> this.confirmDialog.show(MSGS.wiresComponentDeleteAlert(), () -> {
            WireComponent component = this.wireComposer.getSelectedWireComponent();
            if (component != null) {
                this.wireComposer.deleteWireComponent(component);
            }
        }));
        this.btnGraphDelete.addClickHandler(event -> this.confirmDialog.show(MSGS.wiresGraphDeleteAlert(), () -> this.wireComposer.clear()));
        this.btnDownload.addClickHandler(event -> {
            List<String> invalidConfigurationPids = this.configurations.getInvalidConfigurationPids();
            if (!invalidConfigurationPids.isEmpty()) {
                this.confirmDialog.show(MSGS.cannotDownloadSnapshotWiresConfigurationInvalid(invalidConfigurationPids.toString().replaceAll("[\\[\\]]", "")), AlertDialog.Severity.ALERT, null);
                return;
            }
            WiresRPC.downloadWiresSnapshot();
        });
    }

    public boolean isDirty() {
        return this.configurations.isDirty() || this.wireComposer.isDirty();
    }

    public void load() {
        WiresRPC.loadStaticInfo(result -> {
            this.loadStaticInformation((GwtWireComposerStaticInfo)result);
            WiresRPC.loadWiresConfiguration(result1 -> {
                this.loadGraph((GwtWireGraphConfiguration)result1);
                this.dialogs.setDriverPids(this.configurations.getDriverPids());
                this.dialogs.setAssetPids(this.getAssetsNotInComposer());
                this.configurations.setAllActivePids(result1.getAllActivePids());
                this.blinkEffect.setEnabled(true);
                this.clearDirtyState();
            });
        });
    }

    private void populateComponentsPanel() {
        this.wireComponentsMenu.clear();
        WireComponentsAnchorListItem.Listener listener = this::showComponentCreationDialog;
        ArrayList<GwtWireComponentDescriptor> sortedDescriptors = new ArrayList<GwtWireComponentDescriptor>();
        for (Map.Entry<String, GwtWireComponentDescriptor> entry : this.descriptors.getDescriptors().entrySet()) {
            sortedDescriptors.add(entry.getValue());
        }
        Collections.sort(sortedDescriptors, (o1, o2) -> Integer.compare(o1.getMinInputPorts() * 2 + o1.getMinOutputPorts(), o2.getMinInputPorts() * 2 + o2.getMinOutputPorts()));
        for (GwtWireComponentDescriptor gwtWireComponentDescriptor : sortedDescriptors) {
            WireComponentsAnchorListItem item = new WireComponentsAnchorListItem(WiresPanelUi.getComponentLabel(gwtWireComponentDescriptor), gwtWireComponentDescriptor.getFactoryPid(), gwtWireComponentDescriptor.getMinInputPorts() > 0, gwtWireComponentDescriptor.getMinOutputPorts() > 0);
            item.setListener(listener);
            this.wireComponentsMenu.add((Widget)item);
        }
    }

    private void loadStaticInformation(GwtWireComposerStaticInfo staticInfo) {
        this.configurations.setChannelDescriptiors(staticInfo.getDriverDescriptors());
        this.configurations.setBaseChannelDescriptor(staticInfo.getBaseChannelDescriptor());
        this.configurations.setComponentDefinitions(staticInfo.getComponentDefinitions());
        this.descriptors.setDescriptors(staticInfo.getWireComponentDescriptors());
        this.dialogs.setDriverFactoryPids(this.configurations.getDriverFactoryPids());
        this.populateComponentsPanel();
    }

    private void loadGraph(GwtWireGraphConfiguration configuration) {
        this.wireComposer.clear();
        ArrayList<GwtConfigComponent> configurationList = new ArrayList<GwtConfigComponent>();
        for (GwtWireComponentConfiguration gwtWireComponentConfiguration : configuration.getWireComponentConfigurations()) {
            configurationList.add(gwtWireComponentConfiguration.getConfiguration());
            WireComponent component = WireComponent.fromGwt(gwtWireComponentConfiguration);
            GwtWireComponentDescriptor descriptor = this.descriptors.getDescriptor(component.getFactoryPid());
            if (descriptor != null) {
                component.getRenderingProperties().setInputPortNames(PortNames.fromMap(descriptor.getInputPortNames()));
                component.getRenderingProperties().setOutputPortNames(PortNames.fromMap(descriptor.getOutputPortNames()));
            }
            this.wireComposer.addWireComponent(component);
        }
        for (GwtWireConfiguration gwtWireConfiguration : configuration.getWires()) {
            this.wireComposer.addWire(Wire.fromGwt(gwtWireConfiguration));
        }
        configurationList.addAll(configuration.getAdditionalConfigurations());
        this.configurations.setComponentConfigurations(configurationList);
        for (WireComponent wireComponent : this.wireComposer.getWireComponents()) {
            try {
                this.validateAndGetWireComponentConfiguration(wireComponent.getPid());
                wireComponent.setValid(true);
            }
            catch (Exception exception) {
                wireComponent.setValid(false);
            }
        }
        this.wireComposer.fitContent(false);
    }

    private GwtWireGraphConfiguration getGwtWireGraphConfiguration() {
        GwtWireGraphConfiguration result = new GwtWireGraphConfiguration();
        ArrayList<GwtWireComponentConfiguration> wireComponentConfigurations = new ArrayList<GwtWireComponentConfiguration>();
        for (WireComponent component : this.wireComposer.getWireComponents()) {
            wireComponentConfigurations.add(component.toGwt(this.configurations.getConfiguration(component.getPid()).getConfiguration()));
        }
        ArrayList<GwtWireConfiguration> wires = new ArrayList<GwtWireConfiguration>();
        for (Wire wire : this.wireComposer.getWires()) {
            wires.add(wire.toGwt());
        }
        result.setWireComponentConfigurations(wireComponentConfigurations);
        result.setWires(wires);
        return result;
    }

    private List<GwtConfigComponent> getModifiedDriverConfigurations() {
        ArrayList<GwtConfigComponent> result = new ArrayList<GwtConfigComponent>();
        for (HasConfiguration config : this.configurations.getConfigurations()) {
            GwtConfigComponent gwtConfig;
            if (!config.isDirty() || !config.isValid() || !(gwtConfig = config.getConfiguration()).isDriver()) continue;
            result.add(gwtConfig);
        }
        return result;
    }

    private void clearConfigurationArea() {
        Window.scrollTo((int)0, (int)0);
        this.configurationRow.setVisible(false);
        this.configurationRow.clear();
    }

    private void showConfigurationArea(Widget content) {
        this.configurationRow.add(content);
        this.configurationRow.setVisible(true);
    }

    public void showConfigurationArea(HasConfiguration configuration) {
        this.clearConfigurationArea();
        ConfigurationAreaUi configurationAreaUi = new ConfigurationAreaUi(configuration, this.configurations);
        configurationAreaUi.setListener(this);
        this.showConfigurationArea((Widget)configurationAreaUi);
    }

    public void showConfigurationErrorMessage(String message) {
        this.clearConfigurationArea();
        this.showConfigurationArea((Widget)new Alert(message, AlertType.DANGER));
    }

    public static String getComponentLabel(GwtConfigComponent config) {
        if (config.getComponentName() != null) {
            return config.getComponentName();
        }
        return IdHelper.getLastIdComponent(config.getFactoryId());
    }

    public static String getComponentLabel(GwtWireComponentDescriptor descriptor) {
        if (descriptor.getName() != null) {
            return descriptor.getName();
        }
        return IdHelper.getLastIdComponent(descriptor.getFactoryPid());
    }

    private WireComponent createAsset(String pid, String driverPid) {
        HasConfiguration assetConfig = this.configurations.createAndRegisterConfiguration(pid, WIRE_ASSET_PID);
        assetConfig.getConfiguration().getParameter(AssetConstants.ASSET_DRIVER_PROP.value()).setValue(driverPid);
        return this.descriptors.createNewComponent(pid, WIRE_ASSET_PID);
    }

    public void showComponentCreationDialog(final String factoryPid) {
        if (this.descriptors.getDescriptor(factoryPid) == null) {
            return;
        }
        this.dialogs.pickComponent(factoryPid, new WiresDialogs.Callback(){

            @Override
            public void onNewComponentCreated(String pid) {
                WiresPanelUi.this.wireComposer.addWireComponent(WiresPanelUi.this.descriptors.createNewComponent(pid, factoryPid));
            }

            @Override
            public void onNewAssetCreated(String pid, String driverPid) {
                WiresPanelUi.this.wireComposer.addWireComponent(WiresPanelUi.this.createAsset(pid, driverPid));
            }

            @Override
            public void onCancel() {
            }
        });
    }

    private void hideConfigurationArea() {
        this.configurationRow.clear();
        this.configurationRow.setVisible(false);
    }

    public void clearDirtyState() {
        this.wireComposer.clearDirtyState();
        this.configurations.clearDirtyState();
        this.updateDirtyState();
        this.wireComposer.deselectWireCompoent();
    }

    public void updateDirtyState() {
        boolean isDirty = this.isDirty();
        this.btnSave.setEnabled(isDirty);
        this.btnReset.setEnabled(isDirty);
        this.btnDownload.setEnabled(!isDirty);
    }

    public void unload() {
        this.blinkEffect.setEnabled(false);
    }

    private List<String> getAssetsNotInComposer() {
        List<String> assetPids = this.configurations.getFactoryInstancesPids(WIRE_ASSET_PID);
        Iterator<String> i = assetPids.iterator();
        while (i.hasNext()) {
            String pid = i.next();
            if (this.wireComposer.getWireComponent(pid) == null) continue;
            i.remove();
        }
        return assetPids;
    }

    private HasConfiguration validateAndGetWireComponentConfiguration(String pid) {
        try {
            HasConfiguration configuration = this.configurations.getConfiguration(pid);
            if (configuration == null) {
                throw new IllegalArgumentException(MSGS.errorComponentConfigurationMissing(pid));
            }
            GwtConfigComponent gwtConfig = configuration.getConfiguration();
            if (gwtConfig == null || !gwtConfig.isValid()) {
                throw new IllegalArgumentException(MSGS.errorComponentConfigurationMissing(pid));
            }
            if (WIRE_ASSET_PID.equals(gwtConfig.getFactoryId())) {
                String driverPid = gwtConfig.getParameterValue(DRIVER_PID);
                if (this.configurations.getConfiguration(driverPid) == null) {
                    throw new IllegalArgumentException(MSGS.errorDriverConfigurationMissing(pid, driverPid));
                }
                if (this.configurations.getChannelDescriptor(driverPid) == null) {
                    throw new IllegalArgumentException(MSGS.errorDriverDescriptorMissingForAsset(pid, driverPid));
                }
            }
            return configuration;
        }
        catch (IllegalArgumentException e) {
            this.configurations.invalidateConfiguration(pid);
            throw e;
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(MSGS.errorUnexpectedErrorLoadingComponentConfig(pid));
        }
    }

    @Override
    public void onWireCreated(Wire wire) {
        this.updateDirtyState();
    }

    @Override
    public void onWireDeleted(Wire wire) {
        this.updateDirtyState();
    }

    @Override
    public void onWireChanged(Wire wire) {
        this.updateDirtyState();
    }

    @Override
    public void onWireComponentSelected(WireComponent component) {
        try {
            this.btnDelete.setEnabled(true);
            this.showConfigurationArea(this.validateAndGetWireComponentConfiguration(component.getPid()));
        }
        catch (Exception e) {
            this.showConfigurationErrorMessage(e.getMessage());
        }
    }

    @Override
    public void onWireComponentDeselected(WireComponent component) {
        this.btnDelete.setEnabled(false);
        this.hideConfigurationArea();
    }

    @Override
    public void onWireComponentChanged(WireComponent component) {
        this.updateDirtyState();
    }

    @Override
    public void onWireComponentCreated(WireComponent component) {
        this.btnGraphDelete.setEnabled(true);
        this.updateDirtyState();
        if (this.configurations.getConfiguration(component.getPid()) == null) {
            this.configurations.createAndRegisterConfiguration(component.getPid(), component.getFactoryPid());
        }
        this.dialogs.setAssetPids(this.getAssetsNotInComposer());
    }

    @Override
    public void onWireComponentDeleted(WireComponent component) {
        this.configurations.deleteConfiguration(component.getPid());
        this.updateDirtyState();
        this.btnGraphDelete.setEnabled(this.wireComposer.getWireComponentCount() > 0);
        this.dialogs.setAssetPids(this.getAssetsNotInComposer());
    }

    @Override
    public void onDrop(final DropEvent event) {
        String attachment = event.getAttachment();
        if (attachment == null || !attachment.startsWith(FACTORY_PID_DROP_PREFIX)) {
            event.cancel();
            return;
        }
        final String factoryPid = attachment.substring(FACTORY_PID_DROP_PREFIX.length());
        this.dialogs.pickComponent(factoryPid, new WiresDialogs.Callback(){

            @Override
            public void onNewComponentCreated(String pid) {
                event.complete(WiresPanelUi.this.descriptors.createNewComponent(pid, factoryPid));
            }

            @Override
            public void onNewAssetCreated(String pid, String driverPid) {
                event.complete(WiresPanelUi.this.createAsset(pid, driverPid));
            }

            @Override
            public void onCancel() {
                event.cancel();
            }
        });
    }

    @Override
    public void onConfigurationChanged(HasConfiguration newConfiguration) {
        this.configurations.setConfiguration(newConfiguration);
        this.updateDirtyState();
    }

    @Override
    public boolean onNewPidInserted(String pid) {
        boolean isPidValid;
        boolean bl = isPidValid = this.wireComposer.getWireComponent(pid) == null && !this.configurations.isPidExisting(pid);
        if (!isPidValid) {
            this.confirmDialog.show(MSGS.wiresComponentNameAlreadyUsed(pid), AlertDialog.Severity.ALERT, null);
        }
        return isPidValid;
    }

    @Override
    public void onNewDriverCreated(String pid, String factoryPid, GwtConfigComponent descriptor) {
        this.configurations.createAndRegisterConfiguration(pid, factoryPid);
        this.configurations.setChannelDescriptor(pid, descriptor);
        this.dialogs.setDriverPids(this.configurations.getDriverPids());
    }

    @Override
    public void onDirtyStateChanged(HasConfiguration hasConfiguration) {
        this.updateDirtyState();
    }

    static interface WiresPanelUiUiBinder
    extends UiBinder<Widget, WiresPanelUi> {
    }
}

