/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.server;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.certificate.CertificatesService;
import org.eclipse.kura.ssl.SslManagerService;
import org.eclipse.kura.web.server.OsgiRemoteServiceServlet;
import org.eclipse.kura.web.server.util.ServiceLocator;
import org.eclipse.kura.web.shared.GwtKuraErrorCode;
import org.eclipse.kura.web.shared.GwtKuraException;
import org.eclipse.kura.web.shared.model.GwtXSRFToken;
import org.eclipse.kura.web.shared.service.GwtCertificatesService;

public class GwtCertificatesServiceImpl
extends OsgiRemoteServiceServlet
implements GwtCertificatesService {
    private static final long serialVersionUID = 7402961266449489433L;

    @Override
    public Integer storePublicPrivateKeys(GwtXSRFToken xsrfToken, String privateKey, String publicKey, String password, String alias) throws GwtKuraException {
        this.checkXSRFToken(xsrfToken);
        try {
            String key = privateKey.replace("-----BEGIN PRIVATE KEY-----", "").replace("\n", "");
            key = key.replace("-----END PRIVATE KEY-----", "");
            Object convertedData = null;
            try {
                Class<?> clazz = Class.forName("javax.xml.bind.DatatypeConverter");
                Method method = clazz.getMethod("parseBase64Binary", String.class);
                convertedData = method.invoke(null, key);
            }
            catch (ClassNotFoundException classNotFoundException) {
                convertedData = this.base64DecodeJava8(key);
            }
            catch (LinkageError linkageError) {
                convertedData = this.base64DecodeJava8(key);
            }
            catch (Exception e) {
                throw new GwtKuraException(GwtKuraErrorCode.INTERNAL_ERROR, (Throwable)e);
            }
            byte[] conversion = (byte[])convertedData;
            PKCS8EncodedKeySpec specPriv = new PKCS8EncodedKeySpec(conversion);
            KeyFactory kf = KeyFactory.getInstance("RSA");
            PrivateKey privKey = kf.generatePrivate(specPriv);
            Certificate[] certs = this.parsePublicCertificates(publicKey);
            if (privKey == null) {
                throw new GwtKuraException(GwtKuraErrorCode.ILLEGAL_ARGUMENT);
            }
            char[] privateKeyPassword = new char[]{};
            if (password != null) {
                privateKeyPassword = password.toCharArray();
            }
            SslManagerService sslService = ServiceLocator.getInstance().getService(SslManagerService.class);
            sslService.installPrivateKey(alias, privKey, privateKeyPassword, certs);
            return 1;
        }
        catch (UnsupportedEncodingException e) {
            throw new GwtKuraException(GwtKuraErrorCode.ILLEGAL_ARGUMENT, (Throwable)e);
        }
        catch (GeneralSecurityException e) {
            throw new GwtKuraException(GwtKuraErrorCode.ILLEGAL_ARGUMENT, (Throwable)e);
        }
        catch (IOException e) {
            throw new GwtKuraException(GwtKuraErrorCode.ILLEGAL_ARGUMENT, (Throwable)e);
        }
    }

    @Override
    public Integer storeSSLPublicChain(GwtXSRFToken xsrfToken, String publicKeys, String alias) throws GwtKuraException {
        this.checkXSRFToken(xsrfToken);
        try {
            X509Certificate[] certs = this.parsePublicCertificates(publicKeys);
            if (certs.length == 0) {
                throw new GwtKuraException(GwtKuraErrorCode.ILLEGAL_ARGUMENT);
            }
            SslManagerService sslService = ServiceLocator.getInstance().getService(SslManagerService.class);
            boolean leafAssigned = false;
            X509Certificate[] x509CertificateArray = certs;
            int n = certs.length;
            int n2 = 0;
            while (n2 < n) {
                X509Certificate cert = x509CertificateArray[n2];
                if (!leafAssigned && (cert.getBasicConstraints() == -1 || cert.getKeyUsage() != null && !cert.getKeyUsage()[5])) {
                    sslService.installTrustCertificate("ssl-" + alias, cert);
                    leafAssigned = true;
                } else {
                    String certificateAlias = "ca-" + cert.getSerialNumber().toString();
                    sslService.installTrustCertificate(certificateAlias, cert);
                }
                ++n2;
            }
            return certs.length;
        }
        catch (CertificateException e) {
            throw new GwtKuraException(GwtKuraErrorCode.ILLEGAL_ARGUMENT, (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            throw new GwtKuraException(GwtKuraErrorCode.ILLEGAL_ARGUMENT, (Throwable)e);
        }
        catch (GeneralSecurityException e) {
            throw new GwtKuraException(GwtKuraErrorCode.ILLEGAL_ARGUMENT, (Throwable)e);
        }
        catch (IOException e) {
            throw new GwtKuraException(GwtKuraErrorCode.ILLEGAL_ARGUMENT, (Throwable)e);
        }
    }

    @Override
    public Integer storeApplicationPublicChain(GwtXSRFToken xsrfToken, String publicKeys, String alias) throws GwtKuraException {
        this.checkXSRFToken(xsrfToken);
        try {
            X509Certificate[] certs = this.parsePublicCertificates(publicKeys);
            if (certs.length == 0) {
                throw new GwtKuraException(GwtKuraErrorCode.ILLEGAL_ARGUMENT);
            }
            CertificatesService certificateService = ServiceLocator.getInstance().getService(CertificatesService.class);
            boolean leafAssigned = false;
            X509Certificate[] x509CertificateArray = certs;
            int n = certs.length;
            int n2 = 0;
            while (n2 < n) {
                X509Certificate cert = x509CertificateArray[n2];
                if (!leafAssigned && (cert.getBasicConstraints() == -1 || cert.getKeyUsage() != null && !cert.getKeyUsage()[5])) {
                    certificateService.storeCertificate((Certificate)cert, "bundle-" + alias);
                    leafAssigned = true;
                } else {
                    String certificateAlias = "bundle-" + cert.getSerialNumber().toString();
                    certificateService.storeCertificate((Certificate)cert, certificateAlias);
                }
                ++n2;
            }
            return certs.length;
        }
        catch (CertificateException e) {
            throw new GwtKuraException(GwtKuraErrorCode.ILLEGAL_ARGUMENT, (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            throw new GwtKuraException(GwtKuraErrorCode.ILLEGAL_ARGUMENT, (Throwable)e);
        }
        catch (KuraException e) {
            throw new GwtKuraException(GwtKuraErrorCode.ILLEGAL_ARGUMENT, (Throwable)e);
        }
    }

    private X509Certificate[] parsePublicCertificates(String publicKey) throws CertificateException, UnsupportedEncodingException {
        CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
        Collection<? extends Certificate> publicCertificates = certFactory.generateCertificates(new ByteArrayInputStream(publicKey.getBytes("UTF-8")));
        Iterator<? extends Certificate> certIterator = publicCertificates.iterator();
        X509Certificate[] certs = new X509Certificate[publicCertificates.size()];
        int i = 0;
        while (certIterator.hasNext()) {
            X509Certificate cert;
            certs[i] = cert = (X509Certificate)certIterator.next();
            ++i;
        }
        return certs;
    }

    private Object base64DecodeJava8(String key) throws GwtKuraException {
        Object convertedData = null;
        try {
            Class<?> clazz = Class.forName("java.util.Base64");
            Method decoderMethod = clazz.getMethod("getDecoder", null);
            Object decoder = decoderMethod.invoke(null, new Object[0]);
            Class<?> Base64Decoder = Class.forName("java.util.Base64$Decoder");
            Method decodeMethod = Base64Decoder.getMethod("decode", String.class);
            convertedData = decodeMethod.invoke(decoder, key);
        }
        catch (Exception e1) {
            throw new GwtKuraException(GwtKuraErrorCode.INTERNAL_ERROR, (Throwable)e1);
        }
        return convertedData;
    }
}

