/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.server;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Objects;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.kura.deployment.agent.DeploymentAgentService;
import org.eclipse.kura.system.SystemService;
import org.eclipse.kura.web.client.util.GwtSafeHtmlUtils;
import org.eclipse.kura.web.server.OsgiRemoteServiceServlet;
import org.eclipse.kura.web.server.util.ServiceLocator;
import org.eclipse.kura.web.shared.GwtKuraErrorCode;
import org.eclipse.kura.web.shared.GwtKuraException;
import org.eclipse.kura.web.shared.model.GwtBundleInfo;
import org.eclipse.kura.web.shared.model.GwtDeploymentPackage;
import org.eclipse.kura.web.shared.model.GwtMarketplacePackageDescriptor;
import org.eclipse.kura.web.shared.model.GwtXSRFToken;
import org.eclipse.kura.web.shared.service.GwtPackageService;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.Version;
import org.osgi.service.deploymentadmin.BundleInfo;
import org.osgi.service.deploymentadmin.DeploymentAdmin;
import org.osgi.service.deploymentadmin.DeploymentPackage;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GwtPackageServiceImpl
extends OsgiRemoteServiceServlet
implements GwtPackageService {
    private static final long serialVersionUID = -3422518194598042896L;
    private static final Logger logger = LoggerFactory.getLogger(GwtPackageServiceImpl.class);
    private static final int MARKETPLACE_FEEDBACK_REQUEST_TIMEOUT = 20000;

    @Override
    public List<GwtDeploymentPackage> findDeviceDeploymentPackages(GwtXSRFToken xsrfToken) throws GwtKuraException {
        this.checkXSRFToken(xsrfToken);
        DeploymentAdmin deploymentAdmin = ServiceLocator.getInstance().getService(DeploymentAdmin.class);
        ArrayList<GwtDeploymentPackage> gwtDeploymentPackages = new ArrayList<GwtDeploymentPackage>();
        DeploymentPackage[] deploymentPackages = deploymentAdmin.listDeploymentPackages();
        if (deploymentPackages != null) {
            DeploymentPackage[] deploymentPackageArray = deploymentPackages;
            int n = deploymentPackages.length;
            int n2 = 0;
            while (n2 < n) {
                DeploymentPackage deploymentPackage = deploymentPackageArray[n2];
                GwtDeploymentPackage gwtDeploymentPackage = new GwtDeploymentPackage();
                gwtDeploymentPackage.setName(GwtSafeHtmlUtils.htmlEscape(deploymentPackage.getName()));
                gwtDeploymentPackage.setVersion(GwtSafeHtmlUtils.htmlEscape(deploymentPackage.getVersion().toString()));
                ArrayList<GwtBundleInfo> gwtBundleInfos = new ArrayList<GwtBundleInfo>();
                BundleInfo[] bundleInfos = deploymentPackage.getBundleInfos();
                if (bundleInfos != null) {
                    BundleInfo[] bundleInfoArray = bundleInfos;
                    int n3 = bundleInfos.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        BundleInfo bundleInfo = bundleInfoArray[n4];
                        GwtBundleInfo gwtBundleInfo = new GwtBundleInfo();
                        gwtBundleInfo.setName(GwtSafeHtmlUtils.htmlEscape(bundleInfo.getSymbolicName()));
                        gwtBundleInfo.setVersion(GwtSafeHtmlUtils.htmlEscape(bundleInfo.getVersion().toString()));
                        gwtBundleInfos.add(gwtBundleInfo);
                        ++n4;
                    }
                }
                gwtDeploymentPackage.setBundleInfos(gwtBundleInfos);
                gwtDeploymentPackages.add(gwtDeploymentPackage);
                ++n2;
            }
        }
        return gwtDeploymentPackages;
    }

    @Override
    public void uninstallDeploymentPackage(GwtXSRFToken xsrfToken, String packageName) throws GwtKuraException {
        this.checkXSRFToken(xsrfToken);
        DeploymentAgentService deploymentAgentService = ServiceLocator.getInstance().getService(DeploymentAgentService.class);
        try {
            deploymentAgentService.uninstallDeploymentPackageAsync(GwtSafeHtmlUtils.htmlEscape(packageName));
        }
        catch (Exception e) {
            throw new GwtKuraException(GwtKuraErrorCode.INTERNAL_ERROR, (Throwable)e);
        }
    }

    private Node getFirstNode(Document doc, String tagName) {
        NodeList elements = doc.getElementsByTagName(tagName);
        if (elements.getLength() == 0) {
            return null;
        }
        return elements.item(0);
    }

    private String getAttributeValue(NamedNodeMap attributes, String attribute) {
        Node node = attributes.getNamedItem(attribute);
        if (node == null) {
            return null;
        }
        return node.getNodeValue();
    }

    @Override
    public GwtMarketplacePackageDescriptor getMarketplacePackageDescriptor(GwtXSRFToken xsrfToken, String nodeId) throws GwtKuraException {
        this.checkXSRFToken(xsrfToken);
        GwtMarketplacePackageDescriptor descriptor = null;
        URL mpUrl = null;
        HttpURLConnection connection = null;
        try {
            try {
                String kuraPropertyCompatibilityVersion;
                Version kuraVersion;
                Node versionCompatibility;
                mpUrl = new URL("http://marketplace.eclipse.org/node/" + nodeId + "/api/p");
                connection = (HttpURLConnection)mpUrl.openConnection();
                connection.setRequestMethod("GET");
                connection.connect();
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document doc = db.parse(connection.getInputStream());
                descriptor = new GwtMarketplacePackageDescriptor();
                Node updateUrl = this.getFirstNode(doc, "updateurl");
                if (updateUrl == null) {
                    throw new GwtKuraException("Unable to find dp install URL");
                }
                descriptor.setDpUrl(updateUrl.getTextContent());
                Node node = this.getFirstNode(doc, "node");
                if (node != null) {
                    NamedNodeMap nodeAttributes = node.getAttributes();
                    descriptor.setNodeId(this.getAttributeValue(nodeAttributes, "id"));
                    descriptor.setUrl(this.getAttributeValue(nodeAttributes, "url"));
                }
                if ((versionCompatibility = this.getFirstNode(doc, "versioncompatibility")) != null) {
                    NodeList children = versionCompatibility.getChildNodes();
                    int i = 0;
                    while (i < children.getLength()) {
                        Node n = children.item(i);
                        String nodeName = n.getNodeName();
                        if ("from".equalsIgnoreCase(nodeName)) {
                            descriptor.setMinKuraVersion(n.getTextContent());
                        } else if ("to".equalsIgnoreCase(nodeName)) {
                            descriptor.setMaxKuraVersion(n.getTextContent());
                        }
                        ++i;
                    }
                }
                if ((kuraVersion = this.getMarketplaceCompatibilityVersion(kuraPropertyCompatibilityVersion = this.getMarketplaceCompatibilityVersionString())) != null) {
                    kuraPropertyCompatibilityVersion = kuraVersion.toString();
                }
                descriptor.setCurrentKuraVersion(kuraPropertyCompatibilityVersion);
                this.checkCompatibility(descriptor, kuraVersion);
            }
            catch (Exception e) {
                throw new GwtKuraException(GwtKuraErrorCode.INTERNAL_ERROR, (Throwable)e);
            }
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        return descriptor;
    }

    private Version getMarketplaceCompatibilityVersion(String marketplaceCompatibilityVersion) {
        try {
            return new Version(marketplaceCompatibilityVersion);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private String getMarketplaceCompatibilityVersionString() throws GwtKuraException {
        return ServiceLocator.applyToServiceOptionally(SystemService.class, systemService -> systemService.getKuraMarketplaceCompatibilityVersion());
    }

    private void checkCompatibility(GwtMarketplacePackageDescriptor descriptor, Version currentProductVersion) {
        String minKuraVersionString = descriptor.getMinKuraVersion();
        String maxKuraVersionString = descriptor.getMaxKuraVersion();
        try {
            boolean haveMaxKuraVersion;
            boolean haveMinKuraVersion = minKuraVersionString != null && !minKuraVersionString.isEmpty();
            boolean bl = haveMaxKuraVersion = maxKuraVersionString != null && !maxKuraVersionString.isEmpty();
            if (haveMinKuraVersion && currentProductVersion.compareTo(new Version(minKuraVersionString)) < 0) {
                throw new GwtKuraException(GwtKuraErrorCode.MARKETPLACE_COMPATIBILITY_VERSION_UNSUPPORTED);
            }
            if (haveMaxKuraVersion && currentProductVersion.compareTo(new Version(maxKuraVersionString)) > 0) {
                throw new GwtKuraException(GwtKuraErrorCode.MARKETPLACE_COMPATIBILITY_VERSION_UNSUPPORTED);
            }
            descriptor.setCompatible(haveMinKuraVersion || haveMaxKuraVersion);
        }
        catch (Exception exception) {
            descriptor.setCompatible(false);
        }
    }

    @Override
    public void installPackageFromMarketplace(GwtXSRFToken xsrfToken, GwtMarketplacePackageDescriptor descriptor) throws GwtKuraException {
        this.checkXSRFToken(xsrfToken);
        try {
            ServiceLocator.applyToServiceOptionally(DeploymentAgentService.class, deploymentAgentService -> {
                if (deploymentAgentService == null) {
                    throw new IllegalStateException("Deployment Agent Service not running");
                }
                String dpUrl = descriptor.getDpUrl();
                Objects.requireNonNull(dpUrl);
                logger.info("Installing deployment package from Eclipse Marketplace, URL {}...", (Object)dpUrl);
                if (descriptor.getUrl() != null) {
                    new MarketplaceFeedbackEventHandler(descriptor);
                }
                deploymentAgentService.installDeploymentPackageAsync(dpUrl);
                return null;
            });
        }
        catch (Exception e) {
            throw new GwtKuraException(GwtKuraErrorCode.INTERNAL_ERROR, (Throwable)e);
        }
    }

    private static class MarketplaceFeedbackEventHandler
    implements EventHandler {
        private final GwtMarketplacePackageDescriptor descriptor;
        private final ServiceRegistration<EventHandler> registration;
        private static Hashtable<String, Object> serviceProperties;

        static {
            String[] topics = new String[]{DeploymentAgentService.EVENT_INSTALLED_TOPIC};
            serviceProperties = new Hashtable();
            serviceProperties.put("event.topics", topics);
        }

        private MarketplaceFeedbackEventHandler(GwtMarketplacePackageDescriptor descriptor) {
            this.descriptor = descriptor;
            this.registration = FrameworkUtil.getBundle(GwtPackageServiceImpl.class).getBundleContext().registerService(EventHandler.class, (Object)this, serviceProperties);
        }

        private void sendSuccessFeedbackToMarketplace() {
            block8: {
                HttpURLConnection connection = null;
                try {
                    try {
                        logger.info("Sending successful install feedback to Eclipse Marketplace...");
                        String feedbackUrl = this.descriptor.getUrl();
                        feedbackUrl = String.valueOf(feedbackUrl) + (feedbackUrl.endsWith("/") ? "success" : "/success");
                        connection = (HttpURLConnection)new URL(feedbackUrl).openConnection();
                        connection.setRequestMethod("GET");
                        connection.setReadTimeout(20000);
                        connection.connect();
                        if (connection.getResponseCode() / 200 == 1) {
                            logger.info("Sending successful install feedback to Eclipse Marketplace...done");
                            break block8;
                        }
                        throw new IOException("got status: " + connection.getResponseCode());
                    }
                    catch (Exception e) {
                        logger.warn("Sending successful install feedback to Eclipse Marketplace...failure", (Throwable)e);
                        if (connection != null) {
                            connection.disconnect();
                        }
                    }
                }
                finally {
                    if (connection != null) {
                        connection.disconnect();
                    }
                }
            }
        }

        public void handleEvent(Event event) {
            String eventUrl = (String)event.getProperty("deploymentpackage.url");
            String dpUrl = this.descriptor.getDpUrl();
            if (eventUrl != null && eventUrl.equals(this.descriptor.getDpUrl())) {
                try {
                    Boolean successful = (Boolean)event.getProperty("successful");
                    if (successful != null && successful.booleanValue()) {
                        logger.info("Installing deployment package from Eclipse Marketplace, URL {}...success", (Object)dpUrl);
                        this.sendSuccessFeedbackToMarketplace();
                    } else {
                        logger.info("Installing deployment package from Eclipse Marketplace, URL {}...failure", (Object)dpUrl);
                    }
                }
                finally {
                    this.registration.unregister();
                }
            }
        }
    }
}

