/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.server.servlet;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.kura.util.base.StringUtil;
import org.eclipse.kura.wire.graph.Constants;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.wireadmin.Wire;
import org.osgi.service.wireadmin.WireAdminEvent;
import org.osgi.service.wireadmin.WireAdminListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WiresBlinkServlet
extends HttpServlet
implements WireAdminListener {
    private static final Logger logger = LoggerFactory.getLogger(WiresBlinkServlet.class);
    private static final int SESSION_DURATION_MS = 300000;
    private static final int MIN_EVENT_DELAY_MS = 400;
    private static final Dictionary<String, Object> WIRE_EVENT_LISTENER_PROPERTIES = new Hashtable<String, Object>();
    private static final int MAX_SIZE_OF_QUEUE = 10;
    private static final long serialVersionUID = -8962416452919656283L;
    private static final BundleContext bundleContext;
    private static Map<String, RequestContext> requests;
    private static ServiceRegistration<WireAdminListener> registration;

    static {
        WIRE_EVENT_LISTENER_PROPERTIES.put("wireadmin.events", 128);
        bundleContext = FrameworkUtil.getBundle(WiresBlinkServlet.class).getBundleContext();
        requests = new ConcurrentHashMap<String, RequestContext>();
    }

    public void destroy() {
        super.destroy();
        requests.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        RequestContext context;
        String requestId = request.getParameter("session");
        if (StringUtil.isNullOrEmpty((String)requestId)) {
            try {
                response.sendError(400);
            }
            catch (Exception exception) {
                logger.warn("Failed to send status");
            }
            return;
        }
        String sessionToDestroy = request.getParameter("logout");
        if (!StringUtil.isNullOrEmpty((String)sessionToDestroy)) {
            this.removeContext(requestId);
            return;
        }
        response.setContentType("text/event-stream");
        response.setCharacterEncoding("UTF-8");
        response.setHeader("Cache-control", "no-cache");
        response.setHeader("Connection", "keep-alive");
        response.setHeader("Access-Control-Allow-Origin", "*");
        WiresBlinkServlet wiresBlinkServlet = this;
        synchronized (wiresBlinkServlet) {
            ServletOutputStream outputStream;
            try {
                outputStream = response.getOutputStream();
            }
            catch (Exception exception) {
                logger.warn("failed to open response stream");
                return;
            }
            context = new RequestContext(requestId, (OutputStream)outputStream);
            this.addContext(context);
        }
        context.run();
    }

    private synchronized void addContext(RequestContext context) {
        String requestId = context.requestId;
        this.removeContext(requestId);
        requests.put(requestId, context);
        if (registration == null) {
            registration = bundleContext.registerService(WireAdminListener.class, (Object)this, WIRE_EVENT_LISTENER_PROPERTIES);
            logger.info("registered");
        }
    }

    private synchronized void removeContext(String requestId) {
        RequestContext context = requests.remove(requestId);
        if (context != null) {
            context.close();
        }
        if (requests.isEmpty() && registration != null) {
            registration.unregister();
            logger.info("unregistered");
            registration = null;
        }
    }

    public void wireAdminEvent(WireAdminEvent event) {
        Wire wire = event.getWire();
        for (RequestContext context : requests.values()) {
            context.submit(wire);
        }
    }

    private final class RequestContext {
        private final String requestId;
        private final OutputStream outputStream;
        private final PrintStream printStream;
        private final Map<WireEvent, Long> lastSentTimestamp = new HashMap<WireEvent, Long>();
        private final LinkedBlockingQueue<Wire> events = new LinkedBlockingQueue(10);
        private boolean run;

        RequestContext(String requestId, OutputStream outputStream) {
            this.requestId = requestId;
            this.outputStream = outputStream;
            this.printStream = new PrintStream(outputStream);
            this.run = true;
        }

        private boolean shouldDispatch(WireEvent event) {
            long previous = this.lastSentTimestamp.getOrDefault(event, 0L);
            return System.currentTimeMillis() - previous > 400L;
        }

        private boolean processEvent(long startTime) {
            Wire wire;
            if (System.currentTimeMillis() - startTime >= 300000L || !this.run) {
                return false;
            }
            try {
                wire = this.events.poll(1L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return false;
            }
            if (wire == null) {
                return true;
            }
            WireEvent wireEvent = WireEvent.from(wire);
            if (wireEvent == null || !this.shouldDispatch(wireEvent)) {
                return true;
            }
            try {
                this.printStream.printf("data: %s %s%n%n", wireEvent.emitterKuraServicePid, wireEvent.emitterPort);
                this.printStream.flush();
                this.lastSentTimestamp.put(wireEvent, System.currentTimeMillis());
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }

        void run() {
            logger.info("Session started: {}", (Object)this.requestId);
            long startTime = System.currentTimeMillis();
            while (this.processEvent(startTime)) {
            }
            logger.info("Session ended: {}", (Object)this.requestId);
            try {
                this.outputStream.close();
            }
            catch (Exception e) {
                logger.warn("failed to close stream", (Throwable)e);
            }
            WiresBlinkServlet.this.removeContext(this.requestId);
        }

        boolean submit(Wire wire) {
            return this.events.offer(wire);
        }

        void close() {
            this.run = false;
        }
    }

    private static final class WireEvent {
        final String emitterKuraServicePid;
        final String emitterPort;

        static WireEvent from(Wire wire) {
            if (wire == null) {
                return null;
            }
            Dictionary properties = wire.getProperties();
            Object pid = properties.get(Constants.EMITTER_KURA_SERVICE_PID_PROP_NAME.value());
            Object port = properties.get(Constants.WIRE_EMITTER_PORT_PROP_NAME.value());
            if (pid != null && port != null) {
                return new WireEvent(pid.toString(), port.toString());
            }
            return null;
        }

        WireEvent(String emitterKuraServicePid, String emitterPort) {
            this.emitterKuraServicePid = emitterKuraServicePid;
            this.emitterPort = emitterPort;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.emitterKuraServicePid == null ? 0 : this.emitterKuraServicePid.hashCode());
            result = 31 * result + (this.emitterPort == null ? 0 : this.emitterPort.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            WireEvent other = (WireEvent)obj;
            if (this.emitterKuraServicePid == null ? other.emitterKuraServicePid != null : !this.emitterKuraServicePid.equals(other.emitterKuraServicePid)) {
                return false;
            }
            return !(this.emitterPort == null ? other.emitterPort != null : !this.emitterPort.equals(other.emitterPort));
        }
    }
}

