/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.impl.dependencies;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.felix.dm.DependencyService;
import org.apache.felix.dm.ServiceDependency;
import org.apache.felix.dm.TemporalServiceDependency;
import org.apache.felix.dm.impl.Logger;
import org.apache.felix.dm.impl.dependencies.ServiceDependencyImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class TemporalServiceDependencyImpl
extends ServiceDependencyImpl
implements TemporalServiceDependency,
InvocationHandler {
    private long m_timeout = 30000L;
    private volatile Object m_cachedService;
    private final Bundle m_frameworkBundle;

    public TemporalServiceDependencyImpl(BundleContext context, Logger logger) {
        super(context, logger);
        super.setRequired(true);
        this.m_frameworkBundle = context.getBundle(0L);
    }

    public synchronized TemporalServiceDependency setTimeout(long timeout) {
        if (timeout < 0L) {
            throw new IllegalArgumentException("Invalid timeout value: " + timeout);
        }
        this.m_timeout = timeout;
        return this;
    }

    public ServiceDependency setRequired(boolean required) {
        if (!required) {
            throw new IllegalArgumentException("A Temporal Service dependency can't be optional");
        }
        super.setRequired(required);
        return this;
    }

    public synchronized void addedService(ServiceReference ref, Object service) {
        this.m_cachedService = this.m_tracker.getService();
        boolean makeAvailable = this.makeAvailable();
        if (makeAvailable) {
            this.m_serviceInstance = Proxy.newProxyInstance(this.m_trackedServiceName.getClassLoader(), new Class[]{this.m_trackedServiceName}, (InvocationHandler)this);
        }
        Object[] services = this.m_services.toArray();
        for (int i = 0; i < services.length; ++i) {
            DependencyService ds = (DependencyService)services[i];
            if (!makeAvailable) continue;
            ds.dependencyAvailable(this);
        }
        if (!makeAvailable) {
            this.notifyAll();
        }
    }

    public void modifiedService(ServiceReference ref, Object service) {
    }

    public synchronized void removedService(ServiceReference ref, Object service) {
        if (this.m_frameworkBundle.getState() == 16) {
            super.removedService(ref, service);
        } else {
            this.m_context.ungetService(ref);
            this.m_cachedService = this.m_tracker.getService();
        }
    }

    public synchronized Object getService() {
        return this.m_serviceInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object service = this.m_cachedService;
        if (service == null) {
            TemporalServiceDependencyImpl temporalServiceDependencyImpl = this;
            synchronized (temporalServiceDependencyImpl) {
                long start = System.currentTimeMillis();
                long waitTime = this.m_timeout;
                while (service == null) {
                    if (waitTime <= 0L) {
                        throw new IllegalStateException("Service unavailable: " + this.m_trackedServiceName.getName());
                    }
                    try {
                        this.wait(waitTime);
                    }
                    catch (InterruptedException e) {
                        throw new IllegalStateException("Service unavailable: " + this.m_trackedServiceName.getName());
                    }
                    waitTime = this.m_timeout - (System.currentTimeMillis() - start);
                    service = this.m_cachedService;
                }
            }
        }
        try {
            return method.invoke(service, args);
        }
        catch (IllegalAccessException iae) {
            method.setAccessible(true);
            return method.invoke(service, args);
        }
    }
}

