/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.io.impl;

import org.eclipse.equinox.internal.io.impl.ConnectorServiceImpl;
import org.eclipse.equinox.internal.io.impl.TracerConfigConnector;
import org.eclipse.equinox.internal.util.ref.Log;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

public class Activator
implements BundleActivator {
    public static BundleContext bc = null;
    private ConnectorServiceImpl connector;
    private Log log;

    public void start(BundleContext bc) throws BundleException {
        Activator.bc = bc;
        this.log = new Log(bc, false);
        this.log.setDebug(Activator.getBoolean("equinox.connector.debug"));
        this.log.setPrintOnConsole(Activator.getBoolean("equinox.connector.console"));
        if (this.log.getDebug()) {
            this.log.setMaps(TracerConfigConnector.getMap(), null);
        }
        this.connector = new ConnectorServiceImpl(bc, this.log);
    }

    public void stop(BundleContext bc) {
        if (this.connector != null) {
            this.connector.close();
            this.connector = null;
            this.log.close();
        }
        bc = null;
    }

    public static boolean getBoolean(String property) {
        String prop;
        String string = prop = bc != null ? bc.getProperty(property) : System.getProperty(property);
        return prop != null && prop.equalsIgnoreCase("true");
    }

    public static int getInteger(String property, int defaultValue) {
        String prop;
        String string = prop = bc != null ? bc.getProperty(property) : System.getProperty(property);
        if (prop != null) {
            try {
                return Integer.decode(prop);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return defaultValue;
    }
}

