/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.io.impl;

import java.io.IOException;
import java.util.AbstractCollection;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.io.Connection;
import org.eclipse.equinox.internal.io.ConnectionListener;
import org.eclipse.equinox.internal.io.ConnectionNotifier;
import org.eclipse.equinox.internal.io.impl.ConnectionFactoryListener;
import org.eclipse.equinox.internal.io.impl.ConnectorServiceImpl;

class ConnectionNotifierImpl
implements ConnectionNotifier,
Connection {
    private Vector list = new Vector(3, 5);
    String scheme;
    int mode;
    boolean timeouts;
    String url;
    String filter;
    boolean notified = false;
    Object context;

    ConnectionNotifierImpl(String scheme, String url, int mode, boolean timeouts, String filter) {
        this.scheme = scheme;
        this.url = url;
        this.mode = mode;
        this.timeouts = timeouts;
        this.filter = filter;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            this.context = System.getSecurityManager().getSecurityContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void addConnectionListener(ConnectionListener l) {
        long timeStart = 0L;
        if (ConnectorServiceImpl.hasDebug) {
            ConnectorServiceImpl.debug(16050, l.getClass().getName(), null);
            timeStart = System.currentTimeMillis();
        }
        try {
            Vector vector = this.list;
            synchronized (vector) {
                block14: {
                    if (this.notified) break block14;
                    if (!((AbstractCollection)this.list).contains(l)) {
                        this.list.addElement(l);
                    }
                    return;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                try {
                    // MONITOREXIT @DISABLED, blocks:[0, 3, 4, 5] lbl16 : MonitorExitStatement: MONITOREXIT : var4_3
                    Connection c = ConnectorServiceImpl.getConnection(this.filter, this.url, this.mode, this.timeouts, false);
                    if (c != null) {
                        l.notify(this.url, 0, c);
                    }
                }
                catch (Exception exception) {}
            }
        }
        finally {
            if (ConnectorServiceImpl.hasDebug) {
                ConnectorServiceImpl.debug(16051, String.valueOf(System.currentTimeMillis() - timeStart), null);
            }
        }
        {
            return;
        }
    }

    public void removeConnectionListener(ConnectionListener l) {
        if (ConnectorServiceImpl.hasDebug) {
            ConnectorServiceImpl.debug(16052, l.getClass().getName(), null);
        }
        this.list.removeElement(l);
    }

    boolean hasListeners() {
        return !((AbstractCollection)this.list).isEmpty();
    }

    void notifyCreated(Connection conn) {
        this.notify(0, conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notify(int eventType, Connection conn) {
        if (eventType != 0 && eventType != 1) {
            return;
        }
        Vector vector = this.list;
        synchronized (vector) {
            if (this.notified) {
                return;
            }
            this.notified = true;
        }
        ConnectionFactoryListener.removeConnectionNotifier(this.url);
        Enumeration en = this.list.elements();
        while (en.hasMoreElements()) {
            ConnectionListener l = (ConnectionListener)en.nextElement();
            l.notify(this.url, eventType, conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (ConnectorServiceImpl.hasDebug) {
            ConnectorServiceImpl.debug(16053, this.url, null);
        }
        Vector vector = this.list;
        synchronized (vector) {
            if (this.notified) {
                return;
            }
            this.notified = true;
        }
        ConnectionFactoryListener.removeConnectionNotifier(this.url);
    }
}

