/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.deployment.download.impl;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.output.CountingOutputStream;
import org.eclipse.kura.core.deployment.DownloadStatus;
import org.eclipse.kura.core.deployment.download.DeploymentPackageDownloadOptions;
import org.eclipse.kura.core.deployment.download.DownloadOptions;
import org.eclipse.kura.core.deployment.progress.ProgressEvent;
import org.eclipse.kura.core.deployment.progress.ProgressListener;
import org.eclipse.kura.ssl.SslManagerService;

public class GenericDownloadCountingOutputStream
extends CountingOutputStream {
    private int propResolution;
    private int propBufferSize;
    private int propConnectTimeout = 5000;
    private int propReadTimeout = 6000;
    private int propBlockDelay = 1000;
    long totalBytes;
    final DeploymentPackageDownloadOptions options;
    final SslManagerService m_sslManagerService;
    final ProgressListener pl;
    final int m_alreadyDownloaded;
    final String m_downloadURL;
    InputStream is = null;
    private long m_currentStep = 1L;
    private DownloadStatus m_downloadStatus = DownloadStatus.FAILED;

    public GenericDownloadCountingOutputStream(DownloadOptions downloadOptions) {
        super(downloadOptions.getOut());
        this.options = downloadOptions.getRequestOptions();
        this.m_sslManagerService = downloadOptions.getSslManagerService();
        this.pl = downloadOptions.getCallback();
        this.m_downloadURL = downloadOptions.getDownloadURL();
        this.m_alreadyDownloaded = downloadOptions.getAlreadyDownloaded();
    }

    public DownloadStatus getDownloadTransferStatus() {
        return this.m_downloadStatus;
    }

    public Long getDownloadTransferProgressPercentage() {
        Long percentage = (long)Math.floor(Long.valueOf(this.getByteCount()).doubleValue() / Long.valueOf(this.totalBytes).doubleValue() * 100.0);
        if (percentage < 0L) {
            return 50L;
        }
        return percentage;
    }

    public Long getTotalBytes() {
        return this.totalBytes;
    }

    public void setTotalBytes(long totalBytes) {
        this.totalBytes = totalBytes;
    }

    protected void afterWrite(int n) throws IOException {
        super.afterWrite(n);
        if (this.propResolution == 0 && this.getTotalBytes() > 0L) {
            this.propResolution = Math.round((float)this.totalBytes / 100.0f * 5.0f);
        } else if (this.propResolution == 0) {
            this.propResolution = 262144;
        }
        if (this.getByteCount() >= this.m_currentStep * (long)this.propResolution) {
            ++this.m_currentStep;
            this.postProgressEvent(this.options.getClientId(), this.getByteCount(), this.totalBytes, DownloadStatus.IN_PROGRESS, null);
        }
        try {
            Thread.sleep(this.propBlockDelay);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            e.printStackTrace();
        }
    }

    protected void postProgressEvent(String clientId, long progress, long total, DownloadStatus status, String errorMessage) {
        Long perc = this.getDownloadTransferProgressPercentage();
        this.m_downloadStatus = status;
        ProgressEvent pe = new ProgressEvent((Object)this, this.options, Long.valueOf(total).intValue(), perc.intValue(), this.getDownloadTransferStatus().getStatusString(), this.m_alreadyDownloaded);
        if (errorMessage != null) {
            pe.setExceptionMessage(errorMessage);
        }
        this.pl.progressChanged(pe);
    }

    protected void setResolution(int resolution) {
        this.propResolution = resolution;
    }

    protected void setBufferSize(int size) {
        this.propBufferSize = size;
    }

    protected void setConnectTimeout(int timeout) {
        this.propConnectTimeout = timeout;
    }

    protected void setReadTimeout(int timeout) {
        this.propReadTimeout = timeout;
    }

    protected void setBlockDelay(int delay) {
        this.propBlockDelay = delay;
    }

    protected int getResolution() {
        return this.propResolution;
    }

    protected int getBufferSize() {
        return this.propBufferSize;
    }

    protected int getConnectTimeout() {
        return this.propConnectTimeout;
    }

    protected int getPropReadTimeout() {
        return this.propReadTimeout;
    }

    protected int getPropBlockDelay() {
        return this.propBlockDelay;
    }
}

