/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web;

import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.configuration.ConfigurableComponent;
import org.eclipse.kura.crypto.CryptoService;
import org.eclipse.kura.system.SystemService;
import org.eclipse.kura.web.AuthenticationManager;
import org.eclipse.kura.web.SecureBasicHttpContext;
import org.eclipse.kura.web.server.GwtAssetServiceImpl;
import org.eclipse.kura.web.server.GwtCertificatesServiceImpl;
import org.eclipse.kura.web.server.GwtCloudConnectionServiceImpl;
import org.eclipse.kura.web.server.GwtComponentServiceImpl;
import org.eclipse.kura.web.server.GwtDeviceServiceImpl;
import org.eclipse.kura.web.server.GwtEventServiceImpl;
import org.eclipse.kura.web.server.GwtNetworkServiceImpl;
import org.eclipse.kura.web.server.GwtPackageServiceImpl;
import org.eclipse.kura.web.server.GwtSecurityServiceImpl;
import org.eclipse.kura.web.server.GwtSecurityTokenServiceImpl;
import org.eclipse.kura.web.server.GwtSettingServiceImpl;
import org.eclipse.kura.web.server.GwtSnapshotServiceImpl;
import org.eclipse.kura.web.server.GwtSslServiceImpl;
import org.eclipse.kura.web.server.GwtStatusServiceImpl;
import org.eclipse.kura.web.server.GwtWireGraphServiceImpl;
import org.eclipse.kura.web.server.servlet.ChannelServlet;
import org.eclipse.kura.web.server.servlet.DeviceSnapshotsServlet;
import org.eclipse.kura.web.server.servlet.FileServlet;
import org.eclipse.kura.web.server.servlet.SkinServlet;
import org.eclipse.kura.web.server.servlet.WiresBlinkServlet;
import org.eclipse.kura.web.server.servlet.WiresSnapshotServlet;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.EventProperties;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Console
implements ConfigurableComponent {
    private static final Logger logger = LoggerFactory.getLogger(Console.class);
    private static final String SERVLET_ALIAS_ROOT = "servlet.alias.root";
    private static final String APP_ROOT = "app.root";
    private static final String CONSOLE_PASSWORD = "console.password.value";
    private static final String CONSOLE_USERNAME = "console.username.value";
    private static String servletRoot;
    private static String appRoot;
    private static ComponentContext componentContext;
    private HttpService httpService;
    private SystemService systemService;
    private CryptoService cryptoService;
    private EventAdmin eventAdmin;
    private AuthenticationManager authMgr;
    private GwtEventServiceImpl eventService;

    public void setHttpService(HttpService httpService) {
        this.httpService = httpService;
    }

    public void unsetHttpService(HttpService httpService) {
        this.httpService = null;
    }

    public void setSystemService(SystemService systemService) {
        this.systemService = systemService;
    }

    public void unsetSystemService(SystemService systemService) {
        this.systemService = null;
    }

    public void setCryptoService(CryptoService cryptoService) {
        this.cryptoService = cryptoService;
    }

    public void unsetCryptoService(CryptoService cryptoService) {
        this.cryptoService = null;
    }

    public void setEventAdminService(EventAdmin eventAdmin) {
        this.eventAdmin = eventAdmin;
    }

    public void unsetEventAdminService(EventAdmin eventAdmin) {
        this.eventAdmin = null;
    }

    protected void activate(ComponentContext context, Map<String, Object> properties) {
        boolean webEnabled = Boolean.parseBoolean(this.systemService.getKuraWebEnabled());
        if (!webEnabled) {
            logger.info("Web interface disabled in Kura properties file.");
            return;
        }
        try {
            logger.info("activate...");
            Console.setComponentContext(context);
            Console.setServletRoot((String)properties.get(SERVLET_ALIAS_ROOT));
            Console.setAppRoot((String)properties.get(APP_ROOT));
            this.authMgr = AuthenticationManager.getInstance();
            this.updateAuthenticationManager(properties);
            this.eventService = new GwtEventServiceImpl();
            this.initHTTPService();
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("kura.version", this.systemService.getKuraVersion());
            EventProperties eventProps = new EventProperties(props);
            logger.info("postInstalledEvent() :: posting KuraConfigReadyEvent");
            this.eventAdmin.postEvent(new Event("org/eclipse/kura/configuration/ConfigEvent/READY", (Map)eventProps));
        }
        catch (Exception e) {
            logger.warn("Error Registering Web Resources", (Throwable)e);
        }
    }

    private void updateAuthenticationManager(Map<String, Object> properties) throws KuraException, NoSuchAlgorithmException, UnsupportedEncodingException {
        String registeredUsername = (String)properties.get(CONSOLE_USERNAME);
        Object value = properties.get(CONSOLE_PASSWORD);
        char[] decryptedPassword = this.cryptoService.decryptAes(((String)value).toCharArray());
        char[] propertyPassword = this.cryptoService.sha1Hash(new String(decryptedPassword)).toCharArray();
        this.authMgr.setUsername(registeredUsername);
        this.authMgr.setPassword(propertyPassword);
    }

    private static void setAppRoot(String propertiesAppRoot) {
        appRoot = propertiesAppRoot;
    }

    private static void setServletRoot(String propertiesAliasRoot) {
        servletRoot = propertiesAliasRoot;
    }

    private static void setComponentContext(ComponentContext context) {
        componentContext = context;
    }

    protected void updated(Map<String, Object> properties) {
        boolean webEnabled = Boolean.parseBoolean(this.systemService.getKuraWebEnabled());
        if (!webEnabled) {
            return;
        }
        try {
            this.updateAuthenticationManager(properties);
        }
        catch (Exception e) {
            logger.warn("Error Updating Web properties", (Throwable)e);
        }
    }

    protected void deactivate(BundleContext context) {
        logger.info("deactivate...");
        this.unregisterServlet();
    }

    private void unregisterServlet() {
        this.httpService.unregister("/");
        this.httpService.unregister(appRoot);
        this.httpService.unregister(servletRoot);
        this.httpService.unregister(String.valueOf(servletRoot) + "/status");
        this.httpService.unregister(String.valueOf(servletRoot) + "/device");
        this.httpService.unregister(String.valueOf(servletRoot) + "/network");
        this.httpService.unregister(String.valueOf(servletRoot) + "/component");
        this.httpService.unregister(String.valueOf(servletRoot) + "/package");
        this.httpService.unregister(String.valueOf(servletRoot) + "/snapshot");
        this.httpService.unregister(String.valueOf(servletRoot) + "/setting");
        this.httpService.unregister(String.valueOf(servletRoot) + "/file");
        this.httpService.unregister(String.valueOf(servletRoot) + "/device_snapshots");
        this.httpService.unregister(String.valueOf(servletRoot) + "/assetsUpDownload");
        this.httpService.unregister(String.valueOf(servletRoot) + "/skin");
        this.httpService.unregister(String.valueOf(servletRoot) + "/wires");
        this.httpService.unregister("/sse");
        this.eventService.stop();
        this.httpService.unregister(String.valueOf(servletRoot) + "/event");
    }

    public static BundleContext getBundleContext() {
        return componentContext.getBundleContext();
    }

    public static String getApplicationRoot() {
        return appRoot;
    }

    public static String getServletRoot() {
        return servletRoot;
    }

    private void initHTTPService() throws NamespaceException, ServletException {
        SecureBasicHttpContext httpCtx = new SecureBasicHttpContext(this.httpService.createDefaultHttpContext(), this.authMgr);
        this.httpService.registerResources("/", "www", (HttpContext)httpCtx);
        this.httpService.registerResources(appRoot, "www/denali.html", (HttpContext)httpCtx);
        this.httpService.registerResources(servletRoot, "www" + servletRoot, (HttpContext)httpCtx);
        this.httpService.registerServlet(String.valueOf(servletRoot) + "/xsrf", (Servlet)new GwtSecurityTokenServiceImpl(), null, (HttpContext)httpCtx);
        this.httpService.registerServlet(String.valueOf(servletRoot) + "/status", (Servlet)new GwtStatusServiceImpl(), null, (HttpContext)httpCtx);
        this.httpService.registerServlet(String.valueOf(servletRoot) + "/device", (Servlet)new GwtDeviceServiceImpl(), null, (HttpContext)httpCtx);
        this.httpService.registerServlet(String.valueOf(servletRoot) + "/network", (Servlet)new GwtNetworkServiceImpl(), null, (HttpContext)httpCtx);
        this.httpService.registerServlet(String.valueOf(servletRoot) + "/component", (Servlet)new GwtComponentServiceImpl(), null, (HttpContext)httpCtx);
        this.httpService.registerServlet(String.valueOf(servletRoot) + "/package", (Servlet)new GwtPackageServiceImpl(), null, (HttpContext)httpCtx);
        this.httpService.registerServlet(String.valueOf(servletRoot) + "/snapshot", (Servlet)new GwtSnapshotServiceImpl(), null, (HttpContext)httpCtx);
        this.httpService.registerServlet(String.valueOf(servletRoot) + "/setting", (Servlet)new GwtSettingServiceImpl(), null, (HttpContext)httpCtx);
        this.httpService.registerServlet(String.valueOf(servletRoot) + "/certificate", (Servlet)new GwtCertificatesServiceImpl(), null, (HttpContext)httpCtx);
        this.httpService.registerServlet(String.valueOf(servletRoot) + "/security", (Servlet)new GwtSecurityServiceImpl(), null, (HttpContext)httpCtx);
        this.httpService.registerServlet(String.valueOf(servletRoot) + "/file", (Servlet)new FileServlet(), null, (HttpContext)httpCtx);
        this.httpService.registerServlet(String.valueOf(servletRoot) + "/device_snapshots", (Servlet)new DeviceSnapshotsServlet(), null, (HttpContext)httpCtx);
        this.httpService.registerServlet(String.valueOf(servletRoot) + "/assetsUpDownload", (Servlet)new ChannelServlet(), null, (HttpContext)httpCtx);
        this.httpService.registerServlet(String.valueOf(servletRoot) + "/skin", (Servlet)new SkinServlet(), null, (HttpContext)httpCtx);
        this.httpService.registerServlet(String.valueOf(servletRoot) + "/ssl", (Servlet)new GwtSslServiceImpl(), null, (HttpContext)httpCtx);
        this.httpService.registerServlet(String.valueOf(servletRoot) + "/cloudservices", (Servlet)new GwtCloudConnectionServiceImpl(), null, (HttpContext)httpCtx);
        this.httpService.registerServlet(String.valueOf(servletRoot) + "/wires", (Servlet)new GwtWireGraphServiceImpl(), null, (HttpContext)httpCtx);
        this.httpService.registerServlet(String.valueOf(servletRoot) + "/wiresSnapshot", (Servlet)new WiresSnapshotServlet(), null, (HttpContext)httpCtx);
        this.httpService.registerServlet(String.valueOf(servletRoot) + "/assetservices", (Servlet)new GwtAssetServiceImpl(), null, (HttpContext)httpCtx);
        this.httpService.registerServlet("/sse", (Servlet)new WiresBlinkServlet(), null, (HttpContext)httpCtx);
        this.httpService.registerServlet(String.valueOf(servletRoot) + "/event", (Servlet)this.eventService, null, (HttpContext)httpCtx);
        this.eventService.start();
    }
}

