/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.camel.runner;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.eclipse.kura.camel.runner.ServiceDependency;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DependencyRunner<C> {
    private static final Logger logger = LoggerFactory.getLogger(DependencyRunner.class);
    private final ArrayList<ServiceDependency<?, C>> dependencies;
    private final Listener<C> listener;
    private List<ServiceDependency.Handle<C>> dependencyHandles;
    private boolean lastState = false;
    private final Runnable update = new Runnable(){

        @Override
        public void run() {
            DependencyRunner.this.update();
        }
    };
    private boolean working;

    public DependencyRunner(List<ServiceDependency<?, C>> dependencies, Listener<C> listener) {
        Objects.requireNonNull(dependencies);
        Objects.requireNonNull(listener);
        this.dependencies = new ArrayList(dependencies);
        this.listener = listener;
    }

    public void start() {
        this.working = true;
        try {
            this.dependencyHandles = new LinkedList<ServiceDependency.Handle<C>>();
            for (ServiceDependency<?, C> dep : this.dependencies) {
                this.dependencyHandles.add(dep.start(this.update));
            }
        }
        finally {
            this.working = false;
        }
        if (this.isReady()) {
            this.triggerUpdate(true);
        }
    }

    public void stop() {
        this.working = true;
        try {
            for (ServiceDependency.Handle<C> dep : this.dependencyHandles) {
                dep.stop();
            }
        }
        finally {
            this.working = false;
        }
        this.triggerUpdate(false);
    }

    private void update() {
        logger.debug("update");
        if (this.working) {
            logger.debug("update - start/stop in progress");
            return;
        }
        boolean state = this.isReady();
        this.triggerUpdate(state);
    }

    private void triggerUpdate(boolean state) {
        logger.debug("triggerUpdate - state: {}, lastState: {}", (Object)state, (Object)this.lastState);
        if (this.lastState == state) {
            return;
        }
        this.lastState = state;
        if (state) {
            this.listener.ready(Collections.unmodifiableList(this.dependencyHandles));
        } else {
            this.listener.notReady();
        }
    }

    private boolean isReady() {
        for (ServiceDependency.Handle<C> dep : this.dependencyHandles) {
            boolean satisfied = dep.isSatisfied();
            logger.debug("Dependency - {}, satisied: {}", dep, (Object)satisfied);
            if (satisfied) continue;
            return false;
        }
        return true;
    }

    public static interface Listener<C> {
        public void ready(List<ServiceDependency.Handle<C>> var1);

        public void notReady();
    }
}

