/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.cloud;

import org.eclipse.kura.message.KuraApplicationTopic;

public class KuraTopicImpl
extends KuraApplicationTopic {
    private String fullTopic;
    private String[] topicParts;
    private String prefix;
    private String accountName;
    private String deviceId;

    public KuraTopicImpl(String fullTopic) {
        this(fullTopic, "$");
    }

    public KuraTopicImpl(String fullTopic, String controlPrefix) {
        this.fullTopic = fullTopic;
        if (fullTopic.compareTo("#") == 0) {
            return;
        }
        this.topicParts = fullTopic.split("/");
        if (this.topicParts.length == 0) {
            return;
        }
        int index = 0;
        int offset = 0;
        if (this.topicParts[0].startsWith(controlPrefix)) {
            this.prefix = this.topicParts[index];
            offset += this.prefix.length() + 1;
            ++index;
        }
        if (index < this.topicParts.length) {
            this.accountName = this.topicParts[index];
            offset += this.accountName.length() + 1;
            ++index;
        }
        if (index < this.topicParts.length) {
            this.deviceId = this.topicParts[index];
            offset += this.deviceId.length() + 1;
            ++index;
        }
        if (index < this.topicParts.length) {
            this.applicationId = this.topicParts[index];
            offset += this.applicationId.length() + 1;
            ++index;
        }
        if (offset < this.fullTopic.length()) {
            this.applicationTopic = this.fullTopic.substring(offset);
        }
    }

    public String getFullTopic() {
        return this.fullTopic;
    }

    public String[] getTopicParts() {
        return this.topicParts;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public String getDeviceId() {
        return this.deviceId;
    }
}

