/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.client.ui.wires;

import com.google.gwt.cell.client.AbstractInputCell;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.ValueUpdater;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.InputElement;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.dom.client.Node;
import com.google.gwt.safecss.shared.SafeStyles;
import com.google.gwt.safecss.shared.SafeStylesUtils;
import com.google.gwt.safehtml.client.SafeHtmlTemplates;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import org.eclipse.kura.web.client.ui.wires.ValidationData;

public final class ValidationInputCell
extends AbstractInputCell<String, ValidationData> {
    private static final String CHANGE_EVENT = "change";
    private static final String NONPENDING_COLOR = "black";
    private static final String NONVALIDATED_COLOR = "red";
    private static final String NONVALIDATED_CSS_CLASS_NAME = "error-text-box";
    private static final String VALIDATED_COLOR = "blue";
    private static final String VALIDATED_CSS_CLASS_NAME = "noerror-text-box";
    private ValidationInputTemplate validationTemplate;

    public ValidationInputCell() {
        super(new String[]{CHANGE_EVENT});
        if (this.validationTemplate == null) {
            this.validationTemplate = (ValidationInputTemplate)GWT.create(ValidationInputTemplate.class);
        }
    }

    public void onBrowserEvent(Cell.Context context, Element parent, String value, NativeEvent event, ValueUpdater<String> valueUpdater) {
        super.onBrowserEvent(context, parent, (Object)value, event, valueUpdater);
        Element target = (Element)event.getEventTarget().cast();
        if (!parent.getFirstChildElement().isOrHasChild((Node)target)) {
            return;
        }
        Object key = context.getKey();
        ValidationData viewData = (ValidationData)this.getViewData(key);
        String eventType = event.getType();
        if (CHANGE_EVENT.equals(eventType)) {
            InputElement input = (InputElement)parent.getFirstChild().cast();
            input.getStyle().setColor(VALIDATED_COLOR);
            if (viewData == null) {
                viewData = new ValidationData();
                this.setViewData(key, viewData);
            }
            String newValue = input.getValue();
            viewData.setValue(newValue);
            this.finishEditing(parent, newValue, key, valueUpdater);
            if (valueUpdater != null) {
                valueUpdater.update((Object)newValue);
            }
        }
    }

    protected void onEnterKeyDown(Cell.Context context, Element parent, String value, NativeEvent event, ValueUpdater<String> valueUpdater) {
        Element target = (Element)event.getEventTarget().cast();
        if (this.getInputElement(parent).isOrHasChild((Node)target)) {
            this.finishEditing(parent, value, context.getKey(), valueUpdater);
        } else {
            super.onEnterKeyDown(context, parent, (Object)value, event, valueUpdater);
        }
    }

    public void render(Cell.Context context, String value, SafeHtmlBuilder shb) {
        boolean invalid;
        Object key = context.getKey();
        ValidationData validationViewData = (ValidationData)this.getViewData(key);
        if (validationViewData != null && validationViewData.getValue().equals(value)) {
            this.clearViewData(key);
            validationViewData = null;
        }
        if (value == null) {
            value = "";
        }
        String processingValue = validationViewData == null ? null : validationViewData.getValue();
        boolean bl = invalid = validationViewData == null ? false : validationViewData.isInvalid();
        String color = processingValue != null ? (invalid ? NONVALIDATED_COLOR : VALIDATED_COLOR) : NONPENDING_COLOR;
        SafeStyles safeColor = SafeStylesUtils.fromTrustedString((String)("color: " + color + ";"));
        shb.append(this.validationTemplate.input(processingValue != null ? processingValue : value, safeColor, invalid ? NONVALIDATED_CSS_CLASS_NAME : VALIDATED_CSS_CLASS_NAME));
    }

    static interface ValidationInputTemplate
    extends SafeHtmlTemplates {
        @SafeHtmlTemplates.Template(value="<input type=\"text\" value=\"{0}\" style=\"{1}\" class=\"{2}\" tabindex=\"-1\"/>")
        public SafeHtml input(String var1, SafeStyles var2, String var3);
    }
}

