/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.server.servlet;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.zip.ZipInputStream;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.FileCleanerCleanup;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.FileCleaningTracker;
import org.apache.commons.io.IOUtils;
import org.eclipse.kura.KuraErrorCode;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.configuration.ConfigurationService;
import org.eclipse.kura.core.configuration.XmlComponentConfigurations;
import org.eclipse.kura.deployment.agent.DeploymentAgentService;
import org.eclipse.kura.marshalling.Unmarshaller;
import org.eclipse.kura.system.SystemService;
import org.eclipse.kura.util.service.ServiceUtil;
import org.eclipse.kura.web.Console;
import org.eclipse.kura.web.server.KuraRemoteServiceServlet;
import org.eclipse.kura.web.server.servlet.UploadRequest;
import org.eclipse.kura.web.server.util.AssetConfigValidator;
import org.eclipse.kura.web.server.util.ServiceLocator;
import org.eclipse.kura.web.shared.GwtKuraErrorCode;
import org.eclipse.kura.web.shared.GwtKuraException;
import org.eclipse.kura.web.shared.model.GwtXSRFToken;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.service.metatype.MetaTypeInformation;
import org.osgi.service.metatype.MetaTypeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileServlet
extends HttpServlet {
    private static final String CANNOT_CLOSE_INPUT_STREAM = "Cannot close input stream";
    private static final String CANNOT_CLOSE_OUTPUT_STREAM = "Cannot close output stream";
    private static final String XSRF_TOKEN = "xsrfToken";
    private static final String ERROR_PARSING_THE_FILE_UPLOAD_REQUEST = "Error parsing the file upload request";
    private static final String ERROR_PARSING_QUERY_STRING = "Error parsing query string.";
    private static final String REQUEST_PATH_INFO_NOT_FOUND = "Request path info not found";
    private static final long serialVersionUID = -5016170117606322129L;
    private static Logger logger = LoggerFactory.getLogger(FileServlet.class);
    private static final String JAVA_IO_TMPDIR = "java.io.tmpdir";
    private static final String EXPECTED_1_FILE_PATTERN = "expected 1 file item but found {}";
    private static final int BUFFER = 1024;
    private static int tooBig = 0x6400000;
    private static int tooMany = 1024;
    private DiskFileItemFactory diskFileItemFactory;
    private FileCleaningTracker fileCleaningTracker;

    public void destroy() {
        super.destroy();
        logger.info("Servlet {} destroyed", (Object)this.getServletName());
        if (this.fileCleaningTracker != null) {
            logger.info("Number of temporary files tracked: {}", (Object)this.fileCleaningTracker.getTrackCount());
        }
    }

    public void init() throws ServletException {
        super.init();
        logger.info("Servlet {} initialized", (Object)this.getServletName());
        ServletContext ctx = this.getServletContext();
        this.fileCleaningTracker = FileCleanerCleanup.getFileCleaningTracker((ServletContext)ctx);
        this.getZipUploadSizeMax();
        this.getZipUploadCountMax();
        int sizeThreshold = FileServlet.getFileUploadInMemorySizeThreshold();
        File repository = new File(System.getProperty(JAVA_IO_TMPDIR));
        logger.info("DiskFileItemFactory.DEFAULT_SIZE_THRESHOLD: {}", (Object)10240);
        logger.info("DiskFileItemFactory: using size threshold of: {}", (Object)sizeThreshold);
        this.diskFileItemFactory = new DiskFileItemFactory(sizeThreshold, repository);
        this.diskFileItemFactory.setFileCleaningTracker(this.fileCleaningTracker);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setContentType("image/jpeg");
        String reqPathInfo = req.getPathInfo();
        if (reqPathInfo == null) {
            logger.error(REQUEST_PATH_INFO_NOT_FOUND);
            throw new ServletException(REQUEST_PATH_INFO_NOT_FOUND);
        }
        logger.debug("req.getRequestURI(): {}", (Object)req.getRequestURI());
        logger.debug("req.getRequestURL(): {}", (Object)req.getRequestURL());
        logger.debug("req.getPathInfo(): {}", (Object)req.getPathInfo());
        if (!reqPathInfo.startsWith("/icon")) {
            logger.error("Unknown request path info: {}", (Object)reqPathInfo);
            throw new ServletException("Unknown request path info: " + reqPathInfo);
        }
        this.doGetIcon(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setContentType("text/html");
        String reqPathInfo = req.getPathInfo();
        if (reqPathInfo == null) {
            logger.error(REQUEST_PATH_INFO_NOT_FOUND);
            throw new ServletException(REQUEST_PATH_INFO_NOT_FOUND);
        }
        logger.debug("req.getRequestURI(): {}", (Object)req.getRequestURI());
        logger.debug("req.getRequestURL(): {}", (Object)req.getRequestURL());
        logger.debug("req.getPathInfo(): {}", (Object)req.getPathInfo());
        if (reqPathInfo.startsWith("/deploy")) {
            this.doPostDeploy(req);
        } else if (reqPathInfo.equals("/configuration/snapshot")) {
            this.doPostConfigurationSnapshot(req, resp);
        } else if (reqPathInfo.equals("/command")) {
            this.doPostCommand(req, resp);
        } else if (reqPathInfo.equals("/asset")) {
            this.doPostAsset(req, resp);
        } else {
            logger.error("Unknown request path info: {}", (Object)reqPathInfo);
            throw new ServletException("Unknown request path info: " + reqPathInfo);
        }
    }

    private void doGetIcon(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String pid;
        boolean factories;
        Map<String, String> pairs;
        String queryString = req.getQueryString();
        if (queryString == null) {
            logger.error(ERROR_PARSING_QUERY_STRING);
            throw new ServletException(ERROR_PARSING_QUERY_STRING);
        }
        try {
            pairs = this.parseQueryString(queryString);
        }
        catch (UnsupportedEncodingException e) {
            logger.error(ERROR_PARSING_QUERY_STRING, (Throwable)e);
            throw new ServletException("Error parsing query string: " + e.getLocalizedMessage());
        }
        if (pairs == null || pairs.size() != 1) {
            logger.error(ERROR_PARSING_QUERY_STRING);
            throw new ServletException(ERROR_PARSING_QUERY_STRING);
        }
        if (pairs.containsKey("factoryId")) {
            factories = true;
            pid = pairs.get("factoryId");
        } else {
            factories = false;
            pid = pairs.get("pid");
        }
        if (pid != null && pid.length() > 0) {
            MetaTypeService mts;
            BundleContext ctx = Console.getBundleContext();
            Bundle[] bundles = ctx.getBundles();
            ServiceLocator locator = ServiceLocator.getInstance();
            try {
                mts = locator.getService(MetaTypeService.class);
            }
            catch (GwtKuraException e) {
                logger.error("Error getting MetaTypeService", (Throwable)e);
                throw new ServletException("Error getting MetaTypeService", (Throwable)e);
            }
            Bundle[] bundleArray = bundles;
            int n = bundles.length;
            int n2 = 0;
            while (n2 < n) {
                Bundle b = bundleArray[n2];
                MetaTypeInformation mti = mts.getMetaTypeInformation(b);
                if (mti != null) {
                    String[] ids;
                    String[] stringArray = ids = factories ? mti.getFactoryPids() : mti.getPids();
                    int n3 = ids.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String p = stringArray[n4];
                        if (p.equals(pid)) {
                            Throwable throwable = null;
                            Object var22_25 = null;
                            try (InputStream is = mti.getObjectClassDefinition(pid, null).getIcon(32);){
                                if (is == null) {
                                    logger.error("Error reading icon file.");
                                    throw new ServletException("Error reading icon file.");
                                }
                                Throwable throwable2 = null;
                                Object var25_30 = null;
                                try (ServletOutputStream os = resp.getOutputStream();){
                                    IOUtils.copy((InputStream)is, (OutputStream)os);
                                    break;
                                }
                                catch (Throwable throwable3) {
                                    if (throwable2 == null) {
                                        throwable2 = throwable3;
                                    } else if (throwable2 != throwable3) {
                                        throwable2.addSuppressed(throwable3);
                                    }
                                    throw throwable2;
                                }
                            }
                            catch (Throwable throwable4) {
                                if (throwable == null) {
                                    throwable = throwable4;
                                } else if (throwable != throwable4) {
                                    throwable.addSuppressed(throwable4);
                                }
                                throw throwable;
                            }
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        } else {
            logger.error(ERROR_PARSING_QUERY_STRING);
            throw new ServletException(ERROR_PARSING_QUERY_STRING);
        }
    }

    private Map<String, String> parseQueryString(String queryString) throws UnsupportedEncodingException {
        String[] pairs;
        HashMap<String, String> qp = new HashMap<String, String>();
        String[] stringArray = pairs = queryString.split("&");
        int n = pairs.length;
        int n2 = 0;
        while (n2 < n) {
            String p = stringArray[n2];
            int index = p.indexOf(61);
            qp.put(URLDecoder.decode(p.substring(0, index), StandardCharsets.UTF_8.name()), URLDecoder.decode(p.substring(index + 1), StandardCharsets.UTF_8.name()));
            ++n2;
        }
        return qp;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doPostCommand(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        block29: {
            upload = new UploadRequest(this.diskFileItemFactory);
            try {
                upload.parse(req);
            }
            catch (FileUploadException e) {
                FileServlet.logger.error("Error parsing the file upload request");
                throw new ServletException("Error parsing the file upload request", (Throwable)e);
            }
            formFields = upload.getFormFields();
            try {
                token = new GwtXSRFToken(formFields.get("xsrfToken"));
                KuraRemoteServiceServlet.checkXSRFToken(req, token);
            }
            catch (Exception e) {
                throw new ServletException("Security error: please retry this operation correctly.", (Throwable)e);
            }
            fileItems = null;
            is = null;
            localFolder = new File(System.getProperty("java.io.tmpdir"));
            os = null;
            try {
                try {
                    fileItems = upload.getFileItems();
                    if (!fileItems.isEmpty()) {
                        item = fileItems.get(0);
                        is = item.getInputStream();
                        bytes = IOUtils.toByteArray((InputStream)is);
                        zis = new ZipInputStream(new ByteArrayInputStream(bytes));
                        entries = 0;
                        total = 0L;
                        ze = zis.getNextEntry();
                        while (true) {
                            if (ze == null) {
                                zis.closeEntry();
                                zis.close();
                            }
                            buffer = new byte[1024];
                            expectedFilePath = localFolder.getPath() + File.separator + ze.getName();
                            fileName = this.validateFileName(expectedFilePath, localFolder.getPath());
                            newFile = new File(fileName);
                            if (ze.isDirectory()) {
                                newFile.mkdirs();
                                ze = zis.getNextEntry();
                                continue;
                            }
                            if (newFile.getParent() != null) {
                                parent = new File(newFile.getParent());
                                parent.mkdirs();
                            }
                            fos = new FileOutputStream(newFile);
                            while (true) {
                                if (total + 1024L > (long)FileServlet.tooBig || (len = zis.read(buffer)) <= 0) {
                                    fos.flush();
                                    fos.close();
                                    if (++entries <= FileServlet.tooMany) break;
                                    throw new IllegalStateException("Too many files to unzip.");
                                }
                                fos.write(buffer, 0, len);
                                total += (long)len;
                            }
                            if (total > (long)FileServlet.tooBig) {
                                throw new IllegalStateException("File being unzipped is too big.");
                            }
                            ze = zis.getNextEntry();
                        }
                    }
                }
                catch (IOException e) {
                    throw e;
                }
                catch (GwtKuraException v0) {
                    throw new ServletException("File is outside extraction target directory.");
                }
            }
            finally {
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (IOException e) {
                        FileServlet.logger.warn("Cannot close output stream", (Throwable)e);
                    }
                }
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        FileServlet.logger.warn("Cannot close input stream", (Throwable)e);
                    }
                }
                if (fileItems == null) break block29;
                ** for (fileItem : fileItems)
            }
lbl-1000:
            // 1 sources

            {
                fileItem.delete();
                continue;
            }
        }
    }

    private String validateFileName(String zipFileName, String intendedDir) throws IOException, GwtKuraException {
        File iD;
        String canonicalID;
        File zipFile = new File(zipFileName);
        String filePath = zipFile.getCanonicalPath();
        if (filePath.startsWith(canonicalID = (iD = new File(intendedDir)).getCanonicalPath())) {
            return filePath;
        }
        throw new GwtKuraException(GwtKuraErrorCode.ILLEGAL_ACCESS);
    }

    private void doPostAsset(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        UploadRequest upload = new UploadRequest(this.diskFileItemFactory);
        ArrayList<String> errors = new ArrayList<String>();
        try {
            upload.parse(req);
        }
        catch (FileUploadException fileUploadException) {
            errors.add(ERROR_PARSING_THE_FILE_UPLOAD_REQUEST);
            resp.getWriter().write("Error parsing the file upload request.");
            return;
        }
        Map<String, String> formFields = upload.getFormFields();
        try {
            GwtXSRFToken token = new GwtXSRFToken(formFields.get(XSRF_TOKEN));
            KuraRemoteServiceServlet.checkXSRFToken(req, token);
            List<FileItem> fileItems = upload.getFileItems();
            if (fileItems.size() != 1) {
                logger.error(EXPECTED_1_FILE_PATTERN, (Object)fileItems.size());
                errors.add("Security error: please retry this operation.");
                throw new ServletException();
            }
            FileItem fileItem = fileItems.get(0);
            logger.info(fileItem.getName());
            byte[] data = fileItem.get();
            String csvString = new String(data, "UTF-8");
            String assetPid = formFields.get("assetPid");
            String driverPid = formFields.get("driverPid");
            boolean doReplace = formFields.get("doReplace").trim().equalsIgnoreCase("true");
            Map<String, Object> newProps = AssetConfigValidator.get().validateCsv(csvString, driverPid, errors);
            ServiceLocator locator = ServiceLocator.getInstance();
            ConfigurationService cs = locator.getService(ConfigurationService.class);
            if (doReplace) {
                Map oldConfigProps = cs.getComponentConfiguration(assetPid).getConfigurationProperties();
                Map<String, Object> oldNonChannelProps = oldConfigProps.entrySet().stream().filter(entry -> !((String)entry.getKey()).contains("#")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                String fp = oldConfigProps.get("service.factoryPid").toString();
                cs.deleteFactoryConfiguration(assetPid, false);
                newProps.putAll(oldNonChannelProps);
                cs.createFactoryConfiguration(fp, assetPid, newProps, true);
            } else {
                cs.updateConfiguration(assetPid, newProps);
            }
            SystemService ss = locator.getService(SystemService.class);
            long delay = Long.parseLong(ss.getProperties().getProperty("console.updateConfigDelay", "5000"));
            if (delay > 0L) {
                Thread.sleep(delay);
            }
        }
        catch (InterruptedException | KuraException | GwtKuraException e) {
            logger.error("Error updating device configuration", e);
        }
        catch (ServletException ex) {
            if (!errors.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                errors.forEach(line -> {
                    StringBuilder stringBuilder2 = sb.append((String)line).append("\n");
                });
                try {
                    resp.getWriter().write(sb.toString());
                }
                catch (Exception e) {
                    logger.error("Error while writing output", (Throwable)e);
                }
            } else {
                logger.error("Servlet exception.", (Throwable)ex);
            }
        }
        catch (Exception ex2) {
            logger.warn("Security error: please retry this operation correctly.", (Throwable)ex2);
            resp.getWriter().write("Security error: please retry this operation.");
        }
    }

    private void doPostConfigurationSnapshot(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        XmlComponentConfigurations xmlConfigs;
        UploadRequest upload = new UploadRequest(this.diskFileItemFactory);
        try {
            upload.parse(req);
        }
        catch (FileUploadException e) {
            logger.error(ERROR_PARSING_THE_FILE_UPLOAD_REQUEST);
            throw new ServletException(ERROR_PARSING_THE_FILE_UPLOAD_REQUEST, (Throwable)e);
        }
        Map<String, String> formFields = upload.getFormFields();
        try {
            GwtXSRFToken token = new GwtXSRFToken(formFields.get(XSRF_TOKEN));
            KuraRemoteServiceServlet.checkXSRFToken(req, token);
        }
        catch (Exception e) {
            throw new ServletException("Security error: please retry this operation correctly.", (Throwable)e);
        }
        List<FileItem> fileItems = upload.getFileItems();
        if (fileItems.size() != 1) {
            logger.error(EXPECTED_1_FILE_PATTERN, (Object)fileItems.size());
            throw new ServletException("Wrong number of file items");
        }
        FileItem fileItem = fileItems.get(0);
        byte[] data = fileItem.get();
        String xmlString = new String(data, "UTF-8");
        try {
            xmlConfigs = this.unmarshal(xmlString, XmlComponentConfigurations.class);
        }
        catch (Exception e) {
            logger.error("Error unmarshaling device configuration", (Throwable)e);
            throw new ServletException("Error unmarshaling device configuration", (Throwable)e);
        }
        ServiceLocator locator = ServiceLocator.getInstance();
        try {
            ConfigurationService cs = locator.getService(ConfigurationService.class);
            List configImpls = xmlConfigs.getConfigurations();
            ArrayList configs = new ArrayList();
            configs.addAll(configImpls);
            cs.updateConfigurations(configs);
            SystemService ss = locator.getService(SystemService.class);
            long delay = Long.parseLong(ss.getProperties().getProperty("console.updateConfigDelay", "5000"));
            if (delay > 0L) {
                Thread.sleep(delay);
            }
        }
        catch (Exception e) {
            logger.error("Error updating device configuration: {}", (Throwable)e);
            throw new ServletException("Error updating device configuration", (Throwable)e);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void doPostDeployUpload(HttpServletRequest req) throws ServletException, IOException {
        block45: {
            block46: {
                locator = ServiceLocator.getInstance();
                try {
                    deploymentAgentService = locator.getService(DeploymentAgentService.class);
                }
                catch (GwtKuraException e) {
                    FileServlet.logger.error("Error locating DeploymentAgentService", (Throwable)e);
                    throw new ServletException("Error locating DeploymentAgentService", (Throwable)e);
                }
                isMultipart = ServletFileUpload.isMultipartContent((HttpServletRequest)req);
                if (!isMultipart) {
                    FileServlet.logger.error("Not a file upload request");
                    throw new ServletException("Not a file upload request");
                }
                upload = new UploadRequest(this.diskFileItemFactory);
                try {
                    upload.parse(req);
                }
                catch (FileUploadException e) {
                    FileServlet.logger.error("Error parsing the file upload request", (Throwable)e);
                    throw new ServletException("Error parsing the file upload request", (Throwable)e);
                }
                formFields = upload.getFormFields();
                try {
                    token = new GwtXSRFToken(formFields.get("xsrfToken"));
                    KuraRemoteServiceServlet.checkXSRFToken(req, token);
                }
                catch (Exception e) {
                    throw new ServletException("Security error: please retry this operation correctly.", (Throwable)e);
                }
                fileItems = null;
                is = null;
                localFile = null;
                os = null;
                successful = false;
                try {
                    try {
                        fileItems = upload.getFileItems();
                        if (fileItems.size() != 1) {
                            FileServlet.logger.error("expected 1 file item but found {}", (Object)fileItems.size());
                            throw new ServletException("Wrong number of file items");
                        }
                        item = fileItems.get(0);
                        filename = item.getName();
                        is = item.getInputStream();
                        filePath = String.valueOf(System.getProperty("java.io.tmpdir")) + File.separator + filename;
                        localFile = new File(filePath);
                        if (localFile.exists() && localFile.delete()) {
                            FileServlet.logger.error("Cannot delete file: {}", (Object)filePath);
                            throw new ServletException("Cannot delete file: " + filePath);
                        }
                        try {
                            localFile.createNewFile();
                            localFile.deleteOnExit();
                        }
                        catch (IOException e) {
                            FileServlet.logger.error("Cannot create file: {}", (Object)filePath, (Object)e);
                            throw new ServletException("Cannot create file: " + filePath);
                        }
                        try {
                            os = new FileOutputStream(localFile);
                        }
                        catch (FileNotFoundException e) {
                            FileServlet.logger.error("Cannot find file: {}", (Object)filePath, (Object)e);
                            throw new ServletException("Cannot find file: " + filePath, (Throwable)e);
                        }
                        FileServlet.logger.info("Copying uploaded package file to file: {}", (Object)filePath);
                        try {
                            IOUtils.copy((InputStream)is, (OutputStream)os);
                        }
                        catch (IOException e) {
                            FileServlet.logger.error("Failed to copy deployment package file: {}", (Object)filename, (Object)e);
                            throw new ServletException("Failed to copy deployment package file: " + filename, (Throwable)e);
                        }
                        try {
                            os.close();
                        }
                        catch (IOException e) {
                            FileServlet.logger.warn("Cannot close output stream", (Throwable)e);
                        }
                        url = localFile.toURI().toURL();
                        sUrl = url.toString();
                        FileServlet.logger.info("Installing package...");
                        try {
                            deploymentAgentService.installDeploymentPackageAsync(sUrl);
                            successful = true;
                            break block45;
                        }
                        catch (Exception e) {
                            FileServlet.logger.error("Package installation failed", (Throwable)e);
                            throw new ServletException("Package installation failed", (Throwable)e);
                        }
                    }
                    catch (IOException e) {
                        throw e;
                    }
                    catch (ServletException e) {
                        throw e;
                    }
                }
                catch (Throwable var18_27) {
                    if (os != null) {
                        try {
                            os.close();
                        }
                        catch (IOException e) {
                            FileServlet.logger.warn("Cannot close output stream", (Throwable)e);
                        }
                    }
                    if (localFile != null && !successful) {
                        try {
                            localFile.delete();
                        }
                        catch (Exception v0) {
                            FileServlet.logger.warn("Cannot delete file");
                        }
                    }
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException e) {
                            FileServlet.logger.warn("Cannot close input stream", (Throwable)e);
                        }
                    }
                    if (fileItems == null) break block46;
                    ** for (fileItem : fileItems)
                }
lbl-1000:
                // 1 sources

                {
                    fileItem.delete();
                    continue;
                }
            }
            throw var18_27;
        }
        if (os != null) {
            try {
                os.close();
            }
            catch (IOException e) {
                FileServlet.logger.warn("Cannot close output stream", (Throwable)e);
            }
        }
        if (localFile != null && !successful) {
            try {
                localFile.delete();
            }
            catch (Exception v1) {
                FileServlet.logger.warn("Cannot delete file");
            }
        }
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException e) {
                FileServlet.logger.warn("Cannot close input stream", (Throwable)e);
            }
        }
        if (fileItems != null) {
            for (FileItem fileItem : fileItems) {
                fileItem.delete();
            }
        }
    }

    private void doPostDeploy(HttpServletRequest req) throws ServletException, IOException {
        DeploymentAgentService deploymentAgentService;
        ServiceLocator locator = ServiceLocator.getInstance();
        try {
            deploymentAgentService = locator.getService(DeploymentAgentService.class);
        }
        catch (GwtKuraException e) {
            logger.error("Error locating DeploymentAgentService", (Throwable)e);
            throw new ServletException("Error locating DeploymentAgentService", (Throwable)e);
        }
        String reqPathInfo = req.getPathInfo();
        if (reqPathInfo.endsWith("url")) {
            String packageDownloadUrl = req.getParameter("packageUrl");
            if (packageDownloadUrl == null) {
                logger.error("Deployment package URL parameter missing");
                throw new ServletException("Deployment package URL parameter missing");
            }
            String tokenId = req.getParameter(XSRF_TOKEN);
            try {
                GwtXSRFToken token = new GwtXSRFToken(tokenId);
                KuraRemoteServiceServlet.checkXSRFToken(req, token);
            }
            catch (Exception e) {
                throw new ServletException("Security error: please retry this operation correctly.", (Throwable)e);
            }
            try {
                logger.info("Installing package...");
                deploymentAgentService.installDeploymentPackageAsync(packageDownloadUrl);
            }
            catch (Exception e) {
                logger.error("Failed to install package at URL {}", (Object)packageDownloadUrl, (Object)e);
                throw new ServletException("Error installing deployment package", (Throwable)e);
            }
        }
        if (reqPathInfo.endsWith("upload")) {
            this.doPostDeployUpload(req);
        } else {
            logger.error("Unsupported package deployment request");
            throw new ServletException("Unsupported package deployment request");
        }
    }

    private void getZipUploadSizeMax() {
        ServiceLocator locator = ServiceLocator.getInstance();
        try {
            int sizeInBytes;
            SystemService systemService = locator.getService(SystemService.class);
            int sizeInMB = systemService.getFileCommandZipMaxUploadSize();
            tooBig = sizeInBytes = sizeInMB * 1024 * 1024;
        }
        catch (GwtKuraException e) {
            logger.error("Error locating SystemService", (Throwable)e);
        }
    }

    private void getZipUploadCountMax() {
        ServiceLocator locator = ServiceLocator.getInstance();
        try {
            SystemService systemService = locator.getService(SystemService.class);
            tooMany = systemService.getFileCommandZipMaxUploadNumber();
        }
        catch (GwtKuraException e) {
            logger.error("Error locating SystemService", (Throwable)e);
        }
    }

    static long getFileUploadSizeMax() {
        ServiceLocator locator = ServiceLocator.getInstance();
        long sizeMax = -1L;
        try {
            SystemService systemService = locator.getService(SystemService.class);
            sizeMax = Long.parseLong(systemService.getProperties().getProperty("file.upload.size.max", "-1"));
        }
        catch (GwtKuraException e) {
            logger.error("Error locating SystemService", (Throwable)e);
        }
        return sizeMax;
    }

    private static int getFileUploadInMemorySizeThreshold() {
        ServiceLocator locator = ServiceLocator.getInstance();
        int sizeThreshold = 10240;
        try {
            SystemService systemService = locator.getService(SystemService.class);
            sizeThreshold = Integer.parseInt(systemService.getProperties().getProperty("file.upload.in.memory.size.threshold", String.valueOf(10240)));
        }
        catch (GwtKuraException e) {
            logger.error("Error locating SystemService", (Throwable)e);
        }
        return sizeThreshold;
    }

    private ServiceReference<Unmarshaller>[] getXmlUnmarshallers() {
        String filterString = String.format("(&(kura.service.pid=%s))", "org.eclipse.kura.xml.marshaller.unmarshaller.provider");
        return ServiceUtil.getServiceReferences((BundleContext)FrameworkUtil.getBundle(FileServlet.class).getBundleContext(), Unmarshaller.class, (String)filterString);
    }

    private void ungetServiceReferences(ServiceReference<?>[] refs) {
        ServiceUtil.ungetServiceReferences((BundleContext)FrameworkUtil.getBundle(FileServlet.class).getBundleContext(), refs);
    }

    protected <T> T unmarshal(String xmlString, Class<T> clazz) throws KuraException {
        Object result;
        block7: {
            result = null;
            ServiceReference<Unmarshaller>[] unmarshallerSRs = this.getXmlUnmarshallers();
            try {
                try {
                    ServiceReference<Unmarshaller>[] serviceReferenceArray = unmarshallerSRs;
                    int n = unmarshallerSRs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ServiceReference<Unmarshaller> unmarshallerSR = serviceReferenceArray[n2];
                        Unmarshaller unmarshaller = (Unmarshaller)FrameworkUtil.getBundle(FileServlet.class).getBundleContext().getService(unmarshallerSR);
                        result = unmarshaller.unmarshal(xmlString, clazz);
                        ++n2;
                    }
                }
                catch (Exception exception) {
                    logger.warn("Failed to extract persisted configuration.");
                    this.ungetServiceReferences(unmarshallerSRs);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                this.ungetServiceReferences(unmarshallerSRs);
                throw throwable;
            }
            this.ungetServiceReferences(unmarshallerSRs);
        }
        if (result == null) {
            throw new KuraException(KuraErrorCode.DECODER_ERROR);
        }
        return (T)result;
    }
}

