/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.asset.provider;

import java.util.List;
import org.eclipse.kura.asset.provider.AssetConstants;
import org.eclipse.kura.channel.ChannelType;
import org.eclipse.kura.core.configuration.metatype.Tad;
import org.eclipse.kura.core.configuration.metatype.Toption;
import org.eclipse.kura.core.configuration.metatype.Tscalar;
import org.eclipse.kura.driver.ChannelDescriptor;
import org.eclipse.kura.type.DataType;
import org.eclipse.kura.util.collection.CollectionUtil;

public class BaseChannelDescriptor
implements ChannelDescriptor {
    private static final BaseChannelDescriptor instance = new BaseChannelDescriptor();
    protected final List<Tad> defaultElements = CollectionUtil.newArrayList();

    protected static void addOptions(Tad target, Enum<?>[] values) {
        List options = target.getOption();
        Enum<?>[] enumArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            Enum<?> value = enumArray[n2];
            String name = value.name();
            Toption option = new Toption();
            option.setLabel(name);
            option.setValue(name);
            options.add(option);
            ++n2;
        }
    }

    protected BaseChannelDescriptor() {
        Tad enabled = new Tad();
        enabled.setId(AssetConstants.ENABLED.value());
        enabled.setName(AssetConstants.ENABLED.value().substring(1));
        enabled.setType(Tscalar.BOOLEAN);
        enabled.setDefault("true");
        enabled.setDescription("Determines if the channel is enabled or not");
        enabled.setCardinality(Integer.valueOf(0));
        enabled.setRequired(Boolean.valueOf(true));
        this.defaultElements.add(enabled);
        Tad name = new Tad();
        name.setId(AssetConstants.NAME.value());
        name.setName(AssetConstants.NAME.value().substring(1));
        name.setType(Tscalar.STRING);
        name.setDefault("Channel-1");
        name.setDescription("Name of the Channel");
        name.setCardinality(Integer.valueOf(0));
        name.setRequired(Boolean.valueOf(true));
        this.defaultElements.add(name);
        Tad type = new Tad();
        type.setName(AssetConstants.TYPE.value().substring(1));
        type.setId(AssetConstants.TYPE.value());
        type.setDescription("Type of the channel");
        type.setType(Tscalar.STRING);
        type.setRequired(Boolean.valueOf(true));
        type.setDefault(ChannelType.READ.name());
        BaseChannelDescriptor.addOptions(type, ChannelType.values());
        this.defaultElements.add(type);
        Tad valueType = new Tad();
        valueType.setName(AssetConstants.VALUE_TYPE.value().substring(1));
        valueType.setId(AssetConstants.VALUE_TYPE.value());
        valueType.setDescription("Value type of the channel");
        valueType.setType(Tscalar.STRING);
        valueType.setRequired(Boolean.valueOf(true));
        valueType.setDefault(DataType.INTEGER.name());
        BaseChannelDescriptor.addOptions(valueType, DataType.values());
        this.defaultElements.add(valueType);
    }

    public Object getDescriptor() {
        return this.defaultElements;
    }

    public static BaseChannelDescriptor get() {
        return instance;
    }
}

