/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.cm;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.TreeSet;
import org.eclipse.equinox.internal.cm.ConfigurationDictionary;
import org.eclipse.equinox.internal.cm.ConfigurationImpl;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.ConfigurationPlugin;
import org.osgi.util.tracker.ServiceTracker;

public class PluginManager {
    private final PluginTracker pluginTracker;
    static final Integer ZERO = 0;

    public PluginManager(BundleContext context) {
        this.pluginTracker = new PluginTracker(context);
    }

    public void start() {
        this.pluginTracker.open();
    }

    public void stop() {
        this.pluginTracker.close();
    }

    public Dictionary<String, Object> modifyConfiguration(ServiceReference<?> managedReference, ConfigurationImpl config) {
        Dictionary<String, Object> properties = config.getProperties();
        if (properties == null) {
            return null;
        }
        ServiceReference<ConfigurationPlugin>[] serviceReferenceArray = this.pluginTracker.getServiceReferences();
        int n = serviceReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            block10: {
                ConfigurationPlugin plugin;
                ServiceReference<ConfigurationPlugin> reference;
                block9: {
                    reference = serviceReferenceArray[n2];
                    Collection<Object> pids = this.getStringProperty(reference.getProperty("cm.target"));
                    if (pids == null) break block9;
                    String pid = config.getFactoryPid();
                    if (pid == null) {
                        pid = config.getPid();
                    }
                    if (!pids.contains(pid)) break block10;
                }
                if ((plugin = (ConfigurationPlugin)this.pluginTracker.getService(reference)) != null) {
                    int rank = PluginManager.getRank(reference);
                    if (rank < 0 || rank > 1000) {
                        plugin.modifyConfiguration(managedReference, (Dictionary)((ConfigurationDictionary)properties).copy());
                    } else {
                        plugin.modifyConfiguration(managedReference, properties);
                        ConfigurationImpl.fileAutoProperties(properties, config, false, false);
                    }
                }
            }
            ++n2;
        }
        return properties;
    }

    private Collection<Object> getStringProperty(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return Collections.singleton(value);
        }
        if (value instanceof String[]) {
            return Arrays.asList((Object[])value);
        }
        if (value instanceof Collection) {
            return (Collection)value;
        }
        return null;
    }

    static Integer getRank(ServiceReference<ConfigurationPlugin> ref) {
        Object ranking = ref.getProperty("service.cmRanking");
        if (ranking == null || !(ranking instanceof Integer)) {
            return ZERO;
        }
        return (Integer)ranking;
    }

    private static class PluginTracker
    extends ServiceTracker<ConfigurationPlugin, ConfigurationPlugin> {
        private TreeSet<ServiceReference<ConfigurationPlugin>> serviceReferences = new TreeSet<ServiceReference<ConfigurationPlugin>>(new Comparator<ServiceReference<ConfigurationPlugin>>(){

            @Override
            public int compare(ServiceReference<ConfigurationPlugin> s1, ServiceReference<ConfigurationPlugin> s2) {
                int rankCompare = PluginManager.getRank(s1).compareTo(PluginManager.getRank(s2));
                if (rankCompare != 0) {
                    return rankCompare;
                }
                return -s1.compareTo(s2);
            }
        });

        public PluginTracker(BundleContext context) {
            super(context, ConfigurationPlugin.class.getName(), null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ServiceReference<ConfigurationPlugin>[] getServiceReferences() {
            TreeSet<ServiceReference<ConfigurationPlugin>> treeSet = this.serviceReferences;
            synchronized (treeSet) {
                return this.serviceReferences.toArray(new ServiceReference[this.serviceReferences.size()]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ConfigurationPlugin addingService(ServiceReference<ConfigurationPlugin> reference) {
            TreeSet<ServiceReference<ConfigurationPlugin>> treeSet = this.serviceReferences;
            synchronized (treeSet) {
                this.serviceReferences.add(reference);
            }
            return (ConfigurationPlugin)this.context.getService(reference);
        }

        public void modifiedService(ServiceReference<ConfigurationPlugin> reference, ConfigurationPlugin service) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removedService(ServiceReference<ConfigurationPlugin> reference, ConfigurationPlugin service) {
            TreeSet<ServiceReference<ConfigurationPlugin>> treeSet = this.serviceReferences;
            synchronized (treeSet) {
                this.serviceReferences.remove(reference);
            }
            this.context.ungetService(reference);
        }
    }
}

