/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.deployment.download.impl;

import java.text.ParseException;
import org.eclipse.kura.message.KuraPayload;

public class KuraNotifyPayload
extends KuraPayload {
    public static final String METRIC_CLIENT_ID = "client.id";
    public static final String METRIC_TRANSFER_SIZE = "dp.download.size";
    public static final String METRIC_TRANSFER_PROGRESS = "dp.download.progress";
    public static final String METRIC_TRANSFER_STATUS = "dp.download.status";
    public static final String METRIC_JOB_ID = "job.id";
    public static final String METRIC_ERROR_MESSAGE = "dp.download.error.message";
    public static final String METRIC_TRANSFER_INDEX = "dp.download.index";

    public KuraNotifyPayload(String clientId) {
        this.addMetric(METRIC_CLIENT_ID, clientId);
    }

    public KuraNotifyPayload(KuraPayload kuraPayload) {
        for (String name : kuraPayload.metricNames()) {
            Object value = kuraPayload.getMetric(name);
            this.addMetric(name, value);
        }
        this.setBody(kuraPayload.getBody());
        this.setPosition(kuraPayload.getPosition());
        this.setTimestamp(kuraPayload.getTimestamp());
    }

    public void setClientId(String requesterClientId) {
        this.addMetric(METRIC_CLIENT_ID, requesterClientId);
    }

    public String getClientId() {
        return (String)this.getMetric(METRIC_CLIENT_ID);
    }

    public void setTransferSize(int trasnferSize) {
        this.addMetric(METRIC_TRANSFER_SIZE, trasnferSize);
    }

    public int getTransferSize() {
        return (Integer)this.getMetric(METRIC_TRANSFER_SIZE);
    }

    public void setTransferProgress(int transferProgress) {
        this.addMetric(METRIC_TRANSFER_PROGRESS, transferProgress);
    }

    public int getTransferProgress() {
        return (Integer)this.getMetric(METRIC_TRANSFER_PROGRESS);
    }

    public void setTransferStatus(String transferStatus) {
        this.addMetric(METRIC_TRANSFER_STATUS, transferStatus);
    }

    public String getTransferStatus() {
        return (String)this.getMetric(METRIC_TRANSFER_STATUS);
    }

    public static KuraNotifyPayload buildFromKuraPayload(KuraPayload payload) throws ParseException {
        if (payload.getMetric(METRIC_CLIENT_ID) == null) {
            throw new ParseException("Not a valid notify payload", 0);
        }
        return new KuraNotifyPayload(payload);
    }

    public void setJobId(long jobId) {
        this.addMetric(METRIC_JOB_ID, jobId);
    }

    public Long getJobId() {
        return (Long)this.getMetric(METRIC_JOB_ID);
    }

    public void setErrorMessage(String errorMessage) {
        this.addMetric(METRIC_ERROR_MESSAGE, errorMessage);
    }

    public String getErrorMessage() {
        return (String)this.getMetric(METRIC_ERROR_MESSAGE);
    }

    public void setTransferIndex(int transferIndex) {
        this.addMetric(METRIC_TRANSFER_INDEX, transferIndex);
    }

    public Integer getMissingDownloads() {
        return (Integer)this.getMetric(METRIC_TRANSFER_INDEX);
    }
}

