/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.spi.persistence;

import io.moquette.proto.MQTTException;
import io.moquette.server.config.IConfig;
import io.moquette.spi.IMessagesStore;
import io.moquette.spi.ISessionsStore;
import io.moquette.spi.persistence.MapDBMessagesStore;
import io.moquette.spi.persistence.MapDBSessionsStore;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.mapdb.DB;
import org.mapdb.DBMaker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapDBPersistentStore {
    private static final Logger LOG = LoggerFactory.getLogger(MapDBPersistentStore.class);
    private DB m_db;
    private final String m_storePath;
    private final int m_autosaveInterval;
    protected final ScheduledExecutorService m_scheduler = Executors.newScheduledThreadPool(1);

    public MapDBPersistentStore(IConfig props) {
        this.m_storePath = props.getProperty("persistent_store", "");
        this.m_autosaveInterval = Integer.parseInt(props.getProperty("autosave_interval", "30"));
    }

    public IMessagesStore messagesStore() {
        MapDBMessagesStore msgStore = new MapDBMessagesStore(this.m_db);
        msgStore.initStore();
        return msgStore;
    }

    public ISessionsStore sessionsStore(IMessagesStore msgStore) {
        MapDBSessionsStore sessionsStore = new MapDBSessionsStore(this.m_db, msgStore);
        sessionsStore.initStore();
        return sessionsStore;
    }

    public void initStore() {
        if (this.m_storePath == null || this.m_storePath.isEmpty()) {
            this.m_db = DBMaker.newMemoryDB().make();
        } else {
            File tmpFile;
            try {
                tmpFile = new File(this.m_storePath);
                boolean fileNewlyCreated = tmpFile.createNewFile();
                LOG.info("Starting with {} [{}] db file", (Object)(fileNewlyCreated ? "fresh" : "existing"), (Object)this.m_storePath);
            }
            catch (IOException ex) {
                LOG.error(null, ex);
                throw new MQTTException("Can't create temp file for subscriptions storage [" + this.m_storePath + "]", ex);
            }
            this.m_db = DBMaker.newFileDB(tmpFile).make();
        }
        this.m_scheduler.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                MapDBPersistentStore.this.m_db.commit();
            }
        }, this.m_autosaveInterval, this.m_autosaveInterval, TimeUnit.SECONDS);
    }

    public void close() {
        if (this.m_db.isClosed()) {
            LOG.debug("already closed");
            return;
        }
        this.m_db.commit();
        this.m_db.close();
        LOG.debug("closed disk storage");
        this.m_scheduler.shutdown();
        LOG.debug("Persistence commit scheduler is shutdown");
    }

    public static class PersistentSession
    implements Serializable {
        public final boolean cleanSession;

        public PersistentSession(boolean cleanSession) {
            this.cleanSession = cleanSession;
        }
    }
}

