/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.keystore.request.handler;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import org.eclipse.kura.KuraErrorCode;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.cloudconnection.message.KuraMessage;
import org.eclipse.kura.cloudconnection.request.RequestHandler;
import org.eclipse.kura.cloudconnection.request.RequestHandlerContext;
import org.eclipse.kura.cloudconnection.request.RequestHandlerMessageConstants;
import org.eclipse.kura.cloudconnection.request.RequestHandlerRegistry;
import org.eclipse.kura.core.keystore.util.CertificateInfo;
import org.eclipse.kura.core.keystore.util.CsrInfo;
import org.eclipse.kura.core.keystore.util.EntryInfo;
import org.eclipse.kura.core.keystore.util.KeyPairInfo;
import org.eclipse.kura.core.keystore.util.KeystoreRemoteService;
import org.eclipse.kura.marshalling.Unmarshaller;
import org.eclipse.kura.message.KuraPayload;
import org.eclipse.kura.message.KuraResponsePayload;
import org.eclipse.kura.util.service.ServiceUtil;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeystoreServiceRequestHandlerV1
extends KeystoreRemoteService
implements RequestHandler {
    private static final Logger logger = LoggerFactory.getLogger(KeystoreServiceRequestHandlerV1.class);
    public static final String APP_ID = "KEYS-V1";
    private static final String NONE_RESOURCE_FOUND_MESSAGE = "Resource not found";
    private static final String KEYSTORES = "keystores";
    private static final String ENTRIES = "entries";
    private static final String ENTRY = "entry";
    private static final String CSR = "csr";
    private static final String CERTIFICATE = "certificate";
    private static final String KEYPAIR = "keypair";

    public void setRequestHandlerRegistry(RequestHandlerRegistry requestHandlerRegistry) {
        try {
            requestHandlerRegistry.registerRequestHandler(APP_ID, (RequestHandler)this);
        }
        catch (KuraException kuraException) {
            logger.info("Unable to register cloudlet {} in {}", (Object)APP_ID, (Object)requestHandlerRegistry.getClass().getName());
        }
    }

    public void unsetRequestHandlerRegistry(RequestHandlerRegistry requestHandlerRegistry) {
        try {
            requestHandlerRegistry.unregister(APP_ID);
        }
        catch (KuraException kuraException) {
            logger.info("Unable to register cloudlet {} in {}", (Object)APP_ID, (Object)requestHandlerRegistry.getClass().getName());
        }
    }

    public KuraMessage doGet(RequestHandlerContext context, KuraMessage reqMessage) throws KuraException {
        List<String> resourcePath = KeystoreServiceRequestHandlerV1.extractResourcePath(reqMessage);
        KuraPayload reqPayload = reqMessage.getPayload();
        if (resourcePath.isEmpty()) {
            logger.error(NONE_RESOURCE_FOUND_MESSAGE);
            throw new KuraException(KuraErrorCode.BAD_REQUEST);
        }
        if (resourcePath.size() == 1 && resourcePath.get(0).equals(KEYSTORES)) {
            return KeystoreServiceRequestHandlerV1.jsonResponse(this.listKeystoresInternal());
        }
        if (resourcePath.size() == 2 && resourcePath.get(0).equals(KEYSTORES) && resourcePath.get(1).equals(ENTRIES)) {
            return this.doGetEntries(reqPayload);
        }
        if (resourcePath.size() == 3 && resourcePath.get(0).equals(KEYSTORES) && resourcePath.get(1).equals(ENTRIES) && resourcePath.get(2).equals(ENTRY)) {
            EntryInfo request = this.unmarshal(new String(reqPayload.getBody(), StandardCharsets.UTF_8), EntryInfo.class);
            String keystoreServicePid = request.getKeystoreServicePid();
            String keyAlias = request.getAlias();
            if (!Objects.isNull(keystoreServicePid) && !Objects.isNull(keyAlias)) {
                return KeystoreServiceRequestHandlerV1.jsonResponse(this.getKeyInternal(keystoreServicePid, keyAlias));
            }
            throw new KuraException(KuraErrorCode.BAD_REQUEST);
        }
        throw new KuraException(KuraErrorCode.BAD_REQUEST);
    }

    private KuraMessage doGetEntries(KuraPayload reqPayload) {
        byte[] body = reqPayload.getBody();
        if (Objects.isNull(body) || body.length == 0) {
            return KeystoreServiceRequestHandlerV1.jsonResponse(this.getKeysInternal());
        }
        EntryInfo request = this.unmarshal(new String(reqPayload.getBody(), StandardCharsets.UTF_8), EntryInfo.class);
        String keystoreServicePid = request.getKeystoreServicePid();
        String keyAlias = request.getAlias();
        if (Objects.isNull(keystoreServicePid) && !Objects.isNull(keyAlias)) {
            return KeystoreServiceRequestHandlerV1.jsonResponse(this.getKeysByAliasInternal(keyAlias));
        }
        return KeystoreServiceRequestHandlerV1.jsonResponse(this.getKeysByPidInternal(keystoreServicePid));
    }

    public KuraMessage doPost(RequestHandlerContext context, KuraMessage reqMessage) throws KuraException {
        List<String> resourcePath = KeystoreServiceRequestHandlerV1.extractResourcePath(reqMessage);
        KuraPayload reqPayload = reqMessage.getPayload();
        if (resourcePath.size() != 3 || reqPayload.getBody() == null || reqPayload.getBody().length == 0 || !resourcePath.get(0).equals(KEYSTORES) || !resourcePath.get(1).equals(ENTRIES)) {
            logger.error(NONE_RESOURCE_FOUND_MESSAGE);
            throw new KuraException(KuraErrorCode.BAD_REQUEST);
        }
        if (resourcePath.get(2).equals(CSR)) {
            return this.doPostCsr(reqPayload);
        }
        if (resourcePath.get(2).equals(CERTIFICATE)) {
            String body = new String(reqPayload.getBody(), StandardCharsets.UTF_8);
            CertificateInfo certificateInfo = this.unmarshal(body, CertificateInfo.class);
            this.storeTrustedCertificateEntryInternal(certificateInfo);
            return new KuraMessage((KuraPayload)new KuraResponsePayload(200));
        }
        if (resourcePath.get(2).equals(KEYPAIR)) {
            String body = new String(reqPayload.getBody(), StandardCharsets.UTF_8);
            KeyPairInfo keyPairInfo = this.unmarshal(body, KeyPairInfo.class);
            this.storeKeyPairEntryInternal(keyPairInfo);
            return new KuraMessage((KuraPayload)new KuraResponsePayload(200));
        }
        throw new KuraException(KuraErrorCode.BAD_REQUEST);
    }

    private KuraMessage doPostCsr(KuraPayload reqPayload) {
        String body = new String(reqPayload.getBody(), StandardCharsets.UTF_8);
        CsrInfo csrInfo = this.unmarshal(body, CsrInfo.class);
        return KeystoreServiceRequestHandlerV1.jsonResponse(this.getCSRInternal(csrInfo));
    }

    public KuraMessage doDel(RequestHandlerContext context, KuraMessage reqMessage) throws KuraException {
        List<String> resourcePath = KeystoreServiceRequestHandlerV1.extractResourcePath(reqMessage);
        KuraPayload reqPayload = reqMessage.getPayload();
        if (resourcePath.size() != 2 || reqPayload.getBody() == null || reqPayload.getBody().length == 0 || !resourcePath.get(0).equals(KEYSTORES)) {
            logger.error(NONE_RESOURCE_FOUND_MESSAGE);
            throw new KuraException(KuraErrorCode.BAD_REQUEST);
        }
        if (resourcePath.get(1).equals(ENTRIES)) {
            String body = new String(reqPayload.getBody(), StandardCharsets.UTF_8);
            EntryInfo request = this.unmarshal(body, EntryInfo.class);
            if (request != null) {
                this.deleteKeyEntryInternal(request.getKeystoreServicePid(), request.getAlias());
                return new KuraMessage((KuraPayload)new KuraResponsePayload(200));
            }
            throw new KuraException(KuraErrorCode.BAD_REQUEST);
        }
        throw new KuraException(KuraErrorCode.BAD_REQUEST);
    }

    private static final List<String> extractResourcePath(KuraMessage message) throws KuraException {
        Object requestObject = message.getProperties().get(RequestHandlerMessageConstants.ARGS_KEY.value());
        if (requestObject instanceof List) {
            return (List)requestObject;
        }
        throw new KuraException(KuraErrorCode.BAD_REQUEST);
    }

    private static final KuraMessage jsonResponse(Object response) {
        KuraResponsePayload responsePayload = new KuraResponsePayload(200);
        Gson gson = new GsonBuilder().disableHtmlEscaping().create();
        responsePayload.setBody(gson.toJson(response).getBytes(StandardCharsets.UTF_8));
        return new KuraMessage((KuraPayload)responsePayload);
    }

    private ServiceReference<Unmarshaller>[] getJsonUnmarshallers() {
        String filterString = String.format("(&(kura.service.pid=%s))", "org.eclipse.kura.json.marshaller.unmarshaller.provider");
        return ServiceUtil.getServiceReferences((BundleContext)this.bundleContext, Unmarshaller.class, (String)filterString);
    }

    private void ungetServiceReferences(ServiceReference<?>[] refs) {
        ServiceUtil.ungetServiceReferences((BundleContext)this.bundleContext, refs);
    }

    protected <T> T unmarshal(String jsonString, Class<T> clazz) {
        Object result;
        block7: {
            result = null;
            ServiceReference<Unmarshaller>[] unmarshallerSRs = this.getJsonUnmarshallers();
            try {
                try {
                    ServiceReference<Unmarshaller>[] serviceReferenceArray = unmarshallerSRs;
                    int n = unmarshallerSRs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ServiceReference<Unmarshaller> unmarshallerSR = serviceReferenceArray[n2];
                        Unmarshaller unmarshaller = (Unmarshaller)this.bundleContext.getService(unmarshallerSR);
                        result = unmarshaller.unmarshal(jsonString, clazz);
                        if (result == null) {
                            ++n2;
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception exception) {
                    logger.warn("Failed to marshal configuration.");
                    this.ungetServiceReferences(unmarshallerSRs);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                this.ungetServiceReferences(unmarshallerSRs);
                throw throwable;
            }
            this.ungetServiceReferences(unmarshallerSRs);
        }
        return (T)result;
    }
}

