/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel;

import org.eclipse.lemminx.AbstractCacheBasedTest;
import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.extensions.contentmodel.participants.XMLSyntaxErrorCode;
import org.eclipse.lemminx.extensions.contentmodel.settings.ContentModelSettings;
import org.eclipse.lemminx.extensions.contentmodel.settings.NamespacesEnabled;
import org.eclipse.lemminx.extensions.contentmodel.settings.SchemaEnabled;
import org.eclipse.lemminx.extensions.contentmodel.settings.XMLNamespacesSettings;
import org.eclipse.lemminx.services.extensions.diagnostics.IXMLErrorCode;
import org.eclipse.lemminx.settings.EnforceQuoteStyle;
import org.eclipse.lemminx.settings.QuoteStyle;
import org.eclipse.lemminx.settings.SharedSettings;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Diagnostic;
import org.junit.jupiter.api.Test;

public class XMLSyntaxDiagnosticsTest
extends AbstractCacheBasedTest {
    @Test
    public void testAttributeNotUnique() throws Exception {
        String xml = "<InstdAmt Ccy=\"JPY\" Ccy=\"JPY\" >10000000</InstdAmt>";
        XMLAssert.testDiagnosticsFor(xml, XMLAssert.d(0, 10, 0, 13, (IXMLErrorCode)XMLSyntaxErrorCode.AttributeNotUnique));
    }

    @Test
    public void testAttributeNotUnique2() throws Exception {
        String xml = "<a attr=\"\" attr=\"\" attr2=\"\" />";
        XMLAssert.testDiagnosticsFor(xml, XMLAssert.d(0, 3, 0, 7, (IXMLErrorCode)XMLSyntaxErrorCode.AttributeNotUnique));
    }

    @Test
    public void testAttributeNSNotUnique() throws Exception {
        String xml = "<Document xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns=\"urn:iso:std:iso:20022:tech:xsd:pain.001.001.03\"\r\n\r\nxmlns=\"urn:iso:std:iso:20022:tech:xsd:pain.001.001.03\"> ";
        XMLAssert.testDiagnosticsFor(xml, XMLAssert.d(0, 64, 0, 69, (IXMLErrorCode)XMLSyntaxErrorCode.AttributeNSNotUnique));
    }

    @Test
    public void testAttributeNSNotUnique2() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\r\n<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" \r\n\txmlns:tns=\"http://camel.apache.org/schema/spring\"\r\n\txmlns:tns=\"http://camel.apache.org/schema/spring\" version=\"1.0\">";
        XMLAssert.testDiagnosticsFor(xml, XMLAssert.d(2, 1, 2, 10, (IXMLErrorCode)XMLSyntaxErrorCode.AttributeNSNotUnique));
    }

    @Test
    public void testAttributePrefixUnbound() throws Exception {
        String xml = "<a xsi:xxxxx=\"\"></a>";
        XMLAssert.testDiagnosticsFor(xml, XMLAssert.d(0, 3, 0, 6, (IXMLErrorCode)XMLSyntaxErrorCode.AttributePrefixUnbound));
    }

    @Test
    public void testBeforeContentIllegalInProlog() throws Exception {
        String xml = " ab?<xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>";
        XMLAssert.testDiagnosticsFor(xml, XMLAssert.d(0, 1, 0, 4, (IXMLErrorCode)XMLSyntaxErrorCode.ContentIllegalInProlog));
    }

    @Test
    public void testAfterContentIllegalInProlog() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>ab\ncd";
        XMLAssert.testDiagnosticsFor(xml, XMLAssert.d(0, 54, 1, 2, (IXMLErrorCode)XMLSyntaxErrorCode.ContentIllegalInProlog));
    }

    @Test
    public void testAfterContentIllegalInProlog2() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>ab\ncd<root>";
        XMLAssert.testDiagnosticsFor(xml, XMLAssert.d(0, 54, 1, 2, (IXMLErrorCode)XMLSyntaxErrorCode.ContentIllegalInProlog));
    }

    @Test
    public void testEncodingUTF_16() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-16\" standalone=\"no\"?><root />";
        XMLAssert.testDiagnosticsFor(xml, new Diagnostic[0]);
    }

    @Test
    public void testDashDashInComment() throws Exception {
        String xml = "<Id>\r\n\t\t\t\t\t<!-- comment -- text -->\r\n        </Id>";
        XMLAssert.testDiagnosticsFor(xml, XMLAssert.d(1, 18, 1, 20, (IXMLErrorCode)XMLSyntaxErrorCode.DashDashInComment));
    }

    @Test
    public void elementUnterminated() throws Exception {
        String xml = "<Id>\r\n          <OrgId\r\n            <Othr>\r\n              <Id> 222010012</Id>\r\n            </Othr>\r\n          </OrgId>\r\n        </Id>";
        Diagnostic d = XMLAssert.d(1, 11, 1, 16, (IXMLErrorCode)XMLSyntaxErrorCode.ElementUnterminated);
        XMLAssert.testDiagnosticsFor(xml, d);
        XMLAssert.testCodeActionsFor(xml, d, XMLAssert.ca(d, XMLAssert.te(1, 16, 1, 16, ">")));
    }

    @Test
    public void testElementUnterminatedEndsWithSlash() throws Exception {
        String xml = "<foo>\r\n  <bar att=\"\" /\r\n</foo>";
        Diagnostic d = XMLAssert.d(1, 3, 1, 15, (IXMLErrorCode)XMLSyntaxErrorCode.ElementUnterminated);
        XMLAssert.testDiagnosticsFor(xml, d);
        XMLAssert.testCodeActionsFor(xml, d, XMLAssert.ca(d, XMLAssert.te(1, 15, 1, 15, ">")));
    }

    @Test
    public void testElementUnterminatedEndsWithSlashAndSpaces() throws Exception {
        String xml = "<foo>\r\n  <bar att=\"\" /     \r\n</foo>";
        Diagnostic d = XMLAssert.d(1, 3, 1, 15, (IXMLErrorCode)XMLSyntaxErrorCode.ElementUnterminated);
        XMLAssert.testDiagnosticsFor(xml, d);
        XMLAssert.testCodeActionsFor(xml, d, XMLAssert.ca(d, XMLAssert.te(1, 15, 1, 15, ">")));
    }

    @Test
    public void testElementUnterminatedEndsWithAttributes() throws Exception {
        String xml = "<foo>\r\n  <bar att=\"\"\r\n</foo>";
        Diagnostic d = XMLAssert.d(1, 3, 1, 13, (IXMLErrorCode)XMLSyntaxErrorCode.ElementUnterminated);
        XMLAssert.testDiagnosticsFor(xml, d);
        XMLAssert.testCodeActionsFor(xml, d, XMLAssert.ca(d, XMLAssert.te(1, 13, 1, 13, "/>")), XMLAssert.ca(d, XMLAssert.te(1, 13, 1, 13, "></bar>")));
    }

    @Test
    public void testElementUnterminatedEndsWithAttributesAndEndSlash() throws Exception {
        String xml = "<foo>\r\n  <bar att=\"\"          /\r\n</foo>";
        Diagnostic d = XMLAssert.d(1, 3, 1, 24, (IXMLErrorCode)XMLSyntaxErrorCode.ElementUnterminated);
        XMLAssert.testDiagnosticsFor(xml, d);
        XMLAssert.testCodeActionsFor(xml, d, XMLAssert.ca(d, XMLAssert.te(1, 24, 1, 24, ">")));
    }

    @Test
    public void testElementUnterminatedEndsAndSpaces() throws Exception {
        String xml = "<foo>\r\n  <bar att=\"\"    \r\n</foo>";
        Diagnostic d = XMLAssert.d(1, 3, 1, 13, (IXMLErrorCode)XMLSyntaxErrorCode.ElementUnterminated);
        XMLAssert.testDiagnosticsFor(xml, d);
        XMLAssert.testCodeActionsFor(xml, d, XMLAssert.ca(d, XMLAssert.te(1, 13, 1, 13, "/>")), XMLAssert.ca(d, XMLAssert.te(1, 13, 1, 13, "></bar>")));
    }

    @Test
    public void testElementPrefixUnbound() throws Exception {
        String xml = "<xs:OrgId>\r\n  <xs:Othr>\r\n  </xs:Othr>\r\n</xs:OrgId>";
        XMLAssert.testDiagnosticsFor(xml, XMLAssert.d(0, 1, 0, 9, (IXMLErrorCode)XMLSyntaxErrorCode.ElementPrefixUnbound));
    }

    @Test
    public void testEmptyPrefixedAttName() throws Exception {
        String xml = "<Document xmlns:xsi=\"\"http://www.w3.org/2001/XMLSchema-instance\" xmlns=\"urn:iso:std:iso:20022:tech:xsd:pain.001.001.03\">";
        XMLAssert.testDiagnosticsFor(xml, XMLAssert.d(0, 20, 0, 22, (IXMLErrorCode)XMLSyntaxErrorCode.EmptyPrefixedAttName));
    }

    @Test
    public void testEqRequiredInAttribute() throws Exception {
        String xml = "<a Ccy>123.456</a>";
        Diagnostic d = XMLAssert.d(0, 3, 0, 6, (IXMLErrorCode)XMLSyntaxErrorCode.EqRequiredInAttribute);
        XMLAssert.testDiagnosticsFor(xml, d);
        XMLAssert.testCodeActionsFor(xml, d, XMLAssert.ca(d, XMLAssert.te(0, 6, 0, 6, "=\"\"")));
    }

    @Test
    public void testEqRequiredInXMLDecl() throws Exception {
        String xml = "<?xml version:\"1.0\" encoding=\"UTF-8\"?><a></a>";
        XMLAssert.testDiagnosticsFor(xml, XMLAssert.d(0, 6, 0, 14, (IXMLErrorCode)XMLSyntaxErrorCode.EqRequiredInXMLDecl));
    }

    @Test
    public void testNoMorePseudoAttributes() throws Exception {
        String xml = "<?xml version=\"1.0\" standalone=\"yes\" encoding=\"UTF-8\"?><a></a>";
        XMLAssert.testDiagnosticsFor(xml, XMLAssert.d(0, 37, 0, 45, (IXMLErrorCode)XMLSyntaxErrorCode.NoMorePseudoAttributes));
    }

    @Test
    public void testETagRequired() throws Exception {
        String xml = "<UltmtDbtr>\r\n  \t\t<Nm>Name\r\n\t\t</UltmtDbtr> \r\n\t\t\t</Nm>  ";
        Diagnostic d = XMLAssert.d(1, 5, 1, 7, (IXMLErrorCode)XMLSyntaxErrorCode.ETagRequired);
        XMLAssert.testDiagnosticsFor(xml, d);
        XMLAssert.testCodeActionsFor(xml, d, XMLAssert.ca(d, XMLAssert.te(1, 12, 1, 12, "</Nm>")));
    }

    @Test
    public void testETagRequired2() throws Exception {
        String xml = "<UltmtDbtr>\r\n  \t\tNm>Name</Nm>\r\n\t\t</UltmtDbtr>";
        XMLAssert.testDiagnosticsFor(xml, XMLAssert.d(0, 1, 0, 10, (IXMLErrorCode)XMLSyntaxErrorCode.ETagRequired));
    }

    @Test
    public void testETagRequired3() throws Exception {
        String xml = "<UltmtDbtr>\r\n    <Nm>Name</Nm>\r\n    <Ad>\r\n    <Ph>\r\n</UltmtDbtr>";
        Diagnostic d = XMLAssert.d(3, 5, 3, 7, (IXMLErrorCode)XMLSyntaxErrorCode.ETagRequired);
        XMLAssert.testDiagnosticsFor(xml, d);
        XMLAssert.testCodeActionsFor(xml, d, XMLAssert.ca(d, XMLAssert.te(3, 8, 3, 8, "</Ph>")));
    }

    @Test
    public void testETagRequiredWithReplace() throws Exception {
        String xml = "<a>\r\n\t<b>\r\n\t\t</c>";
        Diagnostic d = XMLAssert.d(1, 2, 1, 3, (IXMLErrorCode)XMLSyntaxErrorCode.ETagRequired);
        XMLAssert.testDiagnosticsFor(xml, d);
        XMLAssert.testCodeActionsFor(xml, d, XMLAssert.ca(d, XMLAssert.te(2, 4, 2, 5, "b")), XMLAssert.ca(d, XMLAssert.te(2, 6, 2, 6, "\r\n\t</b>")));
    }

    @Test
    public void testETagRequiredWithText() throws Exception {
        String xml = "<root>\r\n<ABC>def\r\n</root>";
        Diagnostic d = XMLAssert.d(1, 1, 1, 4, (IXMLErrorCode)XMLSyntaxErrorCode.ETagRequired);
        XMLAssert.testDiagnosticsFor(xml, d);
        XMLAssert.testCodeActionsFor(xml, d, XMLAssert.ca(d, XMLAssert.te(1, 8, 1, 8, "</ABC>")));
    }

    @Test
    public void testETagRequiredWithOrpheanEndTag() throws Exception {
        String xml = "<root>\r\n\t<foo>\r\n\t\t</\r\n</root>";
        Diagnostic d = XMLAssert.d(1, 2, 1, 5, (IXMLErrorCode)XMLSyntaxErrorCode.ETagRequired);
        XMLAssert.testDiagnosticsFor(xml, d);
        XMLAssert.testCodeActionsFor(xml, d, XMLAssert.ca(d, XMLAssert.te(2, 4, 2, 4, "foo>")));
    }

    @Test
    public void testETagRequiredClosedWithOrpheanEndTag() throws Exception {
        String xml = "<root>\r\n\t<foo>\r\n\t\t</\r\n\t</foo>\r\n</root>";
        Diagnostic d = XMLAssert.d(1, 2, 1, 5, (IXMLErrorCode)XMLSyntaxErrorCode.ETagRequired);
        XMLAssert.testDiagnosticsFor(xml, d);
        XMLAssert.testCodeActionsFor(xml, d, XMLAssert.ca(d, XMLAssert.te(2, 2, 2, 4, "")));
    }

    @Test
    public void testETagRequiredClosedWithOrpheanEndTag2() throws Exception {
        String xml = "<root>\r\n\t<foo>\r\n\t\t</bar>\r\n\t</foo>\r\n</root>";
        Diagnostic d = XMLAssert.d(1, 2, 1, 5, (IXMLErrorCode)XMLSyntaxErrorCode.ETagRequired);
        XMLAssert.testDiagnosticsFor(xml, d);
        XMLAssert.testCodeActionsFor(xml, d, XMLAssert.ca(d, XMLAssert.te(2, 2, 2, 8, "")));
    }

    @Test
    public void testETagUnterminated() throws Exception {
        String xml = "<MsgId>ABC/090928/CCT001</MsgId\r\n  <CreDtTm>2009-09-28T14:07:00</CreDtTm>";
        Diagnostic d = XMLAssert.d(0, 26, 0, 31, (IXMLErrorCode)XMLSyntaxErrorCode.ETagUnterminated);
        XMLAssert.testDiagnosticsFor(xml, d);
        XMLAssert.testCodeActionsFor(xml, d, XMLAssert.ca(d, XMLAssert.te(0, 31, 0, 31, ">")));
    }

    @Test
    public void testETagUnterminated2() throws Exception {
        String xml = "<a>\r\n  <b>\r\n    <c></c>\r\n  </b\r\n</a>";
        Diagnostic d = XMLAssert.d(3, 4, 3, 5, (IXMLErrorCode)XMLSyntaxErrorCode.ETagUnterminated);
        XMLAssert.testDiagnosticsFor(xml, d);
        XMLAssert.testCodeActionsFor(xml, d, XMLAssert.ca(d, XMLAssert.te(3, 5, 3, 5, ">")));
    }

    @Test
    public void testETagUnterminated3() throws Exception {
        String xml = "<foo>\r\n  <ba><ABCD></ABCD></bar>\r\n</foo>";
        XMLAssert.testDiagnosticsFor(xml, XMLAssert.d(1, 21, 1, 24, (IXMLErrorCode)XMLSyntaxErrorCode.ETagUnterminated));
    }

    @Test
    public void testETagUnterminated4() throws Exception {
        String xml = "<project>\r\n  <dependencies>\r\n    <dependency>\r\n      <scope>test</scope>\r\n    </dependency\r\n    <dependency>\r\n      <scope>test</scope>\r\n    </dependency>\r\n  </dependencies>\r\n</project>";
        XMLAssert.testDiagnosticsFor(xml, XMLAssert.d(4, 6, 4, 16, (IXMLErrorCode)XMLSyntaxErrorCode.ETagUnterminated));
    }

    @Test
    public void testIllegalQName() throws Exception {
        String xml = "<a Ccy:\"JPY\">100</a>";
        XMLAssert.testDiagnosticsFor(xml, XMLAssert.d(0, 6, 0, 7, (IXMLErrorCode)XMLSyntaxErrorCode.IllegalQName));
    }

    @Test
    public void testInvalidCommentStart() throws Exception {
        String xml = "<!- gdfgdfg -- starts here -->";
        XMLAssert.testDiagnosticsFor(xml, XMLAssert.d(0, 2, 0, 3, (IXMLErrorCode)XMLSyntaxErrorCode.InvalidCommentStart));
    }

    @Test
    public void testLessThanAttValue() throws Exception {
        String xml = "<InstdAmt Ccy=\"<EUR\">123.45</InstdAmt> ";
        XMLAssert.testDiagnosticsFor(xml, XMLAssert.d(0, 14, 0, 20, (IXMLErrorCode)XMLSyntaxErrorCode.LessthanInAttValue));
    }

    @Test
    public void testMarkupEntityMismatch() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Document xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns=\"urn:iso:std:iso:20022:tech:xsd:pain.001.001.03\">\r\n<CstmrCdtTrfInitn>\r\n</CstmrCdtTrfInitn>";
        Diagnostic d = XMLAssert.d(1, 1, 1, 9, (IXMLErrorCode)XMLSyntaxErrorCode.MarkupEntityMismatch);
        XMLAssert.testDiagnosticsFor(xml, d);
        XMLAssert.testCodeActionsFor(xml, d, XMLAssert.ca(d, XMLAssert.te(3, 19, 3, 19, "\r\n</Document>")));
    }

    @Test
    public void testMarkupEntityMismatch2() throws Exception {
        String xml = "<ABC>";
        Diagnostic d = XMLAssert.d(0, 1, 0, 4, (IXMLErrorCode)XMLSyntaxErrorCode.MarkupEntityMismatch);
        XMLAssert.testDiagnosticsFor(xml, d);
        XMLAssert.testCodeActionsFor(xml, d, XMLAssert.ca(d, XMLAssert.te(0, 5, 0, 5, "</ABC>")));
    }

    @Test
    public void testMarkupEntityMismatch3() throws Exception {
        String xml = "<";
        Diagnostic d = XMLAssert.d(0, 1, 0, 1, (IXMLErrorCode)XMLSyntaxErrorCode.MarkupEntityMismatch);
        XMLAssert.testDiagnosticsFor(xml, d);
        XMLAssert.testCodeActionsFor(xml, d, new CodeAction[0]);
    }

    @Test
    public void testMarkupEntityMismatch4() throws Exception {
        String xml = "<?";
        Diagnostic d = XMLAssert.d(0, 1, 0, 1, (IXMLErrorCode)XMLSyntaxErrorCode.MarkupEntityMismatch);
        XMLAssert.testDiagnosticsFor(xml, d);
    }

    @Test
    public void testMarkupEntityMismatchWithoutClose() throws Exception {
        String xml = "<ABC";
        Diagnostic d = XMLAssert.d(0, 1, 0, 4, (IXMLErrorCode)XMLSyntaxErrorCode.MarkupEntityMismatch);
        XMLAssert.testDiagnosticsFor(xml, d);
        XMLAssert.testCodeActionsFor(xml, d, XMLAssert.ca(d, XMLAssert.te(0, 4, 0, 4, "/>")), XMLAssert.ca(d, XMLAssert.te(0, 4, 0, 4, "></ABC>")));
    }

    @Test
    public void testMarkupEntityMismatchWithoutCloseAndNewLine() throws Exception {
        String xml = "<ABC\r\n";
        Diagnostic d = XMLAssert.d(0, 1, 0, 4, (IXMLErrorCode)XMLSyntaxErrorCode.MarkupEntityMismatch);
        XMLAssert.testDiagnosticsFor(xml, d);
        XMLAssert.testCodeActionsFor(xml, d, XMLAssert.ca(d, XMLAssert.te(0, 4, 0, 4, "/>")), XMLAssert.ca(d, XMLAssert.te(0, 4, 0, 4, "></ABC>")));
    }

    @Test
    public void testMarkupEntityMismatchWithoutCloseAndSpaces() throws Exception {
        String xml = "<ABC    ";
        Diagnostic d = XMLAssert.d(0, 1, 0, 4, (IXMLErrorCode)XMLSyntaxErrorCode.MarkupEntityMismatch);
        XMLAssert.testDiagnosticsFor(xml, d);
        XMLAssert.testCodeActionsFor(xml, d, XMLAssert.ca(d, XMLAssert.te(0, 4, 0, 4, "/>")), XMLAssert.ca(d, XMLAssert.te(0, 4, 0, 4, "></ABC>")));
    }

    @Test
    public void testMarkupEntityMismatchWithAttributes() throws Exception {
        String xml = "<ABC a=''   ";
        Diagnostic d = XMLAssert.d(0, 1, 0, 4, (IXMLErrorCode)XMLSyntaxErrorCode.MarkupEntityMismatch);
        XMLAssert.testDiagnosticsFor(xml, d);
        XMLAssert.testCodeActionsFor(xml, d, XMLAssert.ca(d, XMLAssert.te(0, 9, 0, 9, "/>")), XMLAssert.ca(d, XMLAssert.te(0, 9, 0, 9, "></ABC>")));
    }

    @Test
    public void testMarkupEntityMismatchWithAttributesAndSlash() throws Exception {
        String xml = "<ABC a='' /  ";
        Diagnostic d = XMLAssert.d(0, 1, 0, 11, (IXMLErrorCode)XMLSyntaxErrorCode.ElementUnterminated);
        XMLAssert.testDiagnosticsFor(xml, d);
        XMLAssert.testCodeActionsFor(xml, d, XMLAssert.ca(d, XMLAssert.te(0, 11, 0, 11, ">")));
    }

    @Test
    public void testMarkupEntityMismatchWithText() throws Exception {
        String xml = "<ABC>def";
        Diagnostic d = XMLAssert.d(0, 1, 0, 4, (IXMLErrorCode)XMLSyntaxErrorCode.MarkupEntityMismatch);
        XMLAssert.testDiagnosticsFor(xml, d);
        XMLAssert.testCodeActionsFor(xml, d, XMLAssert.ca(d, XMLAssert.te(0, 8, 0, 8, "</ABC>")));
    }

    @Test
    public void testMarkupEntityMismatchWithTextAndNewLine() throws Exception {
        String xml = "<ABC>def\r\n";
        Diagnostic d = XMLAssert.d(0, 1, 0, 4, (IXMLErrorCode)XMLSyntaxErrorCode.MarkupEntityMismatch);
        XMLAssert.testDiagnosticsFor(xml, d);
        XMLAssert.testCodeActionsFor(xml, d, XMLAssert.ca(d, XMLAssert.te(0, 8, 0, 8, "</ABC>")));
    }

    @Test
    public void testMarkupEntityMismatchMultiLine() throws Exception {
        String xml = "<foo action=\"toot\"\r\n\t\t    /";
        Diagnostic d = XMLAssert.d(0, 1, 0, 4, (IXMLErrorCode)XMLSyntaxErrorCode.MarkupEntityMismatch);
        XMLAssert.testDiagnosticsFor(xml, d);
        XMLAssert.testCodeActionsFor(xml, d, XMLAssert.ca(d, XMLAssert.te(1, 7, 1, 7, ">")));
    }

    @Test
    public void testMarkupNotRecognizedInContent() throws Exception {
        String xml = "<GrpHdr>\r\n<- almost a comment-->\r\n<MsgId>2.012.001</MsgId>";
        XMLAssert.testDiagnosticsFor(xml, XMLAssert.d(1, 0, 1, 1, (IXMLErrorCode)XMLSyntaxErrorCode.MarkupNotRecognizedInContent));
    }

    @Test
    public void testNameRequiredInReference() throws Exception {
        String xml = "<Nm>Virgay & Co</Nm>";
        XMLAssert.testDiagnosticsFor(xml, XMLAssert.d(0, 12, 0, 12, (IXMLErrorCode)XMLSyntaxErrorCode.NameRequiredInReference));
    }

    @Test
    public void testOpenQuoteExpected() throws Exception {
        String xml = " <InstdAmt Ccy==\"JPY\">10000000</InstdAmt>";
        Diagnostic diagnostic1 = XMLAssert.d(0, 11, 0, 14, (IXMLErrorCode)XMLSyntaxErrorCode.OpenQuoteExpected);
        XMLAssert.testDiagnosticsFor(xml, diagnostic1);
        XMLAssert.testCodeActionsFor(xml, diagnostic1, XMLAssert.ca(diagnostic1, XMLAssert.te(0, 15, 0, 15, "\"\"")));
    }

    @Test
    public void testMissingQuotesForAttribute() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<foo>\r\n  <bar one= two=\"\">\r\n  </bar>\r\n</foo>";
        Diagnostic diagnostic1 = XMLAssert.d(2, 7, 2, 10, (IXMLErrorCode)XMLSyntaxErrorCode.OpenQuoteExpected);
        XMLAssert.testDiagnosticsFor(xml, diagnostic1);
        XMLAssert.testCodeActionsFor(xml, diagnostic1, XMLAssert.ca(diagnostic1, XMLAssert.te(2, 11, 2, 11, "\"\"")));
    }

    @Test
    public void testMissingQuotesForAttributeSelfClosing() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<foo>\r\n  <bar one= two=\"\"/>\r\n</foo>";
        Diagnostic diagnostic1 = XMLAssert.d(2, 7, 2, 10, (IXMLErrorCode)XMLSyntaxErrorCode.OpenQuoteExpected);
        XMLAssert.testDiagnosticsFor(xml, diagnostic1);
        XMLAssert.testCodeActionsFor(xml, diagnostic1, XMLAssert.ca(diagnostic1, XMLAssert.te(2, 11, 2, 11, "\"\"")));
    }

    @Test
    public void testMissingQuotesForAttributeSelfClosing2() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<foo>\r\n  <bar one=/>\r\n</foo>";
        Diagnostic diagnostic1 = XMLAssert.d(2, 7, 2, 10, (IXMLErrorCode)XMLSyntaxErrorCode.OpenQuoteExpected);
        XMLAssert.testDiagnosticsFor(xml, diagnostic1);
        XMLAssert.testCodeActionsFor(xml, diagnostic1, XMLAssert.ca(diagnostic1, XMLAssert.te(2, 11, 2, 11, "\"\"")));
    }

    @Test
    public void testMissingQuotesForAttributeUsingNextValue() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<foo>\r\n  <bar one= two/>\r\n</foo>";
        Diagnostic diagnostic1 = XMLAssert.d(2, 7, 2, 10, (IXMLErrorCode)XMLSyntaxErrorCode.OpenQuoteExpected);
        XMLAssert.testDiagnosticsFor(xml, diagnostic1);
        XMLAssert.testCodeActionsFor(xml, diagnostic1, XMLAssert.ca(diagnostic1, XMLAssert.te(2, 11, 2, 15, "\"two\"")));
    }

    @Test
    public void testMissingQuotesForAttributeSingleQuotes() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<foo>\r\n  <bar one= two=\"\"/>\r\n</foo>";
        Diagnostic diagnostic1 = XMLAssert.d(2, 7, 2, 10, (IXMLErrorCode)XMLSyntaxErrorCode.OpenQuoteExpected);
        XMLAssert.testDiagnosticsFor(xml, diagnostic1);
        SharedSettings settings = new SharedSettings();
        settings.getPreferences().setQuoteStyle(QuoteStyle.singleQuotes);
        settings.getFormattingSettings().setEnforceQuoteStyle(EnforceQuoteStyle.preferred);
        XMLAssert.testCodeActionsFor(xml, diagnostic1, null, settings, XMLAssert.ca(diagnostic1, XMLAssert.te(2, 11, 2, 11, "''")));
    }

    @Test
    public void testOpenQuoteExpectedDisabledPreference() throws Exception {
        String xml = " <InstdAmt Ccy==\"JPY\">10000000</InstdAmt>";
        XMLAssert.testDiagnosticsFor(xml, null, null, null, true, XMLAssert.getContentModelSettings(false, SchemaEnabled.always), new Diagnostic[0]);
    }

    @Test
    public void testPITargetRequired() throws Exception {
        String xml = "<? encoding=\"UTF-8\"?>";
        XMLAssert.testDiagnosticsFor(xml, XMLAssert.d(0, 2, 0, 2, (IXMLErrorCode)XMLSyntaxErrorCode.PITargetRequired));
    }

    @Test
    public void testPseudoAttrNameExpected() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"><a></a>";
        XMLAssert.testDiagnosticsFor(xml, XMLAssert.d(0, 36, 0, 36, (IXMLErrorCode)XMLSyntaxErrorCode.PseudoAttrNameExpected));
    }

    @Test
    public void testQuoteRequiredInXMLDecl() throws Exception {
        String xml = "<?xml version= encoding=\"UTF-8\"?>";
        XMLAssert.testDiagnosticsFor(xml, XMLAssert.d(0, 6, 0, 14, (IXMLErrorCode)XMLSyntaxErrorCode.QuoteRequiredInXMLDecl));
    }

    @Test
    public void testRootElementTypeMustMatchDoctypedecl() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<!DOCTYPE efgh [ \r\n<!ELEMENT abcd (#PCDATA)>\r\n<!ELEMENT efgh (#PCDATA)>\r\n]> \r\n<abcd/>";
        String expectedMessage = "Document root element \"abcd\", must match DOCTYPE root \"efgh\".";
        Diagnostic d = XMLAssert.d(5, 1, 5, 5, (IXMLErrorCode)XMLSyntaxErrorCode.RootElementTypeMustMatchDoctypedecl, expectedMessage);
        XMLAssert.testDiagnosticsFor(xml, d);
        XMLAssert.testCodeActionsFor(xml, d, XMLAssert.ca(d, XMLAssert.te(5, 1, 5, 5, "efgh")));
    }

    @Test
    public void testRootElementTypeMustMatchDoctypedecl2() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<!DOCTYPE efgh [ \r\n<!ELEMENT abcd (#PCDATA)>\r\n<!ELEMENT efgh (#PCDATA)>\r\n]> \r\n<abcd>test</abcd>";
        String expectedMessage = "Document root element \"abcd\", must match DOCTYPE root \"efgh\".";
        Diagnostic d = XMLAssert.d(5, 1, 5, 5, (IXMLErrorCode)XMLSyntaxErrorCode.RootElementTypeMustMatchDoctypedecl, expectedMessage);
        XMLAssert.testDiagnosticsFor(xml, d);
        XMLAssert.testCodeActionsFor(xml, d, XMLAssert.ca(d, XMLAssert.te(5, 1, 5, 5, "efgh"), XMLAssert.te(5, 12, 5, 16, "efgh")));
    }

    @Test
    public void testSDDeclInvalid() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"en\"?>";
        XMLAssert.testDiagnosticsFor(xml, XMLAssert.d(0, 48, 0, 52, (IXMLErrorCode)XMLSyntaxErrorCode.SDDeclInvalid));
    }

    @Test
    public void testSpaceRequiredBeforeEncodingInXMLDecl() throws Exception {
        String xml = "<?xml version=\"1.0\"encoding=\"UTF-8\"?>";
        XMLAssert.testDiagnosticsFor(xml, XMLAssert.d(0, 1, 0, 5, (IXMLErrorCode)XMLSyntaxErrorCode.SpaceRequiredBeforeEncodingInXMLDecl));
    }

    @Test
    public void testSpaceRequiredBeforeStandalone() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"standalone=\"no\"?>";
        XMLAssert.testDiagnosticsFor(xml, XMLAssert.d(0, 1, 0, 5, (IXMLErrorCode)XMLSyntaxErrorCode.SpaceRequiredBeforeStandalone));
    }

    @Test
    public void testSpaceRequiredInPI() throws Exception {
        String xml = "<?xmlversion=\"1.0\" encoding=\"UTF-8\"?>";
        XMLAssert.testDiagnosticsFor(xml, XMLAssert.d(0, 1, 0, 12, (IXMLErrorCode)XMLSyntaxErrorCode.SpaceRequiredInPI));
    }

    @Test
    public void testVersionInfoRequired() throws Exception {
        String xml = "<?xml encoding=\"UTF-8\"?>";
        XMLAssert.testDiagnosticsFor(xml, XMLAssert.d(0, 1, 0, 5, (IXMLErrorCode)XMLSyntaxErrorCode.VersionInfoRequired));
    }

    @Test
    public void testVersionNotSupported() throws Exception {
        String xml = "<?xml version=\"5000.0\"encoding=\"UTF-8\"?>";
        XMLAssert.testDiagnosticsFor(xml, XMLAssert.d(0, 14, 0, 22, (IXMLErrorCode)XMLSyntaxErrorCode.VersionNotSupported));
    }

    @Test
    public void testEntitySemicolonRequiredInReference() throws Exception {
        String xml = "<!DOCTYPE root [\n    <!ELEMENT root (#PCDATA)>\n    <!ENTITY mdash \"&#x2014;\">\n]>\n<root>\n    &mdash \n</root>";
        Diagnostic d = XMLAssert.d(5, 4, 5, 10, (IXMLErrorCode)XMLSyntaxErrorCode.SemicolonRequiredInReference);
        XMLAssert.testDiagnosticsFor(xml, d);
        XMLAssert.testCodeActionsFor(xml, d, XMLAssert.ca(d, XMLAssert.te(5, 10, 5, 10, ";")));
    }

    @Test
    public void testEntitySemicolonRequiredInReferenceOddSpacing() throws Exception {
        String xml = "<!DOCTYPE root [\n    <!ELEMENT root (#PCDATA)>\n    <!ENTITY mdash \"&#x2014;\">\n]>\n<root>\n    &mdash</root>";
        Diagnostic d = XMLAssert.d(5, 4, 5, 10, (IXMLErrorCode)XMLSyntaxErrorCode.SemicolonRequiredInReference);
        XMLAssert.testDiagnosticsFor(xml, d);
        XMLAssert.testCodeActionsFor(xml, d, XMLAssert.ca(d, XMLAssert.te(5, 10, 5, 10, ";")));
    }

    @Test
    public void testEntitySemicolonRequiredInReferenceShortName() throws Exception {
        String xml = "<!DOCTYPE root [\n    <!ELEMENT root (#PCDATA)>\n    <!ENTITY m \"&#x2014;\">\n]>\n<root>\n    &m \n</root>";
        Diagnostic d = XMLAssert.d(5, 4, 5, 6, (IXMLErrorCode)XMLSyntaxErrorCode.SemicolonRequiredInReference);
        XMLAssert.testDiagnosticsFor(xml, d);
        XMLAssert.testCodeActionsFor(xml, d, XMLAssert.ca(d, XMLAssert.te(5, 6, 5, 6, ";")));
    }

    @Test
    public void closeTag() throws Exception {
        String xml = "<a";
        Diagnostic d = XMLAssert.d(0, 1, 0, 2, (IXMLErrorCode)XMLSyntaxErrorCode.MarkupEntityMismatch);
        XMLAssert.testDiagnosticsFor(xml, d);
        XMLAssert.testCodeActionsFor(xml, d, XMLAssert.ca(d, XMLAssert.te(0, 2, 0, 2, "/>")), XMLAssert.ca(d, XMLAssert.te(0, 2, 0, 2, "></a>")));
        xml = "<a>";
        d = XMLAssert.d(0, 1, 0, 2, (IXMLErrorCode)XMLSyntaxErrorCode.MarkupEntityMismatch);
        XMLAssert.testDiagnosticsFor(xml, d);
        XMLAssert.testCodeActionsFor(xml, d, XMLAssert.ca(d, XMLAssert.te(0, 3, 0, 3, "</a>")));
        xml = "<a /";
        d = XMLAssert.d(0, 1, 0, 2, (IXMLErrorCode)XMLSyntaxErrorCode.MarkupEntityMismatch);
        XMLAssert.testDiagnosticsFor(xml, d);
        XMLAssert.testCodeActionsFor(xml, d, XMLAssert.ca(d, XMLAssert.te(0, 4, 0, 4, ">")));
        xml = "<a / ";
        d = XMLAssert.d(0, 1, 0, 4, (IXMLErrorCode)XMLSyntaxErrorCode.ElementUnterminated);
        XMLAssert.testDiagnosticsFor(xml, d);
        XMLAssert.testCodeActionsFor(xml, d, XMLAssert.ca(d, XMLAssert.te(0, 4, 0, 4, ">")));
        xml = "<a></";
        d = XMLAssert.d(0, 1, 0, 2, (IXMLErrorCode)XMLSyntaxErrorCode.MarkupEntityMismatch);
        XMLAssert.testDiagnosticsFor(xml, d);
        XMLAssert.testCodeActionsFor(xml, d, XMLAssert.ca(d, XMLAssert.te(0, 5, 0, 5, "a>")));
    }

    @Test
    public void namespacesSettingsWithoutXMLNS() throws Exception {
        String xml = "<foo>\r\n\t<p:bar />\r\n</foo>";
        ContentModelSettings settings = XMLSyntaxDiagnosticsTest.getSettingsForNamespaces(NamespacesEnabled.always);
        XMLAssert.testDiagnosticsFor(xml, null, null, null, true, settings, XMLAssert.d(1, 2, 1, 7, (IXMLErrorCode)XMLSyntaxErrorCode.ElementPrefixUnbound));
        settings = XMLSyntaxDiagnosticsTest.getSettingsForNamespaces(NamespacesEnabled.never);
        XMLAssert.testDiagnosticsFor(xml, null, null, null, true, settings, new Diagnostic[0]);
        settings = XMLSyntaxDiagnosticsTest.getSettingsForNamespaces(NamespacesEnabled.onNamespaceEncountered);
        XMLAssert.testDiagnosticsFor(xml, null, null, null, true, settings, new Diagnostic[0]);
    }

    @Test
    public void namespacesSettingsWithUnvalidXMLNS() throws Exception {
        String xml = "<foo xmlns=\"http:foo\" >\r\n\t<p:bar />\r\n</foo>";
        ContentModelSettings settings = XMLSyntaxDiagnosticsTest.getSettingsForNamespaces(NamespacesEnabled.always);
        XMLAssert.testDiagnosticsFor(xml, null, null, null, true, settings, XMLAssert.d(1, 2, 1, 7, (IXMLErrorCode)XMLSyntaxErrorCode.ElementPrefixUnbound));
        settings = XMLSyntaxDiagnosticsTest.getSettingsForNamespaces(NamespacesEnabled.never);
        XMLAssert.testDiagnosticsFor(xml, null, null, null, true, settings, new Diagnostic[0]);
        settings = XMLSyntaxDiagnosticsTest.getSettingsForNamespaces(NamespacesEnabled.onNamespaceEncountered);
        XMLAssert.testDiagnosticsFor(xml, null, null, null, true, settings, XMLAssert.d(1, 2, 1, 7, (IXMLErrorCode)XMLSyntaxErrorCode.ElementPrefixUnbound));
    }

    @Test
    public void namespacesSettingsWithValidXMLNS() throws Exception {
        String xml = "<foo xmlns:p=\"http:foo\" >\r\n\t<p:bar />\r\n</foo>";
        ContentModelSettings settings = XMLSyntaxDiagnosticsTest.getSettingsForNamespaces(NamespacesEnabled.always);
        XMLAssert.testDiagnosticsFor(xml, null, null, null, true, settings, new Diagnostic[0]);
        settings = XMLSyntaxDiagnosticsTest.getSettingsForNamespaces(NamespacesEnabled.never);
        XMLAssert.testDiagnosticsFor(xml, null, null, null, true, settings, new Diagnostic[0]);
        settings = XMLSyntaxDiagnosticsTest.getSettingsForNamespaces(NamespacesEnabled.onNamespaceEncountered);
        XMLAssert.testDiagnosticsFor(xml, null, null, null, true, settings, new Diagnostic[0]);
    }

    private static ContentModelSettings getSettingsForNamespaces(NamespacesEnabled namespacesEnabled) {
        ContentModelSettings settings = XMLAssert.getContentModelSettings(true, SchemaEnabled.never);
        settings.getValidation().setNoGrammar("ignore");
        XMLNamespacesSettings namespaces = new XMLNamespacesSettings();
        namespaces.setEnabled(namespacesEnabled);
        settings.getValidation().setNamespaces(namespaces);
        return settings;
    }
}

