/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.xsd;

import org.eclipse.lemminx.AbstractCacheBasedTest;
import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lsp4j.DocumentHighlight;
import org.eclipse.lsp4j.DocumentHighlightKind;
import org.junit.jupiter.api.Test;

public class XSDHighlightingExtensionsTest
extends AbstractCacheBasedTest {
    @Test
    public void highlightingOnElementType() throws BadLocationException {
        String xml = "<?xml version=\"1.1\" ?>\r\n<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" targetNamespace=\"http://www.w3.org/2001/XMLSchema\">\r\n\t<xs:element name=\"elt\" type=\"x|s:aComplexType\" />\r\n\t<xs:complexType name=\"aComplexType\">\r\n\t\t<xs:simpleContent>\r\n\t\t\t<xs:extension base=\"xs:aSimpleTypeA\"></xs:extension>\r\n\t\t</xs:simpleContent>\r\n\t</xs:complexType>\r\n\t\r\n\t<xs:complexType name=\"aComplexType2\">\r\n\t\t<xs:complexContent>\r\n\t\t\t<xs:extension base=\"xs:aComplexType\"></xs:extension>\r\n\t\t</xs:complexContent>\r\n\t</xs:complexType>\r\n\r\n\t<xs:simpleType name=\"aSimpleTypeA\">\r\n\t\t<xs:restriction base=\"xs:ENTITIES\">\r\n\t\t</xs:restriction>\r\n\t</xs:simpleType>\r\n</xs:schema>";
        XMLAssert.testHighlightsFor(xml, XMLAssert.hl(XMLAssert.r(2, 29, 2, 46), DocumentHighlightKind.Read), XMLAssert.hl(XMLAssert.r(3, 22, 3, 36), DocumentHighlightKind.Write));
    }

    @Test
    public void highlightingOnElementType2() throws BadLocationException {
        String xml = "<?xml version=\"1.1\" ?>\r\n<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" targetNamespace=\"http://www.w3.org/2001/XMLSchema\">\r\n\t<xs:element name=\"elt\" type=\"x|s:aComplexType\" />\r\n\t<xs:complexType name=\"aComplexType\">\r\n\t\t<xs:simpleContent>\r\n\t\t\t<xs:extension base=\"xs:aSimpleTypeA\"></xs:extension>\r\n\t\t</xs:simpleContent>\r\n\t</xs:complexType>\r\n\t\r\n\t<xs:complexType name=\"aComplexType2\">\r\n\t\t<xs:complexContent>\r\n\t\t\t<xs:extension base=\"xs:aComplexType\"></xs:extension>\r\n\t\t</xs:complexContent>\r\n\t</xs:complexType>\r\n\r\n\t<xs:simpleType name=\"aSimpleTypeA\">\r\n\t\t<xs:restriction base=\"xs:ENTITIES\">\r\n\t\t</xs:restriction>\r\n\t</xs:simpleType>\r\n</xs:schema>";
        XMLAssert.testHighlightsFor(xml, XMLAssert.hl(XMLAssert.r(2, 29, 2, 46), DocumentHighlightKind.Read), XMLAssert.hl(XMLAssert.r(3, 22, 3, 36), DocumentHighlightKind.Write));
    }

    @Test
    public void highlightingOnComplexTypeName() throws BadLocationException {
        String xml = "<?xml version=\"1.1\" ?>\r\n<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" targetNamespace=\"http://www.w3.org/2001/XMLSchema\">\r\n\t<xs:element name=\"elt\" type=\"xs:aComplexType\" />\r\n\t<xs:complexType name=\"aC|omplexType\">\r\n\t\t<xs:simpleContent>\r\n\t\t\t<xs:extension base=\"xs:aSimpleTypeA\"></xs:extension>\r\n\t\t</xs:simpleContent>\r\n\t</xs:complexType>\r\n\t\r\n\t<xs:complexType name=\"aComplexType2\">\r\n\t\t<xs:complexContent>\r\n\t\t\t<xs:extension base=\"xs:aComplexType\"></xs:extension>\r\n\t\t</xs:complexContent>\r\n\t</xs:complexType>\r\n\r\n\t<xs:simpleType name=\"aSimpleTypeA\">\r\n\t\t<xs:restriction base=\"xs:ENTITIES\">\r\n\t\t</xs:restriction>\r\n\t</xs:simpleType>\r\n</xs:schema>";
        XMLAssert.testHighlightsFor(xml, XMLAssert.hl(XMLAssert.r(3, 22, 3, 36), DocumentHighlightKind.Write), XMLAssert.hl(XMLAssert.r(2, 29, 2, 46), DocumentHighlightKind.Read), XMLAssert.hl(XMLAssert.r(11, 22, 11, 39), DocumentHighlightKind.Read));
    }

    @Test
    public void highlightingOnSimpleTypeName() throws BadLocationException {
        String xml = "<?xml version=\"1.1\" ?>\r\n<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" targetNamespace=\"http://www.w3.org/2001/XMLSchema\">\r\n\t<xs:element name=\"elt\" type=\"xs:aComplexType\" />\r\n\t<xs:complexType name=\"aComplexType\">\r\n\t\t<xs:simpleContent>\r\n\t\t\t<xs:extension base=\"xs:aSimpleTypeA\"></xs:extension>\r\n\t\t</xs:simpleContent>\r\n\t</xs:complexType>\r\n\t\r\n\t<xs:complexType name=\"aComplexType2\">\r\n\t\t<xs:complexContent>\r\n\t\t\t<xs:extension base=\"xs:aComplexType\"></xs:extension>\r\n\t\t</xs:complexContent>\r\n\t</xs:complexType>\r\n\r\n\t<xs:simpleType name=\"a|SimpleTypeA\">\r\n\t\t<xs:restriction base=\"xs:ENTITIES\">\r\n\t\t</xs:restriction>\r\n\t</xs:simpleType>\r\n</xs:schema>";
        XMLAssert.testHighlightsFor(xml, XMLAssert.hl(XMLAssert.r(15, 21, 15, 35), DocumentHighlightKind.Write), XMLAssert.hl(XMLAssert.r(5, 22, 5, 39), DocumentHighlightKind.Read));
    }

    @Test
    public void noHighlightOnRefWithoutValue() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" ?>\r\n<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\">\r\n\r\n\t<xs:element name=\"resources\">\r\n\t\t<xs:complexType>\r\n\t\t\t<xs:sequence>\r\n\t\t\t\t<xs:element re|f";
        XMLAssert.testHighlightsFor(xml, new DocumentHighlight[0]);
    }

    @Test
    public void highlightWithXSInclude() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"utf-8\" ?>\r\n<xs:schema id=\"tns\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" elementFormDefault=\"qualified\" attributeFormDefault=\"unqualified\">\r\n\t<xs:include schemaLocation=\"src/test/resources/xsd/SchemaB.xsd\" />\r\n  \r\n\t<xs:complexType name=\"Bar\">\r\n\t\t<xs:sequence>\r\n\t\t\t<xs:element ref=\"TypeFr|omB\" />\r\n\t\t</xs:sequence>\r\n\t</xs:complexType>";
        XMLAssert.testHighlightsFor(xml, XMLAssert.hl(XMLAssert.r(6, 19, 6, 30), DocumentHighlightKind.Read));
    }
}

